/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XmlTagNamesIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlNamespaceHelper
extends XmlNamespaceHelper {
    private static final Logger LOG = Logger.getInstance(DefaultXmlNamespaceHelper.class);

    @Override
    protected boolean isAvailable(PsiFile file2) {
        return true;
    }

    @Override
    public void insertNamespaceDeclaration(@NotNull XmlFile file2, @Nullable Editor editor2, @NotNull Set<String> possibleNamespaces, @Nullable String nsPrefix, @Nullable XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        if (file2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(0);
        }
        if (possibleNamespaces == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(1);
        }
        String namespace = possibleNamespaces.iterator().next();
        Project project = file2.getProject();
        XmlTag rootTag = file2.getRootTag();
        assert (rootTag != null);
        XmlAttribute anchor2 = DefaultXmlNamespaceHelper.getAnchor(rootTag);
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)file2);
        String prefix = DefaultXmlNamespaceHelper.getPrefix(file2, nsPrefix, namespace, providers);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        String location = DefaultXmlNamespaceHelper.getLocation(file2, namespace, providers);
        String xsiPrefix = null;
        if (location != null && (xsiPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            rootTag.add((PsiElement)elementFactory.createXmlAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        @NonNls String qname = "xmlns" + (String)(prefix.length() > 0 ? ":" + prefix : "");
        XmlAttribute attribute = elementFactory.createXmlAttribute(qname, namespace);
        if (anchor2 == null) {
            rootTag.add((PsiElement)attribute);
        } else {
            rootTag.addAfter((PsiElement)attribute, (PsiElement)anchor2);
        }
        if (location != null) {
            XmlAttribute locationAttribute = rootTag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
            String pair = namespace + " " + location;
            if (locationAttribute == null) {
                locationAttribute = elementFactory.createXmlAttribute(xsiPrefix + ":schemaLocation", pair);
                rootTag.add((PsiElement)locationAttribute);
            } else {
                String value2 = locationAttribute.getValue();
                if (!StringUtil.notNullize((String)value2).contains(namespace)) {
                    if (value2 == null || StringUtil.isEmptyOrSpaces((String)value2)) {
                        locationAttribute.setValue(pair);
                    } else {
                        locationAttribute.setValue(value2.trim() + " " + pair);
                    }
                }
            }
        }
        XmlUtil.reformatTagStart(rootTag);
        if (editor2 != null && namespace.length() == 0 && (xmlAttribute = rootTag.getAttribute(qname)) != null) {
            XmlAttributeValue value3 = xmlAttribute.getValueElement();
            assert (value3 != null);
            int startOffset = value3.getTextOffset();
            editor2.getCaretModel().moveToOffset(startOffset);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        if (runAfter != null) {
            runAfter.run(prefix);
        }
    }

    private static String getPrefix(XmlFile file2, String nsPrefix, String namespace, List<XmlSchemaProvider> providers) {
        String prefix = nsPrefix;
        if (prefix == null) {
            XmlSchemaProvider provider2;
            Iterator<XmlSchemaProvider> iterator2 = providers.iterator();
            while (iterator2.hasNext() && (prefix = (provider2 = iterator2.next()).getDefaultPrefix(namespace, file2)) == null) {
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    private static XmlAttribute getAnchor(XmlTag rootTag) {
        XmlAttribute[] attributes2 = rootTag.getAttributes();
        XmlAttribute anchor2 = null;
        for (XmlAttribute attribute : attributes2) {
            XmlAttributeDescriptor descriptor2 = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor2 == null || !descriptor2.isRequired())) break;
            anchor2 = attribute;
        }
        return anchor2;
    }

    private static String getLocation(XmlFile file2, String namespace, List<XmlSchemaProvider> providers) {
        String location = null;
        if (namespace.length() > 0) {
            for (XmlSchemaProvider provider2 : providers) {
                Set locations = provider2.getLocations(namespace, file2);
                if (locations == null || locations.isEmpty()) continue;
                location = (String)locations.iterator().next();
            }
        }
        return location;
    }

    @Override
    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element2, @NotNull XmlFile file2) {
        if (element2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(3);
        }
        if (!(element2 instanceof XmlTag)) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(4);
            }
            return set2;
        }
        XmlTag tag2 = (XmlTag)element2;
        String name2 = tag2.getLocalName();
        Set<String> byTagName = this.getNamespacesByTagName(name2, file2);
        if (!byTagName.isEmpty()) {
            HashSet<String> filtered2 = new HashSet<String>(byTagName);
            filtered2.removeAll(Arrays.asList(tag2.knownNamespaces()));
            HashSet<String> hashSet = filtered2;
            if (hashSet == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(5);
            }
            return hashSet;
        }
        Set<String> set3 = DefaultXmlNamespaceHelper.guessNamespace(file2.getProject(), name2);
        set3.removeAll(Arrays.asList(tag2.knownNamespaces()));
        XmlTag parentTag = tag2.getParentTag();
        Iterator<String> i2 = set3.iterator();
        block0: while (i2.hasNext()) {
            String s = i2.next();
            Collection<XmlFile> namespaces = XmlUtil.findNSFilesByURI(s, element2.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)file2));
            for (XmlFile namespace : namespaces) {
                XmlDocument document = namespace.getDocument();
                assert (document != null);
                XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
                assert (nsDescriptor != null);
                if (parentTag != null) continue block0;
                for (XmlElementDescriptor descriptor2 : nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor2 == null) {
                        LOG.error(nsDescriptor + " returned null element for getRootElementsDescriptors() array");
                        continue;
                    }
                    if (descriptor2.getName().equals(name2)) continue block0;
                }
            }
            i2.remove();
        }
        Set<String> set4 = set3;
        if (set4 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(6);
        }
        return set4;
    }

    @NotNull
    private static Set<String> guessNamespace(@NotNull Project project, @NotNull String tagName) {
        Collection<VirtualFile> files2;
        if (project == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(7);
        }
        if (tagName == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(8);
        }
        if ((files2 = XmlTagNamesIndex.getFilesByTagName(tagName, project)).isEmpty()) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(9);
            }
            return set2;
        }
        LinkedHashSet<String> possibleUris = new LinkedHashSet<String>(files2.size());
        for (VirtualFile virtualFile2 : files2) {
            String namespace = XmlNamespaceIndex.getNamespace(virtualFile2, project);
            if (namespace == null) continue;
            possibleUris.add(namespace);
        }
        LinkedHashSet<String> linkedHashSet = possibleUris;
        if (linkedHashSet == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile file2) {
        if (tagName == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(12);
        }
        HashSet set2 = null;
        for (XmlSchemaProvider provider2 : XmlSchemaProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isAvailable(file2)) continue;
            if (set2 == null) {
                set2 = new HashSet();
            }
            set2.addAll(provider2.getAvailableNamespaces(file2, tagName));
        }
        Set<String> set3 = set2 == null ? Collections.emptySet() : set2;
        if (set3 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(13);
        }
        return set3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleNamespaces";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessUnboundNamespaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "guessNamespace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesByTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertNamespaceDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessUnboundNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "guessNamespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesByTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

