/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class XmlSplitTagAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = XmlBundle.message((String)"xml.intention.split.tag.text", (Object[])new Object[0]);
        if (string == null) {
            XmlSplitTagAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.intention.split.tag.family", (Object[])new Object[0]);
        if (string == null) {
            XmlSplitTagAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        PsiElement grandParent;
        PsiElement parent;
        int offset;
        PsiElement psiElement;
        if (project == null) {
            XmlSplitTagAction.$$$reportNull$$$0(2);
        }
        if (file2 instanceof XmlFile && editor2 != null && (psiElement = file2.findElementAt(offset = editor2.getCaretModel().getOffset())) != null && (parent = psiElement.getParent()) instanceof XmlText && parent.getText().trim().length() > 0 && (grandParent = parent.getParent()) != null && !XmlSplitTagAction.isInsideUnsplittableElement(grandParent)) {
            return InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file2, offset) == null;
        }
        return false;
    }

    private static boolean isInsideUnsplittableElement(PsiElement grandParent) {
        if (!(grandParent instanceof HtmlTag) && grandParent.getContainingFile().getLanguage() != XHTMLLanguage.INSTANCE) {
            return false;
        }
        String name2 = ((XmlTag)grandParent).getName();
        return "html".equals(name2) || "body".equals(name2) || "title".equals(name2);
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        PsiElement containingTag;
        int offset;
        PsiElement psiElement;
        if (project == null) {
            XmlSplitTagAction.$$$reportNull$$$0(3);
        }
        if (editor2 != null && (psiElement = file2.findElementAt(offset = editor2.getCaretModel().getOffset())) != null && (containingTag = psiElement.getParent().getParent()) instanceof XmlTag) {
            XmlTag tag2 = (XmlTag)containingTag;
            TextRange tagRange = tag2.getTextRange();
            String name2 = tag2.getName();
            String toInsert = "</" + name2 + "><" + name2 + XmlSplitTagAction.getAttrsWithoutId(tag2) + ">";
            editor2.getDocument().insertString(offset, (CharSequence)toInsert);
            editor2.getCaretModel().moveToOffset(offset + toInsert.length());
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file2, tagRange.getStartOffset(), tagRange.getEndOffset() + toInsert.length());
        }
    }

    private static String getAttrsWithoutId(XmlTag xmlTag) {
        StringBuilder attrsWoId = new StringBuilder();
        for (XmlAttribute attribute : xmlTag.getAttributes()) {
            if ("id".equals(attribute.getName())) continue;
            attrsWoId.append(attribute.getText()).append(" ");
        }
        return attrsWoId.length() == 0 ? "" : " " + attrsWoId;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/XmlSplitTagAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/XmlSplitTagAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

