/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;

public final class FileUtils {
    @NonNls
    public static final String CLASS_RESOURCE_STRING = "*?.class";
    @NonNls
    private static final String SOAP_ADDRESS = "soap:address";

    private FileUtils() {
    }

    public static File saveStreamContentAsFile(String fullFileName, InputStream stream) throws IOException {
        fullFileName = FileUtils.findFreeFileName(fullFileName);
        try (FileOutputStream ostream = new FileOutputStream(fullFileName);){
            int read;
            byte[] buf = new byte[8192];
            while ((read = stream.read(buf, 0, buf.length)) != -1) {
                ((OutputStream)ostream).write(buf, 0, read);
            }
            ostream.flush();
        }
        return new File(fullFileName);
    }

    private static String findFreeFileName(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return filename;
        }
        int dot = filename.lastIndexOf(46);
        String name2 = filename.substring(0, dot);
        String ext = filename.substring(dot);
        int num = 0;
        while ((f = new File(name2 + ++num + ext)).exists()) {
        }
        return name2 + num + ext;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File in, File out) {
        try (FileInputStream fis = new FileInputStream(in);){
            boolean bl;
            try (FileOutputStream fos = new FileOutputStream(out);){
                int i2;
                byte[] buf = new byte[1024];
                while ((i2 = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i2);
                }
                bl = true;
            }
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

