/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.GenerateSchemaFromInstanceDocumentDialog;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class GenerateSchemaFromInstanceDocumentAction
extends AnAction {
    GenerateSchemaFromInstanceDocumentAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateSchemaFromInstanceDocumentAction.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = GenerateSchemaFromInstanceDocumentAction.isAcceptableFile(file2);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateSchemaFromInstanceDocumentAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GenerateSchemaFromInstanceDocumentDialog dialog2 = new GenerateSchemaFromInstanceDocumentDialog(project, file2);
        dialog2.setOkAction(() -> GenerateSchemaFromInstanceDocumentAction.doAction(project, dialog2));
        dialog2.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAction(Project project, GenerateSchemaFromInstanceDocumentDialog dialog2) {
        VirtualFile xsdVFile;
        boolean renamed;
        FileDocumentManager.getInstance().saveAllDocuments();
        String url = dialog2.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        @NonNls LinkedList<String> parameters2 = new LinkedList<String>();
        parameters2.add("-design");
        parameters2.add(Holder.DESIGN_TYPES.get(dialog2.getDesignType()));
        parameters2.add("-simple-content-types");
        parameters2.add(Holder.CONTENT_TYPES.get(dialog2.getSimpleContentType()));
        parameters2.add("-enumerations");
        String enumLimit = dialog2.getEnumerationsLimit();
        parameters2.add("0".equals(enumLimit) ? "never" : enumLimit);
        parameters2.add("-outDir");
        String dirPath = relativeFileDir.getPath();
        parameters2.add(dirPath);
        File expectedSchemaFile = new File(dirPath + File.separator + relativeFile.getName() + "0.xsd");
        if (expectedSchemaFile.exists() && !expectedSchemaFile.delete()) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"cant.delete.file", (Object[])new Object[]{expectedSchemaFile.getPath()}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        parameters2.add("-outPrefix");
        parameters2.add(relativeFile.getName());
        parameters2.add(url);
        File xsd = new File(dirPath + File.separator + dialog2.getTargetSchemaName());
        VirtualFile xsdFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd);
        if (xsdFile != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    xsdFile.delete(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        SecurityManager old = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkExit(int status) {
                    throw new SecurityException();
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            Inst2Xsd.main((String[])ArrayUtilRt.toStringArray(parameters2));
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"xml2xsd.generator.error.message", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml2xsd.generator.error", (Object[])new Object[0]));
            return;
        }
        finally {
            System.setSecurityManager(old);
        }
        if (expectedSchemaFile.exists() && !(renamed = expectedSchemaFile.renameTo(xsd))) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"cant.rename.file", (Object[])new Object[]{expectedSchemaFile.getPath(), xsd.getPath()}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
        if ((xsdVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xsd)) != null) {
            FileEditorManager.getInstance((Project)project).openFile(xsdVFile, true);
        } else {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"xml2xsd.generator.error.message", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml2xsd.generator.error", (Object[])new Object[0]));
        }
    }

    public static boolean isAcceptableFile(VirtualFile file2) {
        return file2 != null && "xml".equalsIgnoreCase(file2.getExtension());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/xml/actions/xmlbeans/GenerateSchemaFromInstanceDocumentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final Map<String, String> DESIGN_TYPES = new HashMap<String, String>();
        private static final Map<String, String> CONTENT_TYPES;

        private Holder() {
        }

        static {
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getLocalElementsGlobalComplexTypes(), "vb");
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getLocalElementsTypes(), "ss");
            DESIGN_TYPES.put(GenerateSchemaFromInstanceDocumentDialog.getGlobalElementsLocalTypes(), "rd");
            CONTENT_TYPES = new HashMap<String, String>();
            CONTENT_TYPES.put("smart", "smart");
            CONTENT_TYPES.put("string", "string");
        }
    }
}

