/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BreadcrumbsUtilEx {
    @Nullable
    static FileViewProvider findViewProvider(VirtualFile file2, Project project) {
        if (file2 == null || file2.isDirectory()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findViewProvider(file2);
    }

    @Nullable
    static BreadcrumbsProvider findProvider(VirtualFile file2, @Nullable Project project, @Nullable Boolean forcedShown) {
        return project == null ? null : BreadcrumbsUtilEx.findProvider(BreadcrumbsUtilEx.findViewProvider(file2, project), forcedShown);
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(@Nullable FileViewProvider viewProvider, @Nullable Boolean forceShown) {
        if (viewProvider == null) {
            return null;
        }
        if (forceShown == null) {
            return BreadcrumbsUtilEx.findProvider(true, viewProvider);
        }
        return forceShown != false ? BreadcrumbsUtilEx.findProvider(false, viewProvider) : null;
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(boolean checkSettings2, @NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            BreadcrumbsUtilEx.$$$reportNull$$$0(0);
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (checkSettings2 && !settings.isBreadcrumbsShown()) {
            return null;
        }
        Language baseLang = viewProvider.getBaseLanguage();
        if (checkSettings2 && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(baseLang)) {
            return null;
        }
        BreadcrumbsProvider provider2 = BreadcrumbsUtil.getInfoProvider((Language)baseLang);
        if (provider2 == null) {
            for (Language language2 : viewProvider.getLanguages()) {
                if (checkSettings2 && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(language2) || (provider2 = BreadcrumbsUtil.getInfoProvider((Language)language2)) == null) continue;
                break;
            }
        }
        return provider2;
    }

    public static boolean isBreadcrumbsShownFor(Language language2) {
        String id2 = BreadcrumbsUtilEx.findLanguageWithBreadcrumbSettings(language2);
        return EditorSettingsExternalizable.getInstance().isBreadcrumbsShownFor(id2);
    }

    public static String findLanguageWithBreadcrumbSettings(Language language2) {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        for (Language base = language2; base != null; base = base.getBaseLanguage()) {
            if (!settings.hasBreadcrumbSettings(base.getID())) continue;
            return base.getID();
        }
        return language2.getID();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/xml/breadcrumbs/BreadcrumbsUtilEx", "findProvider"));
    }
}

