/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.LazyTooltipCrumb;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiCrumb
extends Crumb.Impl
implements NavigatableCrumb,
LazyTooltipCrumb {
    private final PsiAnchor anchor;
    private volatile BreadcrumbsProvider provider;
    private volatile @NlsContexts.Tooltip String tooltip;
    final CrumbPresentation presentation;

    PsiCrumb(@NotNull PsiElement element2, @NotNull BreadcrumbsProvider provider2, @Nullable CrumbPresentation presentation2) {
        if (element2 == null) {
            PsiCrumb.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            PsiCrumb.$$$reportNull$$$0(1);
        }
        super(provider2.getElementIcon(element2), provider2.getElementInfo(element2), null, provider2.getContextActions(element2));
        this.anchor = PsiAnchor.create(element2);
        this.provider = provider2;
        this.presentation = presentation2;
    }

    public String getTooltip() {
        if (this.needCalculateTooltip()) {
            PsiElement element2 = PsiCrumb.getElement((Crumb)this);
            this.tooltip = element2 == null ? null : this.provider.getElementTooltip(element2);
            this.provider = null;
            if (element2 != null) {
                UIEventLogger.BreadcrumbShowTooltip.log(element2.getProject(), (Object)element2.getLanguage());
            }
        }
        return this.tooltip;
    }

    public boolean needCalculateTooltip() {
        return this.provider != null && this.tooltip == null;
    }

    public int getAnchorOffset() {
        PsiElement element2 = this.anchor.retrieve();
        return element2 != null ? element2.getTextOffset() : -1;
    }

    @Nullable
    public TextRange getHighlightRange() {
        PsiElement element2 = this.anchor.retrieve();
        return element2 != null ? element2.getTextRange() : null;
    }

    public void navigate(@NotNull Editor editor2, boolean withSelection) {
        TextRange range2;
        int offset;
        if (editor2 == null) {
            PsiCrumb.$$$reportNull$$$0(2);
        }
        if ((offset = this.getAnchorOffset()) != -1) {
            PsiCrumb.moveEditorCaretTo(editor2, offset);
        }
        PsiElement element2 = PsiCrumb.getElement((Crumb)this);
        if (withSelection && (range2 = this.getHighlightRange()) != null) {
            editor2.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
        UIEventLogger.BreadcrumbNavigate.log(element2 != null ? element2.getProject() : null, (Object)(element2 != null ? element2.getLanguage() : null), (Object)withSelection);
    }

    private static void moveEditorCaretTo(Editor editor2, int offset) {
        if (offset >= 0) {
            editor2.getCaretModel().moveToOffset(offset);
            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Contract(value="null -> null")
    static PsiElement getElement(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).anchor.retrieve() : null;
    }

    @Contract(value="null -> null", pure=true)
    static CrumbPresentation getPresentation(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).presentation : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiCrumb";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

