/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckTagEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag2) {
                ASTNode node2;
                ASTNode child2;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag2) && (child2 = XmlChildRole.START_TAG_END_FINDER.findChild(tag2.getNode())) != null && (node2 = child2.getTreeNext()) != null && node2.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    holder.registerProblem((PsiElement)tag2, XmlAnalysisBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag2) ? new Fix(tag2) : null});
                }
            }
        };
    }

    static boolean isCollapsibleTag(XmlTag tag2) {
        String name2 = StringUtil.toLowerCase((String)tag2.getName());
        return tag2.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name2) || "br".equals(name2) || "meta".equals(name2) || "img".equals(name2) || "input".equals(name2) || "hr".equals(name2) || XmlExtension.isCollapsible(tag2);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckTagEmptyBody";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
    }

    public static class Fix
    extends CollapseTagIntention {
        private final SmartPsiElementPointer<XmlTag> myPointer;

        public Fix(XmlTag tag2) {
            this.myPointer = SmartPointerManager.getInstance((Project)tag2.getProject()).createSmartPsiElementPointer((PsiElement)tag2);
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
            XmlTag tag2;
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if ((tag2 = (XmlTag)this.myPointer.getElement()) == null) {
                return;
            }
            Fix.applyFix(project, (PsiElement)tag2);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

