/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlTypedHandlersAdditionalSupport;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HTMLControls;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class HtmlUtil {
    private static final Logger LOG = Logger.getInstance(HtmlUtil.class);
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    public static final String HTML5_DATA_ATTR_PREFIX = "data-";
    @NlsSafe
    public static final String SCRIPT_TAG_NAME = "script";
    @NlsSafe
    public static final String STYLE_TAG_NAME = "style";
    @NlsSafe
    public static final String TEMPLATE_TAG_NAME = "template";
    @NlsSafe
    public static final String TEXTAREA_TAG_NAME = "textarea";
    @NlsSafe
    public static final String TITLE_TAG_NAME = "title";
    @NlsSafe
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    @NlsSafe
    public static final String SRC_ATTRIBUTE_NAME = "src";
    @NlsSafe
    public static final String ID_ATTRIBUTE_NAME = "id";
    @NlsSafe
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    @NlsSafe
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    @NlsSafe
    public static final String LANGUAGE_ATTRIBUTE_NAME = "language";
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Refresh", "Retry-After", "Server", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final Set<String> EMPTY_TAGS_MAP = new HashSet<String>();
    private static final Set<String> OPTIONAL_END_TAGS_MAP = ContainerUtil.set((Object[])new String[]{"head", "p", "li", "dd", "dt", "thead", "tfoot", "tbody", "colgroup", "tr", "th", "td", "option", "embed", "noembed", "caption"});
    private static final Set<String> BLOCK_TAGS_MAP = ContainerUtil.set((Object[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment"});
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = ContainerUtil.set((Object[])new String[]{"a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"});
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = ContainerUtil.set((Object[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "pre"});
    private static final Set<String> HTML5_TAGS_SET = ContainerUtil.set((Object[])new String[]{"article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main"});
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_MAP = new HashMap<String, Set<String>>();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(@NotNull XmlTag tag2, boolean lowerCase) {
        if (tag2 == null) {
            HtmlUtil.$$$reportNull$$$0(0);
        }
        XmlExtension extension2 = XmlExtension.getExtensionByElement((PsiElement)tag2);
        String name2 = tag2.getName();
        boolean result2 = EMPTY_TAGS_MAP.contains(!lowerCase || tag2.isCaseSensitive() ? name2 : StringUtil.toLowerCase((String)name2));
        return result2 && (extension2 == null || !extension2.isSingleTagException(tag2));
    }

    public static boolean isSingleHtmlTag(String tagName) {
        return EMPTY_TAGS_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    public static boolean isSingleHtmlTagL(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName);
    }

    public static boolean isOptionalEndForHtmlTag(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    public static boolean isOptionalEndForHtmlTagL(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName);
    }

    public static boolean canTerminate(String childTagName, String tagName) {
        Set<String> closingTags = AUTO_CLOSE_BY_MAP.get(tagName);
        return closingTags != null && closingTags.contains(childTagName);
    }

    public static boolean isHtmlBlockTag(String tagName) {
        return BLOCK_TAGS_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    public static boolean isPossiblyInlineTag(String tagName) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isHtmlBlockTagL(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(StringUtil.toLowerCase((String)tagName));
    }

    public static boolean isInlineTagContainerL(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor2, XmlTag element2, List<? super XmlElementDescriptor> variants) {
        block5: {
            PsiElement parent;
            block6: {
                String name2 = descriptor2.getName((PsiElement)element2);
                if (name2 == null || !HtmlUtil.isOptionalEndForHtmlTag(name2)) break block5;
                parent = element2.getParent();
                if (parent instanceof XmlTag && XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parent.getNode()) != null) {
                    return;
                }
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block6;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor2 || parentDescriptor == null) break block5;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName())) continue;
                    variants.add((XmlElementDescriptor)elementsDescriptor);
                }
                break block5;
            }
            if (parent instanceof HtmlDocumentImpl) {
                XmlNSDescriptor nsDescriptor = descriptor2.getNSDescriptor();
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName()) || variants.contains(elementDescriptor)) continue;
                    variants.add((XmlElementDescriptor)elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static boolean isShortNotationOfBooleanAttributePreferred() {
        return Registry.is((String)"html.prefer.short.notation.of.boolean.attributes", (boolean)true);
    }

    @TestOnly
    public static void setShortNotationOfBooleanAttributeIsPreferred(boolean value2, Disposable parent) {
        final boolean oldValue = HtmlUtil.isShortNotationOfBooleanAttributePreferred();
        final RegistryValue registryValue = Registry.get((String)"html.prefer.short.notation.of.boolean.attributes");
        registryValue.setValue(value2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                registryValue.setValue(oldValue);
            }
        });
    }

    public static boolean isBooleanAttribute(@NotNull XmlAttributeDescriptor descriptor2, @Nullable PsiElement context2) {
        if (descriptor2 == null) {
            HtmlUtil.$$$reportNull$$$0(1);
        }
        if (descriptor2.isEnumerated()) {
            String[] values2 = descriptor2.getEnumeratedValues();
            if (values2 == null) {
                return false;
            }
            if (values2.length == 2) {
                return values2[0].isEmpty() && values2[1].equals(descriptor2.getName()) || values2[1].isEmpty() && values2[0].equals(descriptor2.getName());
            }
            if (values2.length == 1) {
                return descriptor2.getName().equals(values2[0]);
            }
        }
        return context2 != null && HtmlUtil.isCustomBooleanAttribute(descriptor2.getName(), context2);
    }

    public static boolean isCustomBooleanAttribute(@NotNull String attributeName, @NotNull PsiElement context2) {
        String entitiesString;
        if (attributeName == null) {
            HtmlUtil.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            HtmlUtil.$$$reportNull$$$0(3);
        }
        if ((entitiesString = HtmlUtil.getEntitiesString(context2, "HtmlUnknownBooleanAttribute")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(PsiElement context2) {
        String entitiesString = HtmlUtil.getEntitiesString(context2, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index2 = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.isEmpty()) continue;
            descriptors[index2++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context2) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context2) {
        String entitiesString = HtmlUtil.getEntitiesString(context2, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index2 = 0;
        while (tokenizer.hasMoreElements()) {
            String tagName = tokenizer.nextToken();
            if (tagName.isEmpty()) continue;
            descriptors[index2++] = new CustomXmlTagDescriptor(tagName);
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context2, @NotNull String inspectionName) {
        if (inspectionName == null) {
            HtmlUtil.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            return null;
        }
        PsiFile containingFile = context2.getContainingFile().getOriginalFile();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(context2.getProject()).getCurrentProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile.getUnwrappedTool(inspectionName, (PsiElement)containingFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context2) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors((PsiElement)context2));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context2) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) == null ? htmlFile.getName() : vFile.getPath()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return HtmlUtil.isHtmlTagContainingFile((PsiElement)doc) && Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + doctype.getMarkupDecl();
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context2) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlDocument.class);
        if (doc == null && context2 != null) {
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(context2.getProject()));
        }
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            HtmlUtil.$$$reportNull$$$0(5);
        }
        if (!tag2.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag2, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag2.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context2) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(String tagName) {
        return HTML5_TAGS_SET.contains(tagName);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return attributeName.startsWith(HTML5_DATA_ATTR_PREFIX);
    }

    @Nullable
    public static String getHrefBase(XmlFile file2) {
        XmlTag root2 = file2.getRootTag();
        XmlTag head = root2 != null ? root2.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor2) {
        PsiElement declaration = descriptor2.getDeclaration();
        PsiFile file2 = declaration != null ? declaration.getContainingFile() : null;
        String name2 = file2 != null ? file2.getName() : null;
        return "meta.rnc".equals(name2) || "web-forms.rnc".equals(name2) || "embed.rnc".equals(name2) || "tables.rnc".equals(name2) || "media.rnc".equals(name2);
    }

    public static boolean tagHasHtml5Schema(@NotNull XmlTag context2) {
        XmlElementDescriptor descriptor2;
        if (context2 == null) {
            HtmlUtil.$$$reportNull$$$0(6);
        }
        XmlNSDescriptor nsDescriptor = (descriptor2 = context2.getDescriptor()) != null ? descriptor2.getNSDescriptor() : null;
        return HtmlUtil.isHtml5Schema(nsDescriptor);
    }

    public static boolean isHtml5Schema(@Nullable XmlNSDescriptor nsDescriptor) {
        XmlFile descriptorFile = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : null;
        String descriptorPath = descriptorFile != null ? descriptorFile.getVirtualFile().getPath() : null;
        return Objects.equals(Html5SchemaProvider.getHtml5SchemaLocation(), descriptorPath) || Objects.equals(Html5SchemaProvider.getXhtml5SchemaLocation(), descriptorPath);
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content2) {
        String name2;
        if (content2 == null) {
            HtmlUtil.$$$reportNull$$$0(7);
        }
        int charPrefix = StringUtil.indexOf((CharSequence)content2, (CharSequence)CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content2.length() && Character.isWhitespace(content2.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content2.length() && content2.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = StringUtil.indexOf((CharSequence)content2, (CharSequence)CHARSET, (int)charsetPrefixEnd);
        }
        if (content2.length() > charPrefix + 200 && (name2 = HtmlUtil.tryFetchCharsetFromFileContent(content2.subSequence(0, charPrefix + 200))) != null) {
            return CharsetToolkit.forName((String)name2);
        }
        name = HtmlUtil.tryFetchCharsetFromFileContent(content2);
        return CharsetToolkit.forName((String)name);
    }

    private static String tryFetchCharsetFromFileContent(@NotNull CharSequence content2) {
        if (content2 == null) {
            HtmlUtil.$$$reportNull$$$0(8);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content2).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new HashSet<String>();
                boolean metHttpEquiv;
                boolean metHtml5Charset;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId2, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startOffset, int endOffset, int headerEndOffset) {
                    @NonNls String name2 = StringUtil.toLowerCase((String)localName.toString());
                    this.inTag.add(name2);
                    if (!this.inTag.contains("head") && !"html".equals(name2)) {
                        this.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    @NonNls String name2 = StringUtil.toLowerCase((String)localName.toString());
                    if ("meta".equals(name2) && (this.metHttpEquiv || this.metHtml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start2 = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                            if (start2 == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start2 += HtmlUtil.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start2, end);
                        } else {
                            charsetName = StringUtil.stripQuotesAroundValue((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        this.terminate();
                    }
                    if ("head".equals(name2)) {
                        this.terminate();
                    }
                    this.inTag.remove(name2);
                    this.metHttpEquiv = false;
                    this.metHtml5Charset = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v, int startoffset, int endoffset) {
                    @NonNls String name2 = StringUtil.toLowerCase((String)localName.toString());
                    if (this.inTag.contains("meta")) {
                        @NonNls String value2 = StringUtil.toLowerCase((String)v.toString());
                        if (name2.equals("http-equiv")) {
                            this.metHttpEquiv |= value2.equals("content-type");
                        } else if (name2.equals(HtmlUtil.CHARSET)) {
                            this.metHtml5Charset = true;
                            this.contentAttributeValue = value2;
                        }
                        if (name2.equals("content")) {
                            this.contentAttributeValue = value2;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display2, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(@NotNull String message2, int startOffset, int endOffset) {
                    if (message2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/xml/util/HtmlUtil$4", "error"));
                }
            });
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)charsetNameRef.get();
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return "br".equalsIgnoreCase(tagName);
    }

    public static boolean hasHtml(@NotNull PsiFile file2) {
        if (file2 == null) {
            HtmlUtil.$$$reportNull$$$0(9);
        }
        return HtmlUtil.isHtmlFile((PsiElement)file2) || file2.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    public static boolean supportsXmlTypedHandlers(@NotNull PsiFile file2) {
        if (file2 == null) {
            HtmlUtil.$$$reportNull$$$0(10);
        }
        return XmlTypedHandlersAdditionalSupport.supportsTypedHandlers((PsiFile)file2);
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            HtmlUtil.$$$reportNull$$$0(11);
        }
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("ftp://");
    }

    public static boolean isHtmlFile(@NotNull PsiElement element2) {
        Language language2;
        if (element2 == null) {
            HtmlUtil.$$$reportNull$$$0(12);
        }
        return (language2 = element2.getLanguage()).isKindOf((Language)HTMLLanguage.INSTANCE) || language2.isKindOf((Language)XHTMLLanguage.INSTANCE);
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            HtmlUtil.$$$reportNull$$$0(13);
        }
        return (fileType = file2.getFileType()) == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile != null) {
            XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class, (boolean)false);
            if (tag2 instanceof HtmlTag) {
                return true;
            }
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlDocument.class, (boolean)false);
            if (document instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider2 = containingFile.getViewProvider();
            Language language2 = provider2 instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider2).getTemplateDataLanguage() : provider2.getBaseLanguage();
            return language2 == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag2) {
        return tag2 != null && tag2.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    @NotNull
    public static Iterable<String> splitClassNames(@Nullable String classAttributeValue) {
        Iterable<String> iterable = classAttributeValue != null ? StringUtil.tokenize((String)classAttributeValue, (String)" \t,") : Collections.emptyList();
        if (iterable == null) {
            HtmlUtil.$$$reportNull$$$0(14);
        }
        return iterable;
    }

    @Contract(value="!null -> !null")
    @NlsSafe
    public static String getTagPresentation(@Nullable XmlTag tag2) {
        String classValue;
        if (tag2 == null) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder(tag2.getLocalName());
        String idValue = HtmlUtil.getAttributeValue(tag2, ID_ATTRIBUTE_NAME);
        if (idValue != null) {
            builder2.append('#').append(idValue);
        }
        if ((classValue = HtmlUtil.getAttributeValue(tag2, CLASS_ATTRIBUTE_NAME)) != null) {
            for (String className : HtmlUtil.splitClassNames(classValue)) {
                builder2.append('.').append(className);
            }
        }
        return builder2.toString();
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag2, @NotNull String attrName) {
        String value2;
        XmlAttribute classAttribute;
        if (tag2 == null) {
            HtmlUtil.$$$reportNull$$$0(15);
        }
        if (attrName == null) {
            HtmlUtil.$$$reportNull$$$0(16);
        }
        if ((classAttribute = HtmlUtil.getAttributeByName(tag2, attrName)) != null && !HtmlUtil.containsOuterLanguageElements((PsiElement)classAttribute) && !StringUtil.isEmptyOrSpaces((String)(value2 = classAttribute.getValue()))) {
            return value2;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute getAttributeByName(@NotNull XmlTag tag2, @NotNull String name2) {
        if (tag2 == null) {
            HtmlUtil.$$$reportNull$$$0(17);
        }
        if (name2 == null) {
            HtmlUtil.$$$reportNull$$$0(18);
        }
        for (PsiElement child2 = tag2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            PsiElement nameElement;
            if (!(child2 instanceof XmlAttribute) || (nameElement = child2.getFirstChild()) == null || nameElement.getNode().getElementType() != XmlTokenType.XML_NAME || !name2.equalsIgnoreCase(nameElement.getText())) continue;
            return (XmlAttribute)child2;
        }
        return null;
    }

    private static boolean containsOuterLanguageElements(@NotNull PsiElement element2) {
        if (element2 == null) {
            HtmlUtil.$$$reportNull$$$0(19);
        }
        for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (child2 instanceof CompositeElement) {
                return HtmlUtil.containsOuterLanguageElements(child2);
            }
            if (!(child2 instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    public static List<XmlAttributeValue> getIncludedPathsElements(@NotNull XmlFile file2) {
        if (file2 == null) {
            HtmlUtil.$$$reportNull$$$0(20);
        }
        final ArrayList result2 = new ArrayList();
        file2.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

            public void visitXmlTag(XmlTag tag2) {
                XmlAttribute attribute = null;
                if ("link".equalsIgnoreCase(tag2.getName())) {
                    attribute = tag2.getAttribute("href");
                } else if (HtmlUtil.SCRIPT_TAG_NAME.equalsIgnoreCase(tag2.getName()) || "img".equalsIgnoreCase(tag2.getName())) {
                    attribute = tag2.getAttribute(HtmlUtil.SRC_ATTRIBUTE_NAME);
                }
                if (attribute != null) {
                    result2.add(attribute.getValueElement());
                }
                super.visitXmlTag(tag2);
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element2.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/HtmlUtil$5", "visitElement"));
            }
        });
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    static {
        for (HTMLControls.Control control2 : HTMLControls.getControls()) {
            String tagName = StringUtil.toLowerCase((String)control2.name);
            if (control2.endTag == HTMLControls.TagState.FORBIDDEN) {
                EMPTY_TAGS_MAP.add(tagName);
            }
            AUTO_CLOSE_BY_MAP.put(tagName, new HashSet<String>(control2.autoClosedBy));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "splitClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCustomBooleanAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEntitiesString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlTag";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tagHasHtml5Schema";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetFromMetaTag";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryFetchCharsetFromFileContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasHtml";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsXmlTypedHandlers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasHtmlPrefix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlFile";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsOuterLanguageElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedPathsElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CustomXmlTagDescriptor
    extends XmlElementDescriptorImpl {
        private final String myTagName;

        CustomXmlTagDescriptor(String tagName) {
            super(null);
            this.myTagName = tagName;
        }

        @Override
        public String getName(PsiElement context2) {
            return this.myTagName;
        }

        @Override
        public String getDefaultName() {
            return this.myTagName;
        }

        @Override
        public boolean allowElementsFromNamespace(String namespace, XmlTag context2) {
            return true;
        }
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

