/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private static final Logger LOG = Logger.getInstance(InclusionProvider.class);
    private final XmlTag myXincludeTag;

    InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    public static PsiElement @NotNull [] getIncludedTags(XmlTag xincludeTag) {
        if (!XmlTagImpl.shouldProcessIncludesNow()) {
            LOG.error("XML include processing is disabled during indexing, please fix callers who insists on enabling it");
            IdempotenceChecker.logTrace("!shouldProcessIncludesNow");
            if (PsiElement.EMPTY_ARRAY == null) {
                InclusionProvider.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)xincludeTag, (CachedValueProvider)new InclusionProvider(xincludeTag));
        if (psiElementArray == null) {
            InclusionProvider.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result2 = (PsiElement[])RecursionManager.doPreventingRecursion((Object)this.myXincludeTag, (boolean)true, () -> InclusionProvider.computeInclusion(this.myXincludeTag));
        if (result2 == null) {
            IdempotenceChecker.logTrace("InclusionProvider recursion prevented");
        }
        return CachedValueProvider.Result.create((Object)(result2 == null ? PsiElement.EMPTY_ARRAY : result2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (rootTag == null) {
            InclusionProvider.$$$reportNull$$$0(2);
        }
        if (xpointer != null && (matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            Object[] tags = rootTag.getSubTags();
            String subTagName = matcher.group(2);
            if (subTagName == null) {
                return tags;
            }
            XmlTag subTag = (XmlTag)ContainerUtil.find((Object[])tags, t -> subTagName.substring(1).equals(t.getName()));
            return subTag == null ? XmlTag.EMPTY : subTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    private static PsiElement @Nullable [] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace("InclusionProvider resolved file=" + included);
        }
        XmlDocument document = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace("InclusionProvider found " + includeTag.length + " tags by " + xpointer);
            }
            PsiElement[] result2 = new PsiElement[includeTag.length];
            for (int i2 = 0; i2 < includeTag.length; ++i2) {
                result2[i2] = new IncludedXmlTag(includeTag[i2], (PsiElement)xincludeTag.getParentTag());
            }
            return result2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractXpointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

