/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.RoleFinder;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlTagRuleProvider;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlTagRuleProviderBase
extends XmlTagRuleProvider {
    public static RequireAttributeOneOf requireAttr(String ... attributeNames) {
        return new RequireAttributeOneOf(attributeNames);
    }

    public static ShouldHaveParams shouldHaveParams() {
        return new ShouldHaveParams();
    }

    public static XmlTagRuleProvider.Rule unusedIfPresent(String attrPresent, String ... attrUnused) {
        Effect[] effects = new Effect[attrUnused.length];
        for (int i2 = 0; i2 < effects.length; ++i2) {
            effects[i2] = XmlTagRuleProviderBase.unused(attrUnused[i2], XmlAnalysisBundle.message((String)"xml.inspections.attribute.unused.because.other.attribute.present", (Object[])new Object[]{attrUnused[i2], attrPresent}));
        }
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), effects);
    }

    public static XmlTagRuleProvider.Rule unusedAllIfPresent(String attrPresent, String ... attrUnused) {
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), new InvalidAllExpectSome(XmlAnalysisBundle.message((String)"xml.inspections.all.attributes.unused.because.an.attribute.present", (Object[])new Object[]{attrPresent}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, (String[])ArrayUtil.append((Object[])attrUnused, (Object)attrPresent)));
    }

    public static Effect invalid(String attrName, @InspectionMessage String text2) {
        return new InvalidAttrEffect(attrName, text2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static Effect unused(String attrName) {
        return new InvalidAttrEffect(attrName, XmlAnalysisBundle.message((String)"xml.inspections.attribute.unused", (Object[])new Object[]{attrName}), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unused(String attrName, @InspectionMessage String text2) {
        return new InvalidAttrEffect(attrName, text2, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unusedAll(@InspectionMessage String text2, String ... attrNames) {
        return new InvalidAllExpectSome(text2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, attrNames);
    }

    public static XmlTagRuleProvider.Rule rule(Condition<? super XmlTag> condition, Effect ... effect) {
        return new ConditionRule(condition, effect);
    }

    @Nullable
    public static PsiElement getXmlElement(RoleFinder roleFinder, XmlElement tag2) {
        ASTNode tagNode = tag2.getNode();
        if (tagNode == null) {
            return null;
        }
        ASTNode nameElement = roleFinder.findChild(tagNode);
        if (nameElement == null) {
            return null;
        }
        return nameElement.getPsi();
    }

    @Nullable
    public static PsiElement getTagNameElement(XmlTag tag2) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.START_TAG_NAME_FINDER, (XmlElement)tag2);
    }

    @Nullable
    public static PsiElement getAttributeNameElement(XmlAttribute attribute) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.ATTRIBUTE_NAME_FINDER, (XmlElement)attribute);
    }

    public static boolean isClosedTag(XmlTag tag2) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.EMPTY_TAG_END_FINDER, (XmlElement)tag2) != null || XmlTagRuleProviderBase.getXmlElement(XmlChildRole.CLOSING_TAG_START_FINDER, (XmlElement)tag2) != null;
    }

    public static Condition<XmlTag> ifAttrPresent(String attrName) {
        return tag2 -> tag2.getAttribute(attrName) != null;
    }

    public static class RequireAttributeOneOf
    extends ShouldHaveParams {
        private final String[] myAttributeNames;
        private final ProblemHighlightType myProblemHighlightType;

        public RequireAttributeOneOf(String ... attributeNames) {
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public RequireAttributeOneOf(@NotNull ProblemHighlightType problemHighlightType, String ... attributeNames) {
            if (problemHighlightType == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(0);
            }
            assert (attributeNames.length > 0);
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = problemHighlightType;
        }

        public String[] getAttributeNames() {
            return this.myAttributeNames;
        }

        public void annotate(@NotNull XmlTag tag2, @NotNull ProblemsHolder holder) {
            if (tag2 == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(1);
            }
            if (holder == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(2);
            }
            for (String attributeName : this.myAttributeNames) {
                if (tag2.getAttribute(attributeName) == null) continue;
                return;
            }
            if (!XmlTagRuleProviderBase.isClosedTag(tag2)) {
                return;
            }
            PsiElement tagNameElement = XmlTagRuleProviderBase.getTagNameElement(tag2);
            if (tagNameElement == null) {
                return;
            }
            LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
            if (holder.isOnTheFly()) {
                fixes = new LocalQuickFix[this.myAttributeNames.length];
                for (int i2 = 0; i2 < this.myAttributeNames.length; ++i2) {
                    fixes[i2] = XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag2, this.myAttributeNames[i2], new String[0]);
                }
            }
            holder.registerProblem(tagNameElement, XmlAnalysisBundle.message((String)"xml.inspections.tag.should.have.one.of.following.attributes.0", (Object[])new Object[]{StringUtil.join((String[])this.myAttributeNames, (String)", ")}), this.myProblemHighlightType, fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemHighlightType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$RequireAttributeOneOf";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "annotate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ShouldHaveParams
    extends XmlTagRuleProvider.Rule {
        public boolean needAtLeastOneAttribute(@NotNull XmlTag tag2) {
            if (tag2 == null) {
                ShouldHaveParams.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagRuleProviderBase$ShouldHaveParams", "needAtLeastOneAttribute"));
        }
    }

    public static class ConditionRule
    extends XmlTagRuleProvider.Rule {
        private final Condition<? super XmlTag> myCondition;
        private final Effect[] myEffect;

        public ConditionRule(Condition<? super XmlTag> condition, Effect ... effect) {
            this.myCondition = condition;
            this.myEffect = effect;
        }

        public void annotate(@NotNull XmlTag tag2, @NotNull ProblemsHolder holder) {
            if (tag2 == null) {
                ConditionRule.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                ConditionRule.$$$reportNull$$$0(1);
            }
            if (this.myCondition.value((Object)tag2)) {
                for (Effect effect : this.myEffect) {
                    effect.annotate(tag2, holder);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$ConditionRule";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InvalidAllExpectSome
    extends Effect {
        private final String[] myAttrNames;
        private final @InspectionMessage String myText;
        private final ProblemHighlightType myType;

        public InvalidAllExpectSome(@InspectionMessage String text2, ProblemHighlightType type, String ... attrNames) {
            this.myAttrNames = attrNames;
            this.myText = text2;
            this.myType = type;
        }

        @Override
        public void annotate(@NotNull XmlTag tag2, @NotNull ProblemsHolder holder) {
            if (tag2 == null) {
                InvalidAllExpectSome.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InvalidAllExpectSome.$$$reportNull$$$0(1);
            }
            for (XmlAttribute xmlAttribute : tag2.getAttributes()) {
                PsiElement attributeNameElement;
                String attrName = xmlAttribute.getName();
                if (ArrayUtil.contains((String)attrName, (String[])this.myAttrNames) || (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(xmlAttribute)) == null) continue;
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new LocalQuickFix[]{new RemoveAttributeIntentionFix(attrName)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$InvalidAllExpectSome";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InvalidAttrEffect
    extends Effect {
        private final String myAttrName;
        private final @InspectionMessage String myText;
        private final ProblemHighlightType myType;

        public InvalidAttrEffect(String attrName, @InspectionMessage String text2, ProblemHighlightType type) {
            this.myAttrName = attrName;
            this.myText = text2;
            this.myType = type;
        }

        @Override
        public void annotate(@NotNull XmlTag tag2, @NotNull ProblemsHolder holder) {
            PsiElement attributeNameElement;
            XmlAttribute attribute;
            if (tag2 == null) {
                InvalidAttrEffect.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InvalidAttrEffect.$$$reportNull$$$0(1);
            }
            if ((attribute = tag2.getAttribute(this.myAttrName)) != null && (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(attribute)) != null) {
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new LocalQuickFix[]{new RemoveAttributeIntentionFix(this.myAttrName)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$InvalidAttrEffect";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Effect {
        public abstract void annotate(@NotNull XmlTag var1, @NotNull ProblemsHolder var2);
    }
}

