/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static final Topic<Runnable> JSON_SCHEMA_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Schema.Changed", Runnable.class);
    public static final Topic<Runnable> JSON_DEPS_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Deps.Changed", Runnable.class);

    @NotNull
    public static JsonSchemaUpdater startListening(@NotNull Project project, @NotNull JsonSchemaService service, @NotNull MessageBusConnection connection) {
        if (project == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(2);
        }
        final JsonSchemaUpdater updater = new JsonSchemaUpdater(project, service);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file2) {
                if (file2 != null) {
                    updater.onFileChange(file2.getViewProvider().getVirtualFile());
                }
            }
        }, (Disposable)service);
        JsonSchemaUpdater jsonSchemaUpdater = updater;
        if (jsonSchemaUpdater == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(3);
        }
        return jsonSchemaUpdater;
    }

    private JsonSchemaVfsListener(final @NotNull JsonSchemaUpdater updater) {
        if (updater == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(4);
        }
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            @NotNull
            private final JsonSchemaUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "schemaFile";
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startListening";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startListening";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JsonSchemaUpdater {
        private static final int DELAY_MS = 200;
        @NotNull
        private final Project myProject;
        private final ZipperUpdater myUpdater;
        @NotNull
        private final JsonSchemaService myService;
        private final Set<VirtualFile> myDirtySchemas;
        private final Runnable myRunnable;
        private final ExecutorService myTaskExecutor;

        protected JsonSchemaUpdater(@NotNull Project project, @NotNull JsonSchemaService service) {
            if (project == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(0);
            }
            if (service == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(1);
            }
            this.myDirtySchemas = ContainerUtil.newConcurrentSet();
            this.myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Json Vfs Updater Executor");
            Disposable disposable2 = (Disposable)service;
            this.myProject = project;
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, disposable2);
            this.myService = service;
            this.myRunnable = () -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> scope2 = new HashSet<VirtualFile>(this.myDirtySchemas);
                if (scope2.stream().anyMatch(f -> service.possiblyHasReference(f.getName()))) {
                    ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_DEPS_CHANGED)).run();
                }
                this.myDirtySchemas.removeAll(scope2);
                if (scope2.isEmpty()) {
                    return;
                }
                List finalScope = ContainerUtil.filter(scope2, file2 -> this.myService.isApplicableToFile((VirtualFile)file2) && ((JsonSchemaServiceImpl)this.myService).isMappedSchema((VirtualFile)file2, false));
                if (finalScope.isEmpty()) {
                    return;
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_SCHEMA_CHANGED)).run();
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Editor[] editors2 = EditorFactory.getInstance().getAllEditors();
                Arrays.stream(editors2).filter(editor2 -> editor2 instanceof EditorEx && editor2.getProject() == this.myProject).map(editor2 -> ((EditorEx)editor2).getVirtualFile()).filter(file2 -> file2 != null && file2.isValid()).forEach(file2 -> {
                    Collection<VirtualFile> schemaFiles = ((JsonSchemaServiceImpl)this.myService).getSchemasForFile((VirtualFile)file2, false, true);
                    if (schemaFiles.stream().anyMatch(finalScope::contains)) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            ReadAction.run(() -> JsonSchemaUpdater.restartAnalyzer(analyzer, psiManager, file2));
                        } else {
                            ReadAction.nonBlocking(() -> JsonSchemaUpdater.restartAnalyzer(analyzer, psiManager, file2)).expireWith(disposable2).submit((Executor)this.myTaskExecutor);
                        }
                    }
                });
            };
        }

        private static void restartAnalyzer(@NotNull DaemonCodeAnalyzer analyzer, @NotNull PsiManager psiManager, @NotNull VirtualFile file2) {
            PsiFile psiFile;
            if (analyzer == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(2);
            }
            if (psiManager == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(4);
            }
            PsiFile psiFile2 = psiFile = !psiManager.isDisposed() && file2.isValid() ? psiManager.findFile(file2) : null;
            if (psiFile != null) {
                analyzer.restart(psiFile);
            }
        }

        protected void onFileChange(@NotNull VirtualFile schemaFile) {
            if (schemaFile == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(5);
            }
            if ("json".equals(schemaFile.getExtension())) {
                this.myDirtySchemas.add(schemaFile);
                Application app2 = ApplicationManager.getApplication();
                if (app2.isUnitTestMode()) {
                    app2.invokeLater(this.myRunnable, this.myProject.getDisposed());
                } else {
                    this.myUpdater.queue(this.myRunnable);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemaFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$JsonSchemaUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restartAnalyzer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

