/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaUserDefinedProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        List providers;
        if (project == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(0);
        }
        JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        Map<String, UserDefinedJsonSchemaConfiguration> map2 = configuration2.getStateMap();
        List list2 = providers = ContainerUtil.map(map2.values(), schema2 -> this.createProvider(project, (UserDefinedJsonSchemaConfiguration)schema2));
        if (list2 == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public MyProvider createProvider(@NotNull Project project, UserDefinedJsonSchemaConfiguration schema2) {
        if (project == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(2);
        }
        String relPath = schema2.getRelativePathToSchema();
        return new MyProvider(project, schema2.getSchemaVersion(), schema2.getName(), JsonFileResolver.isAbsoluteUrl(relPath) || new File(relPath).isAbsolute() ? relPath : new File(project.getBasePath(), relPath).getAbsolutePath(), schema2.getCalculatedPatterns());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @NotNull
        private final Project myProject;
        @NotNull
        private final JsonSchemaVersion myVersion;
        @NotNull
        @Nls
        private final String myName;
        @NotNull
        private final String myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<? extends PairProcessor<Project, VirtualFile>> myPatterns;

        MyProvider(@NotNull Project project, @NotNull JsonSchemaVersion version2, @NotNull @Nls String name2, @NotNull String file2, @NotNull List<? extends PairProcessor<Project, VirtualFile>> patterns) {
            if (project == null) {
                MyProvider.$$$reportNull$$$0(0);
            }
            if (version2 == null) {
                MyProvider.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                MyProvider.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyProvider.$$$reportNull$$$0(3);
            }
            if (patterns == null) {
                MyProvider.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myVersion = version2;
            this.myName = name2;
            this.myFile = file2;
            this.myPatterns = patterns;
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.myVersion;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            String path2 = this.myFile;
            if (JsonFileResolver.isAbsoluteUrl(path2)) {
                this.myVirtualFile = JsonFileResolver.urlToFile(path2);
            } else {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                this.myVirtualFile = lfs.findFileByPath(this.myFile);
                if (this.myVirtualFile == null) {
                    this.myVirtualFile = lfs.refreshAndFindFileByPath(this.myFile);
                }
            }
            return this.myVirtualFile;
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            SchemaType schemaType = SchemaType.userSchema;
            if (schemaType == null) {
                MyProvider.$$$reportNull$$$0(5);
            }
            return schemaType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyProvider.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProvider.$$$reportNull$$$0(7);
            }
            if (this.myPatterns.isEmpty() || file2.isDirectory() || !file2.isValid()) {
                return false;
            }
            return this.myPatterns.stream().anyMatch(processor2 -> processor2.process((Object)this.myProject, (Object)file2));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider2 = (MyProvider)o;
            if (!this.myName.equals(provider2.myName)) {
                return false;
            }
            return FileUtil.pathsEqual((String)this.myFile, (String)provider2.myFile);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + FileUtil.pathHashCode((String)this.myFile);
            return result2;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            return JsonFileResolver.isHttpPath(this.myFile) ? this.myFile : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

