/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonOriginalPsiWalker
implements JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker INSTANCE = new JsonOriginalPsiWalker();

    public boolean handles(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(0);
        }
        PsiElement parent = element2.getParent();
        return element2 instanceof JsonFile && JsonDialectUtil.isStandardJson(element2) || parent != null && (element2 instanceof JsonElement || element2 instanceof LeafPsiElement && parent instanceof JsonElement) && JsonDialectUtil.isStandardJson(CompletionUtil.getOriginalOrSelf(parent));
    }

    @Override
    public ThreeState isName(PsiElement element2) {
        PsiElement parent = element2.getParent();
        if (parent instanceof JsonObject) {
            return ThreeState.YES;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)element2, (boolean)false) ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.NO;
    }

    @Override
    public boolean isPropertyWithValue(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(1);
        }
        if (element2 instanceof JsonStringLiteral || element2 instanceof JsonReferenceExpression) {
            PsiElement parent = element2.getParent();
            if (!(parent instanceof JsonProperty) || ((JsonProperty)parent).getNameElement() != element2) {
                return false;
            }
            element2 = parent;
        }
        return element2 instanceof JsonProperty && ((JsonProperty)element2).getValue() != null;
    }

    @Override
    public PsiElement findElementToCheck(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(2);
        }
        for (PsiElement current2 = element2; current2 != null && !(current2 instanceof PsiFile); current2 = current2.getParent()) {
            if (!(current2 instanceof JsonValue) && !(current2 instanceof JsonProperty)) continue;
            return current2;
        }
        return null;
    }

    @Override
    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element2, boolean forceLastTransition) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(3);
        }
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current2 = element2;
        while (!(current2 instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current2;
            if ((current2 = current2.getParent()) instanceof JsonArray) {
                JsonArray array2 = (JsonArray)current2;
                List<JsonValue> list2 = array2.getValueList();
                int idx = -1;
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    JsonValue value2 = list2.get(i2);
                    if (!value2.equals(position)) continue;
                    idx = i2;
                    break;
                }
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current2 instanceof JsonProperty) {
                propertyName = ((JsonProperty)current2).getName();
                if (!((current2 = current2.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element2 && !forceLastTransition) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current2 instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element2 && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current2 instanceof PsiFile) break;
            return null;
        }
        return pos;
    }

    @Override
    public boolean requiresNameQuotes() {
        return true;
    }

    @Override
    public boolean allowsSingleQuotes() {
        return false;
    }

    @Override
    public boolean hasMissingCommaAfter(@NotNull PsiElement element2) {
        PsiElement current2;
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = current2 = element2 instanceof JsonProperty ? element2 : PsiTreeUtil.getParentOfType((PsiElement)element2, JsonProperty.class);
        while (current2 != null && current2.getNode().getElementType() != JsonElementTypes.COMMA) {
            current2 = current2.getNextSibling();
        }
        int commaOffset = current2 == null ? Integer.MAX_VALUE : current2.getTextRange().getStartOffset();
        int offset = element2.getTextRange().getStartOffset();
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element2, JsonObject.class);
        if (object != null) {
            for (JsonProperty property2 : object.getPropertyList()) {
                int pOffset = property2.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property2, (PsiElement)element2, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        JsonObject object;
        if (originalPosition == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(5);
        }
        if ((object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, JsonObject.class)) != null) {
            return object.getPropertyList().stream().filter(p -> !this.requiresNameQuotes() || p.getNameElement() instanceof JsonStringLiteral).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element2) {
        JsonProperty property2;
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(6);
        }
        if ((property2 = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JsonProperty.class, (boolean)false)) == null) {
            return null;
        }
        return new JsonJsonPropertyAdapter(property2);
    }

    @Override
    public boolean isTopJsonElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(7);
        }
        return element2 instanceof PsiFile;
    }

    @Override
    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(8);
        }
        return element2 instanceof JsonValue ? JsonJsonPropertyAdapter.createAdapterByType((JsonValue)element2) : null;
    }

    @Override
    public JsonLikeSyntaxAdapter getSyntaxAdapter(final Project project) {
        return new JsonLikeSyntaxAdapter(){
            private final JsonElementGenerator myGenerator;
            {
                this.myGenerator = new JsonElementGenerator(project);
            }

            @Override
            @Nullable
            public PsiElement getPropertyValue(PsiElement property2) {
                assert (property2 instanceof JsonProperty);
                return ((JsonProperty)property2).getValue();
            }

            @Override
            @NotNull
            public String getPropertyName(PsiElement property2) {
                assert (property2 instanceof JsonProperty);
                String string = ((JsonProperty)property2).getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public PsiElement createProperty(@NotNull String name2, @NotNull String value2, PsiElement element2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (value2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                JsonProperty jsonProperty = this.myGenerator.createProperty(name2, value2);
                if (jsonProperty == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jsonProperty;
            }

            @Override
            public boolean ensureComma(PsiElement self, PsiElement newElement) {
                if (newElement instanceof JsonProperty && self instanceof JsonProperty) {
                    self.getParent().addAfter(this.myGenerator.createComma(), self);
                    return true;
                }
                return false;
            }

            @Override
            public void removeIfComma(PsiElement forward) {
                if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == JsonElementTypes.COMMA) {
                    forward.delete();
                }
            }

            @Override
            public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element2) {
                return true;
            }

            @Override
            @NotNull
            public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
                String string = type == null ? "" : type.getDefaultValue();
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            public PsiElement adjustNewProperty(PsiElement element2) {
                return element2;
            }

            @Override
            public PsiElement adjustPropertyAnchor(LeafPsiElement element2) {
                throw new IncorrectOperationException("Shouldn't use leafs for insertion in pure JSON!");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPropertyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProperty";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultValueFromType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createProperty";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @Nullable
    public PsiElement getParentContainer(PsiElement element2) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JsonProperty.class), (Class[])new Class[]{JsonObject.class, JsonArray.class});
    }

    @Override
    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file2) {
        if (file2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(9);
        }
        List list2 = file2 instanceof JsonFile ? ContainerUtil.createMaybeSingletonList((Object)((JsonFile)file2).getTopLevelValue()) : ContainerUtil.emptyList();
        if (list2 == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Override
    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property2) {
        return property2 instanceof JsonProperty ? ((JsonProperty)property2).getNameElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementToCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPosition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingCommaAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentPropertyAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTopJsonElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

