/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;

public class NotValidation
implements JsonSchemaValidation {
    public static final NotValidation INSTANCE = new NotValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer2, JsonComplianceCheckerOptions options2) {
        MatchResult result2 = consumer2.resolve(schema2.getNot());
        if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
            return;
        }
        if (result2.mySchemas.stream().anyMatch(s -> schema2.equals(s)) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> schema2.equals(s))) {
            return;
        }
        JsonValidationHost checker = consumer2.checkByMatchResult(propValue, result2, options2.withForcedStrict());
        if (checker == null || checker.isValid()) {
            consumer2.error(JsonBundle.message("schema.validation.against.not", new Object[0]), propValue.getDelegate(), JsonErrorPriority.NOT_SCHEMA);
        }
    }
}

