/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.StatusText;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfoPopupStep
extends BaseListPopupStep<JsonSchemaInfo>
implements ListPopupStepEx<JsonSchemaInfo> {
    private final Project myProject;
    @Nullable
    private final VirtualFile myVirtualFile;
    @NotNull
    private final JsonSchemaService myService;
    private static final Icon EMPTY_ICON = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)AllIcons.General.Add.getIconWidth()));

    public JsonSchemaInfoPopupStep(@NotNull List<JsonSchemaInfo> allSchemas, @NotNull Project project, @Nullable VirtualFile virtualFile2, @NotNull JsonSchemaService service, @Nullable @NlsContexts.PopupTitle String title2) {
        if (allSchemas == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(1);
        }
        if (service == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(2);
        }
        super(title2, allSchemas);
        this.myProject = project;
        this.myVirtualFile = virtualFile2;
        this.myService = service;
    }

    @NotNull
    public String getTextFor(JsonSchemaInfo value2) {
        String string = value2 == null ? "" : value2.getDescription();
        if (string == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIconFor(JsonSchemaInfo value2) {
        if (value2 == JsonSchemaStatusPopup.ADD_MAPPING) {
            return AllIcons.General.Add;
        }
        if (value2 == JsonSchemaStatusPopup.EDIT_MAPPINGS) {
            return AllIcons.Actions.Edit;
        }
        if (value2 == JsonSchemaStatusPopup.LOAD_REMOTE) {
            return AllIcons.Actions.Refresh;
        }
        return EMPTY_ICON;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(JsonSchemaInfo value2) {
        List values2 = this.getValues();
        int index2 = values2.indexOf(value2);
        if (index2 - 1 >= 0) {
            JsonSchemaInfo info2 = (JsonSchemaInfo)values2.get(index2 - 1);
            if (info2 == JsonSchemaStatusPopup.EDIT_MAPPINGS || info2 == JsonSchemaStatusPopup.ADD_MAPPING) {
                return new ListSeparator(JsonBundle.message("schema.widget.registered.schemas", new Object[0]));
            }
            if (value2.getProvider() == null && info2.getProvider() != null) {
                return new ListSeparator(JsonBundle.message("schema.widget.store.schemas", new Object[0]));
            }
        }
        return null;
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice) {
        if (finalChoice) {
            if (selectedValue == JsonSchemaStatusPopup.EDIT_MAPPINGS || selectedValue == JsonSchemaStatusPopup.ADD_MAPPING) {
                return this.doFinalStep(() -> this.runSchemaEditorForCurrentFile());
            }
            if (selectedValue == JsonSchemaStatusPopup.LOAD_REMOTE) {
                return this.doFinalStep(() -> this.myService.triggerUpdateRemote());
            }
            this.setMapping(selectedValue, this.myVirtualFile, this.myProject);
            return this.doFinalStep(() -> this.myService.reset());
        }
        return PopupStep.FINAL_CHOICE;
    }

    protected void runSchemaEditorForCurrentFile() {
        assert (this.myVirtualFile != null) : "override this method to do without a virtual file!";
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, JsonSchemaMappingsConfigurable.class, configurable2 -> configurable2.setInitializer(() -> {
            JsonSchemaMappingsProjectConfiguration mappings = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject);
            UserDefinedJsonSchemaConfiguration configuration2 = mappings.findMappingForFile(this.myVirtualFile);
            if (configuration2 == null) {
                configuration2 = configurable2.addProjectSchema();
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVirtualFile, (VirtualFile)this.myProject.getBaseDir());
                configuration2.patterns.add(new UserDefinedJsonSchemaConfiguration.Item(relativePath == null ? this.myVirtualFile.getUrl() : relativePath, false, false));
            }
            configurable2.selectInTree(configuration2);
        }));
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    @NlsContexts.Tooltip
    public String getTooltipTextFor(JsonSchemaInfo value2) {
        return JsonSchemaInfoPopupStep.getDoc(value2);
    }

    @Nullable
    @NlsContexts.Tooltip
    private static String getDoc(JsonSchemaInfo schema2) {
        if (schema2 == null) {
            return null;
        }
        if (schema2.getName() == null) {
            return schema2.getDocumentation();
        }
        if (schema2.getDocumentation() == null) {
            return schema2.getName();
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(schema2.getName())).append((HtmlChunk)HtmlChunk.br()).appendRaw(schema2.getDocumentation()).toString();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(4);
        }
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice, int eventModifiers) {
        return this.onChosen(selectedValue, finalChoice);
    }

    protected void setMapping(@Nullable JsonSchemaInfo selectedValue, @Nullable VirtualFile virtualFile2, @NotNull Project project) {
        String path2;
        if (project == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(5);
        }
        assert (virtualFile2 != null) : "override this method to do without a virtual file!";
        JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        VirtualFile projectBaseDir = project.getBaseDir();
        UserDefinedJsonSchemaConfiguration mappingForFile = configuration2.findMappingForFile(virtualFile2);
        if (mappingForFile != null) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern : mappingForFile.patterns) {
                if (!Objects.equals(VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern.getPathParts()), virtualFile2) && !virtualFile2.getUrl().equals(UserDefinedJsonSchemaConfiguration.Item.neutralizePath(pattern.getPath()))) continue;
                mappingForFile.patterns.remove(pattern);
                if (mappingForFile.patterns.size() == 0 && mappingForFile.isApplicationDefined()) {
                    configuration2.removeConfiguration(mappingForFile);
                    break;
                }
                mappingForFile.refreshPatterns();
                break;
            }
        }
        if (selectedValue == null) {
            return;
        }
        String string = path2 = projectBaseDir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)projectBaseDir);
        if (path2 == null) {
            path2 = virtualFile2.getUrl();
        }
        UserDefinedJsonSchemaConfiguration existing = configuration2.findMappingBySchemaInfo(selectedValue);
        UserDefinedJsonSchemaConfiguration.Item item = new UserDefinedJsonSchemaConfiguration.Item(path2, false, false);
        if (existing != null) {
            if (!existing.patterns.contains(item)) {
                existing.patterns.add(item);
                existing.refreshPatterns();
            }
        } else {
            configuration2.addConfiguration(new UserDefinedJsonSchemaConfiguration(selectedValue.getDescription(), selectedValue.getSchemaVersion(), selectedValue.getUrl(project), true, Collections.singletonList(item)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSchemas";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

