/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRegExpPropertiesProvider {
    private static final DefaultRegExpPropertiesProvider INSTANCE = new DefaultRegExpPropertiesProvider();
    private final String[][] myPropertyNames = new String[][]{{"Cn", "Unassigned"}, {"Lu", "Uppercase letter"}, {"Ll", "Lowercase letter"}, {"Lt", "Titlecase letter"}, {"Lm", "Modifier letter"}, {"Lo", "Other letter"}, {"Mn", "Non spacing mark"}, {"Me", "Enclosing mark"}, {"Mc", "Combining spacing mark"}, {"Nd", "Decimal digit number"}, {"Nl", "Letter number"}, {"No", "Other number"}, {"Zs", "Space separator"}, {"Zl", "Line separator"}, {"Zp", "Paragraph separator"}, {"Cc", "Control"}, {"Cf", "Format"}, {"Co", "Private use"}, {"Cs", "Surrogate"}, {"Pd", "Dash punctuation"}, {"Ps", "Start punctuation"}, {"Pe", "End punctuation"}, {"Pc", "Connector punctuation"}, {"Po", "Other punctuation"}, {"Sm", "Math symbol"}, {"Sc", "Currency symbol"}, {"Sk", "Modifier symbol"}, {"So", "Other symbol"}, {"Pi", "Initial quote punctuation"}, {"Pf", "Final quote punctuation"}, {"L", "Letter"}, {"M", "Mark"}, {"N", "Number"}, {"Z", "Separator"}, {"C", "Control"}, {"P", "Punctuation"}, {"S", "Symbol"}, {"LC", "Letter"}, {"LD", "Letter or digit"}, {"L1", "Latin-1"}, {"all", "All"}, {"ASCII", "Ascii"}, {"Alnum", "Alphanumeric characters"}, {"Alpha", "Alphabetic characters"}, {"Blank", "Space and tab characters"}, {"Cntrl", "Control characters"}, {"Digit", "Numeric characters"}, {"Graph", "Printable and visible"}, {"Lower", "Lowercase Alphabetic"}, {"Print", "Printable characters"}, {"Punct", "Punctuation characters"}, {"Space", "Space characters"}, {"Upper", "Uppercase alphabetic"}, {"XDigit", "Hexadecimal digits"}};
    private final String[][] myCharacterClasses = new String[][]{{"d", "Digit: [0-9]"}, {"D", "Nondigit: [^0-9]"}, {"h", "Horizontal whitespace character: [ \\t\\xA0\\u1680\\u180e\\u2000-\\u200a\\u202f\\u205f\\u3000]"}, {"H", "Non-horizontal whitespace character: [^\\h]"}, {"s", "Whitespace: [ \\t\\n\\x0B\\f\\r]"}, {"S", "Non-whitespace: [^\\s]"}, {"v", "Vertical whitespace character: [\\n\\x0B\\f\\r\\x85\\u2028\\u2029]"}, {"V", "Non-vertical whitespace character: [^\\v]"}, {"w", "Word character: [a-zA-Z_0-9]"}, {"W", "Nonword character: [^\\w]"}, {"b", "Word boundary"}, {"b{g}", "Unicode extended grapheme cluster boundary"}, {"B", "Non-word boundary"}, {"A", "Beginning of the input"}, {"G", "End of the previous match"}, {"Z", "End of the input but for the final terminator, if any"}, {"z", "End of input"}, {"Q", "Nothing, but quotes all characters until \\E"}, {"E", "Nothing, but ends quoting started by \\Q"}, {"t", "Tab character ('\\u0009')"}, {"n", "Newline (line feed) character ('\\u000A')"}, {"r", "Carriage-return character ('\\u000D')"}, {"f", "Form-feed character ('\\u000C')"}, {"a", "Alert (bell) character ('\\u0007')"}, {"e", "Escape character ('\\u001B')"}, {"R", "Unicode line ending: \\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]"}, {"X", "Unicode extended grapheme cluster"}};
    private final String[][] myPosixCharacterClasses = new String[][]{{"alnum", "Alphanumeric characters"}, {"alpha", "Alphabetic characters"}, {"ascii", "ASCII characters"}, {"blank", "Space and tab"}, {"cntrl", "Control characters"}, {"digit", "Digits"}, {"graph", "Visible characters"}, {"lower", "Lowercase letters"}, {"print", "Visible characters and spaces"}, {"punct", "Punctuation and symbols"}, {"space", "All whitespace characters, including line breaks"}, {"upper", "Uppercase letters"}, {"word", "Word characters (letters, numbers and underscores)"}, {"xdigit", "Hexadecimal digits"}};

    public static DefaultRegExpPropertiesProvider getInstance() {
        return INSTANCE;
    }

    private DefaultRegExpPropertiesProvider() {
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            DefaultRegExpPropertiesProvider.$$$reportNull$$$0(0);
        }
        if (category.startsWith("In")) {
            try {
                return Character.UnicodeBlock.forName(category.substring(2)) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        category = StringUtil.trimStart((String)category, (String)"Is");
        for (String[] name2 : this.myPropertyNames) {
            if (!name2[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name2) {
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            return null;
        }
        for (String[] stringArray : this.myPropertyNames) {
            if (!stringArray[0].equals(name2)) continue;
            return stringArray.length > 1 ? stringArray[1] : stringArray[0];
        }
        return null;
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myPropertyNames;
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myCharacterClasses;
    }

    public String[] @NotNull [] getPosixCharacterClasses() {
        return this.myPosixCharacterClasses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/intellij/lang/regexp/DefaultRegExpPropertiesProvider", "isValidCategory"));
    }
}

