/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public final class UnicodeCharacterNames {
    public static void iterate(Consumer<? super String> consumer2) {
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool != null) {
                byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
                int[][] lookup2d = (int[][])ReflectionUtil.getStaticFieldValue(aClass, int[][].class, (String)"lookup");
                if (lookup2d == null) {
                    return;
                }
                for (int[] indexes : lookup2d) {
                    if (indexes == null) continue;
                    for (int index2 : indexes) {
                        if (index2 == 0) continue;
                        String name2 = new String(namePool, index2 >>> 8, index2 & 0xFF, StandardCharsets.US_ASCII);
                        consumer2.accept(name2);
                    }
                }
            } else {
                Method instance2 = ReflectionUtil.getDeclaredMethod(aClass, (String)"getInstance", (Class[])new Class[0]);
                Field field1 = ReflectionUtil.getDeclaredField(aClass, (String)"strPool");
                Field field2 = ReflectionUtil.getDeclaredField(aClass, (String)"lookup");
                if (instance2 != null && field1 != null && field2 != null) {
                    int[] lookup2;
                    Object characterName = instance2.invoke(null, new Object[0]);
                    byte[] namePool = (byte[])field1.get(characterName);
                    for (int index3 : lookup2 = (int[])field2.get(characterName)) {
                        if (index3 == 0) continue;
                        String name3 = new String(namePool, index3 >>> 8, index3 & 0xFF, StandardCharsets.US_ASCII);
                        consumer2.accept(name3);
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCodePoint(String name2) {
        if (name2 == null) {
            return -1;
        }
        Method method2 = ReflectionUtil.getMethod(Character.class, (String)"codePointOf", (Class[])new Class[]{String.class});
        if (method2 != null) {
            try {
                return (Integer)method2.invoke(null, name2);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    return -1;
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, (String)"initNamePool", (Class[])new Class[0]);
            if (initNamePool == null) {
                return -1;
            }
            byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
            name2 = StringUtil.toUpperCase((String)name2.trim());
            byte[] key = name2.getBytes(StandardCharsets.ISO_8859_1);
            int[][] lookup2 = (int[][])ReflectionUtil.getField(aClass, null, int[][].class, (String)"lookup");
            if (lookup2 == null) {
                throw new RuntimeException();
            }
            for (int i2 = 0; i2 < lookup2.length; ++i2) {
                int[] indexes = lookup2[i2];
                if (indexes == null) continue;
                for (int j = 0; j < indexes.length; ++j) {
                    int index2 = indexes[j];
                    if ((index2 & 0xFF) != key.length || !UnicodeCharacterNames.matches(namePool, index2 >>> 8, key)) continue;
                    return i2 << 8 | j;
                }
            }
            return UnicodeCharacterNames.getUnnamedUnicodeCharacterCodePoint(name2);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getUnnamedUnicodeCharacterCodePoint(String name2) {
        int index2 = name2.lastIndexOf(32);
        if (index2 != -1) {
            try {
                int c = Integer.parseInt(name2.substring(index2 + 1), 16);
                if (Character.isValidCodePoint(c) && name2.equals(Character.getName(c))) {
                    return c;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean matches(byte[] bytes, int offset, byte[] key) {
        if (offset < 0 || offset + key.length > bytes.length) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < key.length; ++i2) {
            if (bytes[i2 + offset] == key[i2]) continue;
            return false;
        }
        return true;
    }
}

