/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncExternalRef;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.RncParentRef;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.jetbrains.annotations.NotNull;

public class ReferenceAnnotator
extends RncElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    public synchronized void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ReferenceAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ReferenceAnnotator.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitInclude(RncInclude include) {
        this.checkReferences(include.getReferences());
    }

    @Override
    public void visitExternalRef(RncExternalRef ref) {
        this.checkReferences(ref.getReferences());
    }

    @Override
    public void visitRef(RncRef pattern) {
        this.checkReferences(pattern.getReferences());
    }

    @Override
    public void visitParentRef(RncParentRef pattern) {
        this.checkReferences(pattern.getReferences());
    }

    @Override
    public void visitName(RncName name2) {
        this.checkReferences(name2.getReferences());
    }

    private void checkReferences(PsiReference[] references) {
        for (PsiReference reference2 : references) {
            if (reference2.isSoft() || reference2.resolve() != null) continue;
            if (reference2 instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference pvr = (PsiPolyVariantReference)reference2;
                if (pvr.multiResolve(false).length != 0) continue;
                this.addError(reference2);
                continue;
            }
            this.addError(reference2);
        }
    }

    private void addError(PsiReference reference2) {
        LocalQuickFix[] fixes;
        String description;
        TextRange rangeInElement = reference2.getRangeInElement();
        TextRange range2 = TextRange.from((int)(reference2.getElement().getTextRange().getStartOffset() + rangeInElement.getStartOffset()), (int)rangeInElement.getLength());
        String message2 = reference2 instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference2).getUnresolvedMessagePattern() : AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description = BundleBase.format((String)message2, (Object[])new Object[]{reference2.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description = message2;
        }
        AnnotationBuilder builder2 = this.myHolder.newAnnotation(HighlightSeverity.ERROR, description).range(range2).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        if (reference2 instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference2).getQuickFixes()) != null) {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)reference2.getElement().getProject());
            for (LocalQuickFix fix2 : fixes) {
                ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor(reference2.getElement(), message2, fix2, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true);
                builder2 = builder2.newLocalQuickFix(fix2, descriptor2).registerFix();
            }
        }
        builder2.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/relaxNG/compact/ReferenceAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

