/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

public final class RenameUtil {
    private static final Set<String> ourRncKeywords = new HashSet<String>();

    private RenameUtil() {
    }

    @NotNull
    public static ASTNode createIdentifierNode(PsiManager manager2, String name2) throws IncorrectOperationException {
        if (RenameUtil.isKeyword((String)name2)) {
            name2 = "\\" + (String)name2;
        } else if (!RenameUtil.isIdentifier((String)name2)) {
            throw new IncorrectOperationException("Illegal identifier: " + (String)name2);
        }
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager2.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)((String)name2 + " = bar"));
        ASTNode astNode = RenameUtil.findFirstGrammarNode(file2);
        ASTNode newNode = astNode.findChildByType(RncTokenTypes.IDENTIFIERS);
        assert (newNode != null);
        ASTNode aSTNode = newNode;
        if (aSTNode == null) {
            RenameUtil.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    public static boolean isIdentifier(String name2) {
        if (name2 == null) {
            return false;
        }
        return Verifier.checkXMLName((String)name2) == null || name2.length() >= 2 && name2.charAt(0) == '\\' && Verifier.checkXMLName((String)name2.substring(1)) == null;
    }

    public static boolean isKeyword(String name2) {
        return ourRncKeywords.contains(name2);
    }

    public static ASTNode createPrefixedNode(PsiManager manager2, String prefix, String localPart) {
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager2.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)("element " + prefix + ":" + localPart + " { text }"));
        ASTNode node2 = RenameUtil.findFirstGrammarNode(file2);
        ASTNode nameClassNode = node2.findChildByType(RncElementTypes.NAME_CLASS);
        assert (nameClassNode != null);
        ASTNode astNode = nameClassNode.findChildByType(RncElementTypes.NAME);
        assert (astNode != null);
        return astNode;
    }

    @NotNull
    private static ASTNode findFirstGrammarNode(RncFile file2) {
        RncGrammar grammar = file2.getGrammar();
        assert (grammar != null);
        ASTNode grammarNode = grammar.getNode();
        assert (grammarNode != null);
        ASTNode astNode = grammarNode.getFirstChildNode();
        assert (astNode != null);
        ASTNode aSTNode = astNode;
        if (aSTNode == null) {
            RenameUtil.$$$reportNull$$$0(1);
        }
        return aSTNode;
    }

    public static ASTNode createLiteralNode(PsiManager manager2, String content2) {
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager2.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)("include \"" + content2 + "\""));
        ASTNode include = RenameUtil.findFirstGrammarNode(file2);
        ASTNode literal = include.findChildByType(RncTokenTypes.LITERAL);
        assert (literal != null);
        return literal;
    }

    static {
        Collections.addAll(ourRncKeywords, "attribute", "default", "datatypes", "div", "element", "empty", "external", "grammar", "include", "inherit", "list", "mixed", "namespace", "notAllowed", "parent", "start", "string", "text", "token");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/relaxNG/compact/psi/util/RenameUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifierNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstGrammarNode";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

