/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.RecursionSaveWalker;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.kohsuke.rngom.digested.DChoicePattern;
import org.kohsuke.rngom.digested.DDataPattern;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DOptionalPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DValuePattern;
import org.kohsuke.rngom.digested.DZeroOrMorePattern;
import org.kohsuke.rngom.nc.NameClass;

final class AttributeFinder
extends RecursionSaveWalker {
    private static final String STAR_PATTERN_SUFFIX = "__star__";
    private int depth;
    private int optional;
    private final QName myQname;
    private final Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> myAttributes = new LinkedHashMap<DAttributePattern, Pair<? extends Map<String, String>, Boolean>>();
    private DAttributePattern myLastAttr;

    private AttributeFinder() {
        this.myQname = null;
        ++this.optional;
    }

    private AttributeFinder(QName qname) {
        this.myQname = qname;
    }

    public Void onElement(DElementPattern p) {
        ++this.depth;
        try {
            this.myLastAttr = null;
            if (this.depth < 2) {
                Void void_ = super.onElement(p);
                return void_;
            }
            Void void_ = null;
            return void_;
        }
        finally {
            --this.depth;
        }
    }

    public Void onAttribute(DAttributePattern p) {
        assert (this.depth > 0);
        if (this.depth == 1 && (this.myQname == null && !AttributeFinder.hasStarPattern(p.getName()) || this.myQname != null && (p.getName().contains(this.myQname) || AttributeFinder.hasStarMatch(p.getName(), this.myQname)))) {
            this.myLastAttr = p;
            if (!this.myAttributes.containsKey(p)) {
                this.myAttributes.put(p, (Pair<? extends Map<String, String>, Boolean>)Pair.create(new LinkedHashMap(), (Object)(this.optional > 0 ? 1 : 0)));
            }
            return super.onAttribute(p);
        }
        return null;
    }

    public Void onValue(DValuePattern p) {
        if (this.myLastAttr != null) {
            ((Map)this.myAttributes.get((Object)this.myLastAttr).first).put(p.getValue(), p.getType());
        }
        return super.onValue(p);
    }

    public Void onOptional(DOptionalPattern p) {
        ++this.optional;
        try {
            Void void_ = super.onOptional(p);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onZeroOrMore(DZeroOrMorePattern p) {
        ++this.optional;
        try {
            Void void_ = super.onZeroOrMore(p);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onChoice(DChoicePattern p) {
        ++this.optional;
        try {
            Void void_ = super.onChoice(p);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onData(DDataPattern p) {
        if (this.depth == 1 && this.myLastAttr != null) {
            ((Map)this.myAttributes.get((Object)this.myLastAttr).first).put(null, p.getType());
        }
        return null;
    }

    public static Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> find(QName qname, DPattern ... patterns) {
        AttributeFinder finder = new AttributeFinder(qname);
        finder.doAccept(patterns);
        return finder.myAttributes;
    }

    public static Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> find(DPattern ... patterns) {
        AttributeFinder finder = new AttributeFinder();
        finder.doAccept(patterns);
        return finder.myAttributes;
    }

    private static boolean hasStarPattern(@NotNull NameClass patternClass) {
        if (patternClass == null) {
            AttributeFinder.$$$reportNull$$$0(0);
        }
        return !patternClass.isOpen() && ContainerUtil.find((Iterable)patternClass.listNames(), pattern -> pattern.getLocalPart().endsWith(STAR_PATTERN_SUFFIX)) != null;
    }

    private static boolean hasStarMatch(@NotNull NameClass patternClass, @NotNull QName qname) {
        if (patternClass == null) {
            AttributeFinder.$$$reportNull$$$0(1);
        }
        if (qname == null) {
            AttributeFinder.$$$reportNull$$$0(2);
        }
        return !patternClass.isOpen() && ContainerUtil.find((Iterable)patternClass.listNames(), pattern -> {
            String patternLocal = pattern.getLocalPart();
            if (patternLocal.endsWith(STAR_PATTERN_SUFFIX) && Objects.equals(qname.getNamespaceURI(), pattern.getNamespaceURI())) {
                String prefixPattern = patternLocal.substring(0, patternLocal.length() - STAR_PATTERN_SUFFIX.length());
                String name2 = qname.getLocalPart();
                return name2.length() > prefixPattern.length() && name2.startsWith(prefixPattern);
            }
            return false;
        }) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/AttributeFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasStarPattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasStarMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

