/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlSymbolDeclaration;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.descriptors.AttributeFinder;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngXmlAttributeDescriptor;
import org.intellij.plugins.relaxNG.validation.RngSchemaValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DEmptyPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DTextPattern;
import org.kohsuke.rngom.nc.NameClass;
import org.kohsuke.rngom.nc.NameClassVisitor;
import org.xml.sax.Locator;

public class RngElementDescriptor
implements XmlElementDescriptor {
    private static final Logger LOG = Logger.getInstance(RngElementDescriptor.class);
    private static final Key<ParameterizedCachedValue<XmlElementDescriptor, RngElementDescriptor>> DESCR_KEY = Key.create((String)"DESCR");
    private static final Key<ParameterizedCachedValue<XmlAttributeDescriptor[], RngElementDescriptor>> ATTRS_KEY = Key.create((String)"ATTRS");
    protected static final XmlElementDescriptor NULL = null;
    private final DElementPattern myElementPattern;
    protected final RngNsDescriptor myNsDescriptor;
    private final PsiCachedValueImpl<PsiElement> myCachedElement;

    RngElementDescriptor(RngNsDescriptor nsDescriptor, DElementPattern pattern) {
        this.myNsDescriptor = nsDescriptor;
        this.myElementPattern = pattern;
        this.myCachedElement = new PsiCachedValueImpl(nsDescriptor.getDescriptorFile().getManager(), () -> {
            PsiElement decl = this.myNsDescriptor.getDeclaration();
            if (decl == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            }
            PsiElement element2 = RngElementDescriptor.getDeclarationImpl(decl, this.myElementPattern.getLocation());
            return CachedValueProvider.Result.create((Object)element2, (Object[])new Object[]{element2.getContainingFile()});
        });
    }

    public String getQualifiedName() {
        QName qName = this.getQName();
        return qName != null ? RngElementDescriptor.format(qName, "") : "#unknown";
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        DElementPattern p;
        if (context2 == null) {
            return EMPTY_ARRAY;
        }
        XmlElementDescriptor descriptor2 = this.myNsDescriptor.getElementDescriptor(context2);
        DElementPattern pattern = descriptor2 instanceof RngElementDescriptor ? ((p = ((RngElementDescriptor)descriptor2).myElementPattern) != null ? p : this.myElementPattern) : this.myElementPattern;
        List<DElementPattern> patterns = ChildElementFinder.find(2, (DPattern)pattern);
        return this.myNsDescriptor.convertElementDescriptors(patterns);
    }

    protected XmlElementDescriptor findElementDescriptor(XmlTag childTag) {
        List<DElementPattern> patterns = ChildElementFinder.find(2, (DPattern)this.myElementPattern);
        XmlElementDescriptor d = this.myNsDescriptor.findDescriptor(childTag, patterns);
        return d == null ? NULL : d;
    }

    public final XmlElementDescriptor getElementDescriptor(XmlTag childTag) {
        return this.getElementDescriptor(childTag, null);
    }

    public final XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor value2 = RngElementDescriptor.getCachedValue(childTag, this, DESCR_KEY, p -> {
            XmlElementDescriptor descriptor2 = p.findElementDescriptor(childTag);
            return CachedValueProvider.Result.create((Object)descriptor2, (Object[])new Object[]{p.getDependencies(), childTag});
        });
        return value2 == NULL ? null : value2;
    }

    public final XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context2) {
        if (context2 != null) {
            return RngElementDescriptor.getCachedValue(context2, this, ATTRS_KEY, p -> {
                XmlAttributeDescriptor[] value2 = p.collectAttributeDescriptors(context2);
                return CachedValueProvider.Result.create((Object)value2, (Object[])new Object[]{p.getDependencies(), context2});
            });
        }
        return this.collectAttributeDescriptors(null);
    }

    private static <D extends PsiElement, T, P> T getCachedValue(D context2, P p, Key<ParameterizedCachedValue<T, P>> key, ParameterizedCachedValueProvider<T, P> provider2) {
        CachedValuesManager mgr = CachedValuesManager.getManager((Project)context2.getProject());
        return (T)mgr.getParameterizedCachedValue(context2, key, provider2, false, p);
    }

    protected XmlAttributeDescriptor[] collectAttributeDescriptors(@Nullable XmlTag context2) {
        return this.computeAttributeDescriptors(AttributeFinder.find((QName)null, new DPattern[]{this.myElementPattern}));
    }

    protected XmlAttributeDescriptor[] computeAttributeDescriptors(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> map2) {
        HashMap<QName, RngXmlAttributeDescriptor> name2descriptor = new HashMap<QName, RngXmlAttributeDescriptor>();
        for (DAttributePattern pattern : map2.keySet()) {
            Pair<? extends Map<String, String>, Boolean> value2 = map2.get(pattern);
            for (QName name2 : pattern.getName().listNames()) {
                RngXmlAttributeDescriptor descriptor2 = (RngXmlAttributeDescriptor)name2descriptor.get(name2);
                RngXmlAttributeDescriptor newDescriptor = new RngXmlAttributeDescriptor(this, pattern, (Map)value2.first, (Boolean)value2.second);
                descriptor2 = descriptor2 == null ? newDescriptor : descriptor2.mergeWith(newDescriptor);
                name2descriptor.put(name2, descriptor2);
            }
        }
        Collection result2 = name2descriptor.values();
        return result2.toArray(new RngXmlAttributeDescriptor[0]);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context2) {
        return this.getAttributeDescriptor("", attributeName);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getNamespace(), attribute.getLocalName());
    }

    protected XmlAttributeDescriptor getAttributeDescriptor(String namespace, String localName) {
        QName qname = new QName(namespace, localName);
        return this.computeAttributeDescriptor(AttributeFinder.find(qname, new DPattern[]{this.myElementPattern}));
    }

    protected XmlAttributeDescriptor computeAttributeDescriptor(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> attributes2) {
        if (attributes2.size() > 0) {
            RngXmlAttributeDescriptor d = null;
            Set<DAttributePattern> patterns = attributes2.keySet();
            for (DAttributePattern pattern : patterns) {
                Pair<? extends Map<String, String>, Boolean> pair = attributes2.get(pattern);
                RngXmlAttributeDescriptor a = new RngXmlAttributeDescriptor(this, pattern, (Map)pair.first, (Boolean)pair.second);
                if (d == null) {
                    d = a;
                    continue;
                }
                d = d.mergeWith(a);
            }
            return d;
        }
        return null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myNsDescriptor;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        DPattern child2 = this.myElementPattern.getChild();
        if (child2 instanceof DEmptyPattern) {
            return 0;
        }
        if (child2 instanceof DTextPattern) {
            return 3;
        }
        if (child2 instanceof DElementPattern) {
            return (Integer)((DElementPattern)child2).getName().accept((NameClassVisitor)MyNameClassVisitor.INSTANCE);
        }
        return 2;
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myCachedElement.getValue();
    }

    public PsiElement getDeclaration(Locator location) {
        PsiElement element2 = this.myNsDescriptor.getDeclaration();
        if (element2 == null) {
            return null;
        }
        return RngElementDescriptor.getDeclarationImpl(element2, location);
    }

    private static PsiElement getDeclarationImpl(PsiElement decl, Locator location) {
        VirtualFile virtualFile2 = RngSchemaValidator.findVirtualFile(location.getSystemId());
        if (virtualFile2 == null) {
            return decl;
        }
        Project project = decl.getProject();
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (file2 == null) {
            return decl;
        }
        return (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> RngElementDescriptor.getDeclarationImpl(project, decl, location, file2));
    }

    @Nullable
    private static PsiElement getDeclarationImpl(@NotNull Project project, PsiElement decl, Locator location, PsiFile file2) {
        PsiElement at;
        if (project == null) {
            RngElementDescriptor.$$$reportNull$$$0(0);
        }
        int column2 = location.getColumnNumber();
        int line = location.getLineNumber();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        assert (document != null);
        if (line <= 0 || document.getLineCount() < line - 1) {
            return decl;
        }
        int startOffset = document.getLineStartOffset(line - 1);
        if (column2 > 0) {
            if (decl.getContainingFile().getFileType() == RncFileType.getInstance()) {
                return new RncLocationPsiElement(file2, startOffset, column2);
            }
            at = file2.findElementAt(startOffset + column2 - 2);
        } else {
            PsiElement element2 = file2.findElementAt(startOffset);
            at = element2 != null ? PsiTreeUtil.nextLeaf((PsiElement)element2) : null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class);
    }

    @NonNls
    public String getName(PsiElement context2) {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class, (boolean)false);
        String prefix = xmlTag != null ? xmlTag.getPrefixByNamespace(qName.getNamespaceURI()) : null;
        return RngElementDescriptor.format(qName, prefix != null ? prefix : qName.getPrefix());
    }

    @NonNls
    public String getName() {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        return qName.getLocalPart();
    }

    private static String format(QName qName, String p) {
        String localPart = qName.getLocalPart();
        return p.length() > 0 ? p + ":" + localPart : localPart;
    }

    @Nullable
    private QName getQName() {
        Iterator iterator2 = this.myElementPattern.getName().listNames().iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        return (QName)iterator2.next();
    }

    public void init(PsiElement element2) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RngElementDescriptor that = (RngElementDescriptor)o;
        return this.myElementPattern.equals(that.myElementPattern);
    }

    public int hashCode() {
        return this.myElementPattern.hashCode();
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myNsDescriptor.getDependencies();
        if (objectArray == null) {
            RngElementDescriptor.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public DElementPattern getElementPattern() {
        return this.myElementPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationImpl";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RncLocationPsiElement
    extends FakePsiElement
    implements NavigationItem,
    HtmlSymbolDeclaration {
        private final PsiFile myFile;
        private final int myStartOffset;
        private final int myColumn;
        private final String myName;
        private final HtmlSymbolDeclaration.Kind myKind;

        private RncLocationPsiElement(PsiFile file2, int startOffset, int column2) {
            this.myFile = file2;
            this.myStartOffset = startOffset;
            this.myColumn = column2;
            PsiElement definition = this.getNavigationElement();
            this.myName = definition.getText();
            PsiElement prevPrevSibling = (PsiElement)ObjectUtils.doIfNotNull((Object)definition.getPrevSibling(), PsiElement::getPrevSibling);
            if (prevPrevSibling == null) {
                LOG.error("Failed to locate type for RNC element - " + this.myName);
            }
            this.myKind = prevPrevSibling != null && "element".equals(prevPrevSibling.getText()) ? HtmlSymbolDeclaration.Kind.ELEMENT : HtmlSymbolDeclaration.Kind.ATTRIBUTE;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        @NotNull
        public HtmlSymbolDeclaration.Kind getKind() {
            HtmlSymbolDeclaration.Kind kind = this.myKind;
            if (kind == null) {
                RncLocationPsiElement.$$$reportNull$$$0(0);
            }
            return kind;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement rncElement = this.myFile.findElementAt(this.myStartOffset + this.myColumn);
            ASTNode pattern = rncElement != null ? TreeUtil.findParent(rncElement.getNode(), RncElementTypes.PATTERN) : null;
            ASTNode nameClass = pattern != null ? pattern.findChildByType(RncElementTypes.NAME_CLASS) : null;
            PsiElement psiElement = nameClass != null ? nameClass.getPsi() : rncElement;
            if (psiElement == null) {
                RncLocationPsiElement.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        public PsiElement getParent() {
            return this.getNavigationElement();
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myFile;
        }

        public boolean equals(Object another) {
            return another instanceof RncLocationPsiElement && ((RncLocationPsiElement)another).myFile == this.myFile && ((RncLocationPsiElement)another).myStartOffset == this.myStartOffset && ((RncLocationPsiElement)another).myColumn == this.myColumn;
        }

        public int hashCode() {
            return Objects.hash(this.myFile, this.myStartOffset, this.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor$RncLocationPsiElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyNameClassVisitor
    implements NameClassVisitor<Integer> {
        public static final MyNameClassVisitor INSTANCE = new MyNameClassVisitor();

        private MyNameClassVisitor() {
        }

        public Integer visitAnyName() {
            return 1;
        }

        public Integer visitAnyNameExcept(NameClass nc) {
            return 1;
        }

        public Integer visitChoice(NameClass nc1, NameClass nc2) {
            return 2;
        }

        public Integer visitName(QName name2) {
            return 2;
        }

        public Integer visitNsName(String ns) {
            return 2;
        }

        public Integer visitNsNameExcept(String ns, NameClass nc) {
            return 2;
        }

        public Integer visitNull() {
            return 0;
        }
    }
}

