/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.CharArrayUtil;
import io.netty.buffer.ByteBufUtf8Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiConditional;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiFsize;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\u00052\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\n\u0010\r\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\fH\u0002J1\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001a2\n\u0010\r\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "", "()V", "commands", "", "", "Lorg/jetbrains/builtInWebServer/ssi/SsiCommand;", "charCmp", "", "buf", "", "index", "", "command", "isQuote", "c", "", "isSpace", "parseCommand", "instruction", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parseParamNames", "", "start", "parseParamValues", "", "count", "(Ljava/lang/StringBuilder;II)[Ljava/lang/String;", "process", "", "ssiExternalResolver", "Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "file", "Ljava/nio/file/Path;", "writer", "Lio/netty/buffer/ByteBufUtf8Writer;", "intellij.platform.builtInServer.impl"})
public class SsiProcessor {
    private final Map<String, SsiCommand> commands = new HashMap();

    public final long process(@NotNull SsiExternalResolver ssiExternalResolver, @NotNull Path file2, @NotNull ByteBufUtf8Writer writer) {
        Intrinsics.checkNotNullParameter((Object)ssiExternalResolver, (String)"ssiExternalResolver");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        CharSequence fileContents = PathKt.readChars((Path)file2);
        long lastModifiedDate = PathKt.lastModified((Path)file2).toMillis();
        SsiProcessingState ssiProcessingState = new SsiProcessingState(ssiExternalResolver, lastModifiedDate);
        int index2 = 0;
        boolean inside = false;
        StringBuilder command = new StringBuilder();
        writer.ensureWritable((int)PathKt.size((Path)file2));
        try {
            while (index2 < fileContents.length()) {
                char c = fileContents.charAt(index2);
                if (inside) {
                    if (c == "-->".charAt(0) && this.charCmp(fileContents, index2, "-->")) {
                        long newLastModified;
                        Locale locale;
                        inside = false;
                        index2 += "-->".length();
                        String commandName2 = this.parseCommand(command);
                        if (SsiProcessorKt.getLOG().isDebugEnabled()) {
                            SsiProcessorKt.getLOG().debug("SSIProcessor.process -- processing command: " + commandName2);
                        }
                        List<String> paramNames = this.parseParamNames(command, commandName2.length());
                        String[] paramValues = this.parseParamValues(command, commandName2.length(), paramNames.size());
                        String configErrMsg = ssiProcessingState.configErrorMessage;
                        String string = commandName2;
                        Intrinsics.checkNotNullExpressionValue((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                        boolean bl = false;
                        String string2 = string;
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                        SsiCommand ssiCommand = this.commands.get(string4);
                        String errorMessage = null;
                        if (ssiCommand == null) {
                            errorMessage = "Unknown command: " + commandName2;
                        } else if (paramValues == null) {
                            errorMessage = "Error parsing directive parameters.";
                        } else if (paramNames.size() != paramValues.length) {
                            errorMessage = "Parameter names count does not match parameter values count on command: " + commandName2;
                        } else if ((!ssiProcessingState.conditionalState.processConditionalCommandsOnly || ssiCommand instanceof SsiConditional) && (newLastModified = ssiCommand.process(ssiProcessingState, commandName2, paramNames, paramValues, writer)) > lastModifiedDate) {
                            lastModifiedDate = newLastModified;
                        }
                        if (errorMessage == null) continue;
                        SsiProcessorKt.getLOG().warn(errorMessage);
                        String string5 = configErrMsg;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"configErrMsg");
                        writer.write(string5);
                        continue;
                    }
                    command.append(c);
                    ++index2;
                    continue;
                }
                if (c == "<!--#".charAt(0) && this.charCmp(fileContents, index2, "<!--#")) {
                    inside = true;
                    index2 += "<!--#".length();
                    command.setLength(0);
                    continue;
                }
                if (!ssiProcessingState.conditionalState.processConditionalCommandsOnly) {
                    writer.append(c);
                }
                ++index2;
            }
        }
        catch (SsiStopProcessingException ssiStopProcessingException) {
            // empty catch block
        }
        return lastModifiedDate;
    }

    private final List<String> parseParamNames(StringBuilder command, int start2) {
        int bIdx = start2;
        SmartList values2 = new SmartList();
        boolean inside = false;
        StringBuilder builder2 = new StringBuilder();
        while (bIdx < command.length()) {
            if (inside) {
                while (bIdx < command.length() && command.charAt(bIdx) != '=') {
                    builder2.append(command.charAt(bIdx));
                    ++bIdx;
                }
                values2.add((Object)builder2.toString());
                builder2.setLength(0);
                inside = false;
                int quotes = 0;
                boolean escaped = false;
                while (bIdx < command.length() && quotes != 2) {
                    char c = command.charAt(bIdx);
                    if (c == '\\' && !escaped) {
                        escaped = true;
                        ++bIdx;
                        continue;
                    }
                    if (c == '\"' && !escaped) {
                        ++quotes;
                    }
                    escaped = false;
                    ++bIdx;
                }
                continue;
            }
            while (bIdx < command.length() && this.isSpace(command.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= command.length()) break;
            inside = true;
        }
        return (List)values2;
    }

    private final String[] parseParamValues(StringBuilder command, int start2, int count) {
        int valueIndex = 0;
        boolean inside = false;
        String[] values2 = new String[count];
        StringBuilder builder2 = new StringBuilder();
        char endQuote = (char)0;
        for (int bIdx = start2; bIdx < command.length(); ++bIdx) {
            if (!inside) {
                while (bIdx < command.length() && !this.isQuote(command.charAt(bIdx))) {
                    ++bIdx;
                }
                if (bIdx >= command.length()) break;
                inside = true;
                endQuote = command.charAt(bIdx);
                continue;
            }
            boolean escaped = false;
            while (bIdx < command.length()) {
                char c = command.charAt(bIdx);
                if (c == '\\' && !escaped) {
                    escaped = true;
                    ++bIdx;
                    continue;
                }
                if (c == endQuote && !escaped) break;
                if (c == '$' && escaped) {
                    builder2.append('\\');
                }
                escaped = false;
                builder2.append(c);
                ++bIdx;
            }
            if (bIdx == command.length()) {
                return null;
            }
            values2[valueIndex++] = builder2.toString();
            builder2.setLength(0);
            inside = false;
        }
        return values2;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseCommand(StringBuilder instruction) {
        String string;
        int firstLetter = -1;
        int lastLetter = -1;
        int n = 0;
        int n2 = ((CharSequence)instruction).length();
        while (n < n2) {
            void i2;
            char c = instruction.charAt((int)i2);
            if (Character.isLetter(c)) {
                if (firstLetter == -1) {
                    firstLetter = i2;
                }
                lastLetter = i2;
            } else if (!this.isSpace(c) || lastLetter > -1) break;
            ++i2;
        }
        if (firstLetter == -1) {
            string = "";
        } else {
            String string2 = instruction.substring(firstLetter, lastLetter + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"instruction.substring(firstLetter, lastLetter + 1)");
        }
        return string;
    }

    private final boolean charCmp(CharSequence buf, int index2, String command) {
        return CharArrayUtil.regionMatches((CharSequence)buf, (int)index2, (int)(index2 + command.length()), (CharSequence)command);
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private final boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    public SsiProcessor() {
        this.commands.put("config", 1.INSTANCE);
        this.commands.put("echo", 2.INSTANCE);
        this.commands.put("include", 3.INSTANCE);
        this.commands.put("flastmod", 4.INSTANCE);
        this.commands.put("fsize", new SsiFsize());
        this.commands.put("printenv", 5.INSTANCE);
        this.commands.put("set", 6.INSTANCE);
        SsiConditional ssiConditional = new SsiConditional();
        this.commands.put("if", ssiConditional);
        this.commands.put("elif", ssiConditional);
        this.commands.put("endif", ssiConditional);
        this.commands.put("else", ssiConditional);
    }
}

