/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.containers.UtilKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.CharSequenceIterator;
import org.jetbrains.debugger.sourcemap.FileBackedSourceMap;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.MutableEntry;
import org.jetbrains.debugger.sourcemap.NamedEntry;
import org.jetbrains.debugger.sourcemap.OneLevelSourceMap;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.UnmappedEntry;
import org.jetbrains.debugger.sourcemap.UnnamedEntry;
import org.jetbrains.io.JsonReaderEx;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001d\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a9\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2'\u0010\f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\r\u001a*\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018\u001a*\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0018\u001a1\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e0\u00032\u0006\u0010!\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001a\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010+\u001a\u0004\u0018\u00010\u000f\u001a.\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002\u001a\u0010\u00101\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0002\u001a \u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010(\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"UNMAPPED", "", "calculateReverseMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "data", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "(Lorg/jetbrains/debugger/sourcemap/SourceMapData;)[Lorg/jetbrains/debugger/sourcemap/MappingList;", "decodeSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceMapData", "", "sourceResolverFactory", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "sourceUrls", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "decodeSourceMapFromFile", "file", "Ljava/nio/file/Path;", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "decodeSourceMapSafely", "getMapping", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "reverseMappingsBySourceUrl", "sourceIndex", "([Ljava/util/List;I)Ljava/util/List;", "isSeparator", "charIterator", "Lorg/jetbrains/debugger/sourcemap/CharSequenceIterator;", "parseMap", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "parseMapSafely", "mapDebugName", "readMappings", "", "value", "mappings", "names", "readSourcePath", "readSources", "sourceRoot", "intellij.platform.scriptDebugger.backend"})
public final class SourceMapDecoderKt {
    public static final int UNMAPPED = -1;

    @Nullable
    public static final SourceMap decodeSourceMapFromFile(@NotNull Path file2, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return FileBackedSourceMap.Companion.newFileBackedSourceMap(file2, trimFileScheme, baseUrl, baseUrlIsFile);
    }

    @Nullable
    public static final SourceMap decodeSourceMapSafely(@NotNull CharSequence sourceMapData, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        return SourceMapDecoderKt.decodeSourceMap(sourceMapData, (Function1<? super List<String>, SourceResolver>)((Function1)new Function1<List<? extends String>, SourceResolver>(trimFileScheme, baseUrl, baseUrlIsFile){
            final /* synthetic */ boolean $trimFileScheme;
            final /* synthetic */ Url $baseUrl;
            final /* synthetic */ boolean $baseUrlIsFile;

            @NotNull
            public final SourceResolver invoke(@NotNull List<String> sourceUrls) {
                Intrinsics.checkNotNullParameter(sourceUrls, (String)"sourceUrls");
                return new SourceResolver(sourceUrls, this.$trimFileScheme, this.$baseUrl, this.$baseUrlIsFile);
            }
            {
                this.$trimFileScheme = bl;
                this.$baseUrl = url;
                this.$baseUrlIsFile = bl2;
                super(1);
            }
        }));
    }

    @Nullable
    public static final SourceMapDataImpl parseMapSafely(@NotNull CharSequence sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        try {
            CharSequence charSequence = sourceMapData;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new IOException("source map contents cannot be empty");
            }
            JsonReaderEx reader = new JsonReaderEx(sourceMapData);
            reader.setLenient(true);
            return SourceMapDecoderKt.parseMap(reader);
        }
        catch (JsonParseException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SourceMap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Cannot decode sourcemap " + mapDebugName, (Throwable)e);
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SourceMap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Cannot decode sourcemap " + mapDebugName, t, new Attachment[]{new Attachment("sourceMap.txt", ((Object)sourceMapData).toString())});
        }
        return null;
    }

    @Nullable
    public static final SourceMap decodeSourceMap(@NotNull CharSequence sourceMapData, @NotNull Function1<? super List<String>, SourceResolver> sourceResolverFactory) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        Intrinsics.checkNotNullParameter(sourceResolverFactory, (String)"sourceResolverFactory");
        SourceMapDataEx sourceMapDataEx = SourceMapDataCache.getOrCreate$default(SourceMapDataCache.INSTANCE, ((Object)sourceMapData).toString(), null, 2, null);
        if (sourceMapDataEx == null) {
            return null;
        }
        SourceMapDataEx data2 = sourceMapDataEx;
        return new OneLevelSourceMap(data2, (SourceResolver)sourceResolverFactory.invoke(data2.getSourceMapData().getSources()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MappingList[] calculateReverseMappings(@NotNull SourceMapData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List[] reverseMappingsBySourceUrl = new List[data2.getSources().size()];
        for (MappingEntry entry2 : data2.getMappings()) {
            int sourceIndex = entry2.getSource();
            if (sourceIndex < 0) continue;
            List<MappingEntry> reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex);
            reverseMappings.add(entry2);
        }
        int n = reverseMappingsBySourceUrl.length;
        MappingList[] mappingListArray = new MappingList[n];
        for (int j = 0; j < n; ++j) {
            MappingList mappingList;
            void it;
            int reverseMappings = j;
            int n2 = j;
            MappingList[] mappingListArray2 = mappingListArray;
            boolean bl = false;
            List entries2 = reverseMappingsBySourceUrl[it];
            mappingListArray2[n2] = mappingList = (MappingList)(entries2 == null ? null : new SourceMappingList(entries2));
        }
        return mappingListArray;
    }

    /*
     * Unable to fully structure code
     */
    private static final SourceMapDataImpl parseMap(JsonReaderEx reader) {
        reader.beginObject();
        sourceRoot = null;
        sourcesReader = null;
        names = null;
        encodedMappings = null;
        file = null;
        version = -1;
        sourcesContent = null;
        mappings = new ArrayList<E>();
        while (reader.hasNext()) {
            block25: {
                block31: {
                    block29: {
                        block27: {
                            block28: {
                                block30: {
                                    block26: {
                                        if (reader.nextName() == null) break block25;
                                        switch (var9_9.hashCode()) {
                                            case -1111500899: {
                                                if (!var9_9.equals("sourceRoot")) ** break;
                                                break block26;
                                            }
                                            case 194445669: {
                                                if (!var9_9.equals("mappings")) ** break;
                                                break block27;
                                            }
                                            case 104585032: {
                                                if (!var9_9.equals("names")) ** break;
                                                break block28;
                                            }
                                            case 3143036: {
                                                if (!var9_9.equals("file")) ** break;
                                                break block29;
                                            }
                                            case -2021876808: {
                                                if (!var9_9.equals("sources")) ** break;
                                                break block30;
                                            }
                                            case -252243551: {
                                                if (!var9_9.equals("sourcesContent")) ** break;
                                                break block31;
                                            }
                                            case 351608024: {
                                                if (!var9_9.equals("version")) ** break;
                                                break;
                                            }
                                            case 947936814: {
                                                if (!var9_9.equals("sections")) ** break;
                                                throw (Throwable)new IOException("sections is not supported yet");
                                            }
                                        }
                                        version = reader.nextInt();
                                        continue;
                                    }
                                    sourceRoot = StringUtil.nullize((String)SourceMapDecoderKt.readSourcePath(reader));
                                    if (sourceRoot == null || !(Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ^ true)) continue;
                                    sourceRoot = UriUtil.trimTrailingSlashes(sourceRoot);
                                    continue;
                                }
                                sourcesReader = reader.subReader();
                                reader.skipValue();
                                continue;
                            }
                            reader.beginArray();
                            if (reader.hasNext()) {
                                names = new ArrayList<E>();
                                do {
                                    if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                                        reader.skipValue();
                                        ((ArrayList)names).add("POLYMER UNKNOWN NAME");
                                        continue;
                                    }
                                    ((ArrayList)names).add(reader.nextString(true));
                                } while (reader.hasNext());
                            } else {
                                names = CollectionsKt.emptyList();
                            }
                            reader.endArray();
                            continue;
                        }
                        encodedMappings = reader.nextString();
                        continue;
                    }
                    file = reader.nextNullableString();
                    continue;
                }
                reader.beginArray();
                if (reader.peek() != JsonToken.END_ARRAY) {
                    sourcesContent = (List)new SmartList();
                    do {
                        if (reader.peek() == JsonToken.STRING) {
                            sourcesContent.add(StringUtilRt.convertLineSeparators((String)reader.nextString()));
                            continue;
                        }
                        if (reader.peek() == JsonToken.NULL) {
                            sourcesContent.add(null);
                            reader.nextNull();
                            continue;
                        }
                        $i$f$logger = false;
                        v0 = Logger.getInstance(SourceMap.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"Logger.getInstance(T::class.java)");
                        v0.warn("Unknown sourcesContent element: " + reader.peek().name());
                        reader.skipValue();
                    } while (reader.hasNext());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.close();
        var9_9 = encodedMappings;
        var10_10 = 0;
        var11_11 = false;
        if (var9_9 == null || var9_9.length() == 0) {
            return null;
        }
        if (Registry.is((String)"js.debugger.fix.jspm.source.maps", (boolean)false)) {
            v1 = encodedMappings;
            Intrinsics.checkNotNull((Object)v1);
            if (StringsKt.startsWith$default((String)v1, (String)";", (boolean)false, (int)2, null) && file != null && StringsKt.endsWith$default((String)file, (String)".ts!transpiled", (boolean)false, (int)2, null)) {
                var9_9 = encodedMappings;
                var10_10 = 1;
                var11_11 = false;
                v2 = var9_9.substring(var10_10);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
                encodedMappings = v2;
            }
        }
        if (version != 3) {
            throw (Throwable)new IOException("Unsupported sourcemap version: " + version);
        }
        if (sourcesReader == null) {
            throw (Throwable)new IOException("sources is not specified");
        }
        sources = SourceMapDecoderKt.readSources(sourcesReader, sourceRoot);
        if (sources.isEmpty()) {
            return null;
        }
        SourceMapDecoderKt.readMappings(encodedMappings, (List<MappingEntry>)mappings, names);
        return new SourceMapDataImpl(file, sources, sourcesContent, UtilKt.isNullOrEmpty((Collection)names) == false, (List<? extends MappingEntry>)mappings);
    }

    private static final String readSourcePath(JsonReaderEx reader) {
        String string = reader.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = PathUtil.toSystemIndependentName((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.toSystemIndepen\u2026ing().trim { it <= ' ' })");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void readMappings(String value2, List<MappingEntry> mappings, List<String> names2) {
        void prevEntry;
        CharSequence charSequence = value2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        int line = 0;
        int column2 = 0;
        CharSequenceIterator charIterator = new CharSequenceIterator(value2);
        int sourceIndex = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1<MutableEntry, Unit> $fun$addEntry$1 = new Function1<MutableEntry, Unit>((Ref.ObjectRef)prevEntry, mappings){
            final /* synthetic */ Ref.ObjectRef $prevEntry;
            final /* synthetic */ List $mappings;

            public final void invoke(@NotNull MutableEntry entry2) {
                Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                if ((MutableEntry)this.$prevEntry.element != null) {
                    MutableEntry mutableEntry = (MutableEntry)this.$prevEntry.element;
                    Intrinsics.checkNotNull((Object)mutableEntry);
                    mutableEntry.setNextGenerated(entry2);
                }
                this.$prevEntry.element = entry2;
                this.$mappings.add(entry2);
            }
            {
                this.$prevEntry = objectRef;
                this.$mappings = list2;
                super(1);
            }
        };
        while (charIterator.hasNext()) {
            if (charIterator.peek$intellij_platform_scriptDebugger_backend() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek$intellij_platform_scriptDebugger_backend() == ';') {
                    ++line;
                    column2 = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            column2 += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                $fun$addEntry$1.invoke((MutableEntry)new UnmappedEntry(line, column2));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.decode(charIterator);
            if (sourceIndexDelta != 0) {
                sourceIndex += sourceIndexDelta;
            }
            sourceLine += Base64VLQ.decode(charIterator);
            sourceColumn += Base64VLQ.decode(charIterator);
            MutableEntry entry2 = null;
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                entry2 = new UnnamedEntry(line, column2, sourceIndex, sourceLine, sourceColumn);
            } else {
                nameIndex += Base64VLQ.decode(charIterator);
                boolean bl2 = names2 != null;
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                List<String> list2 = names2;
                Intrinsics.checkNotNull(list2);
                entry2 = new NamedEntry(list2.get(nameIndex), line, column2, sourceIndex, sourceLine, sourceColumn);
            }
            $fun$addEntry$1.invoke(entry2);
        }
    }

    private static final List<String> readSources(JsonReaderEx reader, String sourceRoot) {
        reader.beginArray();
        List sources = null;
        if (reader.peek() == JsonToken.END_ARRAY) {
            sources = CollectionsKt.emptyList();
        } else {
            sources = (List)new SmartList();
            do {
                String sourceUrl = SourceMapDecoderKt.readSourcePath(reader);
                CharSequence charSequence = sourceRoot;
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    sourceUrl = Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ? '/' + sourceUrl : sourceRoot + '/' + sourceUrl;
                }
                ((SmartList)sources).add((Object)sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    private static final List<MappingEntry> getMapping(List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        List reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = (List)new ArrayList();
        }
        return reverseMappings;
    }

    private static final boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current2 = charIterator.peek$intellij_platform_scriptDebugger_backend();
        return current2 == ',' || current2 == ';';
    }
}

