/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/io/webSocket/WebSocketProtocolHandshakeHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "handshaker", "Lio/netty/handler/codec/http/websocketx/WebSocketClientHandshaker;", "(Lio/netty/handler/codec/http/websocketx/WebSocketClientHandshaker;)V", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "completed", "intellij.platform.builtInServer.impl"})
public class WebSocketProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketClientHandshaker handshaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(@NotNull ChannelHandlerContext context2, @NotNull Object message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Channel channel2 = context2.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(channel2, (FullHttpResponse)message2);
                ChannelPipeline pipeline = channel2.pipeline();
                pipeline.replace((ChannelHandler)this, "aggregator", (ChannelHandler)new WebSocketFrameAggregator(NettyUtil.MAX_CONTENT_LENGTH));
                this.completed();
                return;
            }
            finally {
                ReferenceCountUtil.release((Object)message2);
            }
        }
        if (message2 instanceof FullHttpResponse) {
            throw (Throwable)new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + ((FullHttpResponse)message2).status() + ", content=" + ((FullHttpResponse)message2).content().toString(CharsetUtil.UTF_8) + ')');
        }
        context2.fireChannelRead(message2);
    }

    protected void completed() {
    }

    public WebSocketProtocolHandshakeHandler(@NotNull WebSocketClientHandshaker handshaker) {
        Intrinsics.checkNotNullParameter((Object)handshaker, (String)"handshaker");
        this.handshaker = handshaker;
    }
}

