/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.openapi.externalSystem.model.project.dependencies.AbstractDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependenciesImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependenciesImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class ProjectDependenciesSerializationService
implements SerializationService<ProjectDependencies> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(ProjectDependencies dependencies, Class<? extends ProjectDependencies> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            ProjectDependenciesSerializationService.write(writer, this.myWriteContext, dependencies);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectDependencies read(byte[] object, Class<? extends ProjectDependencies> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            ProjectDependencies projectDependencies = ProjectDependenciesSerializationService.read(reader, this.myReadContext);
            return projectDependencies;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends ProjectDependencies> getModelClass() {
        return ProjectDependencies.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final ProjectDependencies model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ProjectDependenciesSerializationService.writeComponentsDependencies(writer, context, model.getComponentsDependencies());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeComponentsDependencies(IonWriter writer, WriteContext context, Collection<ComponentDependencies> dependencies) throws IOException {
        writer.setFieldName("componentsDependencies");
        writer.stepIn(IonType.LIST);
        for (ComponentDependencies componentDependencies : dependencies) {
            ProjectDependenciesSerializationService.writeComponentDependencies(writer, context, componentDependencies);
        }
        writer.stepOut();
    }

    private static void writeComponentDependencies(final IonWriter writer, final WriteContext context, final ComponentDependencies componentDependencies) throws IOException {
        context.componentDependenciesCollector.add(componentDependencies, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", componentDependencies.getComponentName());
                    writer.setFieldName("compile");
                    ProjectDependenciesSerializationService.writeDependencyNode(writer, context, componentDependencies.getCompileDependenciesGraph());
                    writer.setFieldName("runtime");
                    ProjectDependenciesSerializationService.writeDependencyNode(writer, context, componentDependencies.getRuntimeDependenciesGraph());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(IonWriter writer, WriteContext context, DependencyNode node) throws IOException {
        if (node instanceof ProjectDependencyNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (ProjectDependencyNode)node);
        } else if (node instanceof ArtifactDependencyNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (ArtifactDependencyNode)node);
        } else if (node instanceof FileCollectionDependencyNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (FileCollectionDependencyNode)node);
        } else if (node instanceof ReferenceNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (ReferenceNode)node);
        } else if (node instanceof DependencyScopeNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (DependencyScopeNode)node);
        } else if (node instanceof UnknownDependencyNode) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, (UnknownDependencyNode)node);
        }
    }

    private static void writeDependencyNode(final IonWriter writer, final WriteContext context, final ProjectDependencyNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ProjectDependencyNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                    ToolingStreamApiUtils.writeString(writer, "projectName", node.getProjectName());
                    ProjectDependenciesSerializationService.writeDependenciesField(writer, context, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(final IonWriter writer, final WriteContext context, final ArtifactDependencyNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ArtifactDependencyNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                    ToolingStreamApiUtils.writeString(writer, "group", node.getGroup());
                    ToolingStreamApiUtils.writeString(writer, "module", node.getModule());
                    ToolingStreamApiUtils.writeString(writer, "version", node.getVersion());
                    ProjectDependenciesSerializationService.writeDependenciesField(writer, context, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(final IonWriter writer, final WriteContext context, final FileCollectionDependencyNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(FileCollectionDependencyNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                    ToolingStreamApiUtils.writeString(writer, "displayName", node.getDisplayName());
                    ToolingStreamApiUtils.writeString(writer, "path", node.getPath());
                    ProjectDependenciesSerializationService.writeDependenciesField(writer, context, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(final IonWriter writer, WriteContext context, final ReferenceNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ReferenceNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(final IonWriter writer, final WriteContext context, final DependencyScopeNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(DependencyScopeNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                    ToolingStreamApiUtils.writeString(writer, "scope", node.getScope());
                    ToolingStreamApiUtils.writeString(writer, "displayName", node.getDisplayName());
                    ToolingStreamApiUtils.writeString(writer, "description", node.getDescription());
                    ProjectDependenciesSerializationService.writeDependenciesField(writer, context, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyNode(final IonWriter writer, final WriteContext context, final UnknownDependencyNode node) throws IOException {
        context.dependencyNodeCollector.add(node, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(UnknownDependencyNode.class.getSimpleName());
                    ProjectDependenciesSerializationService.writeDependencyCommonFields(writer, (DependencyNode)node);
                    ToolingStreamApiUtils.writeString(writer, "name", node.getDisplayName());
                    ProjectDependenciesSerializationService.writeDependenciesField(writer, context, (DependencyNode)node);
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyCommonFields(IonWriter writer, DependencyNode node) throws IOException {
        ToolingStreamApiUtils.writeLong(writer, "id", node.getId());
        ToolingStreamApiUtils.writeString(writer, "resolutionState", node.getResolutionState());
    }

    private static void writeDependenciesField(IonWriter writer, WriteContext context, DependencyNode dependencyNode) throws IOException {
        writer.setFieldName("dependencies");
        writer.stepIn(IonType.LIST);
        for (DependencyNode componentDependencies : dependencyNode.getDependencies()) {
            ProjectDependenciesSerializationService.writeDependencyNode(writer, context, componentDependencies);
        }
        writer.stepOut();
    }

    @Nullable
    private static ProjectDependencies read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ProjectDependencies model = (ProjectDependencies)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<ProjectDependenciesImpl>(){

            public ProjectDependenciesImpl create() {
                ProjectDependenciesImpl dependencies = new ProjectDependenciesImpl();
                List componentsDependencies = ProjectDependenciesSerializationService.readComponentsDependencies(reader, context);
                for (ComponentDependencies componentDependencies : componentsDependencies) {
                    dependencies.add(componentDependencies);
                }
                return dependencies;
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<ComponentDependencies> readComponentsDependencies(IonReader reader, ReadContext context) {
        ComponentDependencies componentDependencies;
        ArrayList<ComponentDependencies> list = new ArrayList<ComponentDependencies>();
        reader.next();
        reader.stepIn();
        while ((componentDependencies = ProjectDependenciesSerializationService.readComponentDependencies(reader, context)) != null) {
            list.add(componentDependencies);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static ComponentDependencies readComponentDependencies(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ComponentDependencies dependency = (ComponentDependencies)context.componentDependenciesMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<ComponentDependencies>(){

            public ComponentDependencies create() {
                String componentName = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name"));
                DependencyScopeNode compileDependencies = (DependencyScopeNode)ToolingStreamApiUtils.assertNotNull(ProjectDependenciesSerializationService.readDependencyNode(reader, context, "compile"));
                DependencyScopeNode runtimeDependencies = (DependencyScopeNode)ToolingStreamApiUtils.assertNotNull(ProjectDependenciesSerializationService.readDependencyNode(reader, context, "runtime"));
                return new ComponentDependenciesImpl(componentName, compileDependencies, runtimeDependencies);
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static DependencyNode readDependencyNode(final IonReader reader, final ReadContext context, @Nullable String fieldName) {
        if (reader.next() == null) {
            return null;
        }
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        reader.stepIn();
        DependencyNode dependency = (DependencyNode)context.nodesMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<DependencyNode>(){

            public DependencyNode newInstance() {
                ProjectDependencyNodeImpl node;
                String type = ToolingStreamApiUtils.readString(reader, "_type");
                long id = ToolingStreamApiUtils.readLong(reader, "id");
                String resolutionState = ToolingStreamApiUtils.readString(reader, "resolutionState");
                if (ProjectDependencyNode.class.getSimpleName().equals(type)) {
                    String projectName = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "projectName"));
                    node = new ProjectDependencyNodeImpl(id, projectName);
                } else if (ArtifactDependencyNode.class.getSimpleName().equals(type)) {
                    String group = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "group"));
                    String module = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "module"));
                    String version = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "version"));
                    node = new ArtifactDependencyNodeImpl(id, group, module, version);
                } else if (FileCollectionDependencyNode.class.getSimpleName().equals(type)) {
                    String displayName = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "displayName"));
                    String path = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "path"));
                    node = new FileCollectionDependencyNodeImpl(id, displayName, path);
                } else if (DependencyScopeNode.class.getSimpleName().equals(type)) {
                    String scope = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "scope"));
                    String displayName = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "displayName"));
                    String description = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "description"));
                    node = new DependencyScopeNode(id, scope, displayName, description);
                } else if (ReferenceNode.class.getSimpleName().equals(type)) {
                    node = new ReferenceNode(id);
                } else if (UnknownDependencyNode.class.getSimpleName().equals(type)) {
                    String name = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name"));
                    node = new UnknownDependencyNode(id, name);
                } else {
                    throw new RuntimeException("Unsupported dependency node");
                }
                if (node instanceof AbstractDependencyNode) {
                    ((AbstractDependencyNode)node).setResolutionState(resolutionState);
                }
                return node;
            }

            public void fill(DependencyNode node) {
                if (node instanceof AbstractDependencyNode) {
                    node.getDependencies().addAll(ProjectDependenciesSerializationService.readDependencyNodes(reader, context));
                }
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static Collection<? extends DependencyNode> readDependencyNodes(IonReader reader, ReadContext context) {
        DependencyNode node;
        ArrayList<DependencyNode> list = new ArrayList<DependencyNode>();
        reader.next();
        reader.stepIn();
        while ((node = ProjectDependenciesSerializationService.readDependencyNode(reader, context, null)) != null) {
            list.add(node);
        }
        reader.stepOut();
        return list;
    }

    private static class WriteContext {
        private final ObjectCollector<ProjectDependencies, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<ComponentDependencies, IOException> componentDependenciesCollector = new ObjectCollector();
        private final ObjectCollector<DependencyNode, IOException> dependencyNodeCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private final IntObjectMap<ProjectDependenciesImpl> objectMap = new IntObjectMap();
        private final IntObjectMap<ComponentDependencies> componentDependenciesMap = new IntObjectMap();
        private final IntObjectMap<DependencyNode> nodesMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

