"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var icon_1 = require("../icons/icon");
exports.Color = react_1.memo(react_1.forwardRef(function (_a, ref) {
    var color = _a.color, _b = _a.isSeriesHidden, isSeriesHidden = _b === void 0 ? false : _b, hasColorPicker = _a.hasColorPicker, onClick = _a.onClick;
    if (isSeriesHidden) {
        return (react_1.default.createElement("div", { className: "echLegendItem__color", "aria-label": "series hidden", title: "series hidden" },
            react_1.default.createElement(icon_1.Icon, { type: "eyeClosed", viewBox: "-3 -3 22 22" })));
    }
    var colorClasses = classnames_1.default('echLegendItem__color', {
        'echLegendItem__color--changable': hasColorPicker,
    });
    return (react_1.default.createElement("div", { onClick: hasColorPicker ? onClick : undefined, className: colorClasses, "aria-label": "series color", title: hasColorPicker ? 'change series color' : 'series color' },
        react_1.default.createElement("div", { ref: ref },
            react_1.default.createElement(icon_1.Icon, { type: "dot", color: color }))));
}));
exports.Color.displayName = 'Color';
//# sourceMappingURL=color.js.map