/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.FormulaExpression;
import org.libreoffice.report.pentaho.model.FormatCondition;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormatConditionReadHandler
extends AbstractXmlReadHandler {
    private final ReportElement element;

    public FormatConditionReadHandler(ReportElement reportElement) {
        if (reportElement == null) {
            throw new NullPointerException();
        }
        this.element = reportElement;
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        String string = attributes.getValue("http://openoffice.org/2005/report", "formula");
        if (string == null) {
            throw new ParseException("Required attribute 'formula' is missing.", this.getLocator());
        }
        String string2 = attributes.getValue("http://openoffice.org/2005/report", "style-name");
        if (string2 == null) {
            throw new ParseException("Required attribute 'style-name' is missing.", this.getLocator());
        }
        FormulaExpression formulaExpression = new FormulaExpression();
        formulaExpression.setFormula(string);
        String string3 = attributes.getValue("http://openoffice.org/2005/report", "enabled");
        boolean bl = string3 == null || "true".equals(string3);
        FormatCondition formatCondition = new FormatCondition(formulaExpression, string2, bl);
        this.element.addFormatCondition(formatCondition);
    }

    public Object getObject() throws SAXException {
        return this.element;
    }
}

