/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.logstash.plugins.inputs.http.HttpInitializer;
import org.logstash.plugins.inputs.http.IMessageHandler;
import org.logstash.plugins.inputs.http.util.CustomRejectedExecutionHandler;
import org.logstash.plugins.inputs.http.util.DaemonThreadFactory;
import org.logstash.plugins.inputs.http.util.SslHandlerProvider;

public class NettyHttpServer
implements Runnable,
Closeable {
    private final ServerBootstrap serverBootstrap;
    private final String host;
    private final int port;
    private final int connectionBacklog = 128;
    private final EventLoopGroup processorGroup;
    private final ThreadPoolExecutor executorGroup;
    private final HttpResponseStatus responseStatus;

    public NettyHttpServer(String host, int port, IMessageHandler messageHandler, SslHandlerProvider sslHandlerProvider, int threads, int maxPendingRequests, int maxContentLength, int responseCode) {
        this.host = host;
        this.port = port;
        this.responseStatus = HttpResponseStatus.valueOf((int)responseCode);
        this.processorGroup = new NioEventLoopGroup(threads, DaemonThreadFactory.daemonThreadFactory("http-input-processor"));
        this.executorGroup = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxPendingRequests), DaemonThreadFactory.daemonThreadFactory("http-input-handler-executor"), new CustomRejectedExecutionHandler());
        HttpInitializer httpInitializer = new HttpInitializer(messageHandler, this.executorGroup, maxContentLength, this.responseStatus);
        if (sslHandlerProvider != null) {
            httpInitializer.enableSSL(sslHandlerProvider);
        }
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.processorGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)httpInitializer);
    }

    @Override
    public void run() {
        try {
            this.executorGroup.prestartAllCoreThreads();
            ChannelFuture channel = this.serverBootstrap.bind(this.host, this.port);
            channel.sync().channel().closeFuture().sync();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.processorGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).sync();
            this.executorGroup.shutdown();
            try {
                if (!this.executorGroup.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorGroup.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Arrived at illegal state during thread pool shutdown {}", e);
            }
            this.executorGroup.shutdownNow();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

