/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfo;

public class VkBindImagePlaneMemoryInfoKHR
extends VkBindImagePlaneMemoryInfo {
    public VkBindImagePlaneMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfoKHR set(VkBindImagePlaneMemoryInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc() {
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc() {
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindImagePlaneMemoryInfoKHR create(long address) {
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindImagePlaneMemoryInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImagePlaneMemoryInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBindImagePlaneMemoryInfoKHR mallocStack() {
        return VkBindImagePlaneMemoryInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfoKHR callocStack() {
        return VkBindImagePlaneMemoryInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfoKHR mallocStack(MemoryStack stack) {
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR callocStack(MemoryStack stack) {
        return (VkBindImagePlaneMemoryInfoKHR)VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkBindImagePlaneMemoryInfo.Buffer {
        private static final VkBindImagePlaneMemoryInfoKHR ELEMENT_FACTORY = VkBindImagePlaneMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindImagePlaneMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

