/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentDescription;
import org.lwjgl.vulkan.VkSubpassDependency;
import org.lwjgl.vulkan.VkSubpassDescription;

public class VkRenderPassCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int SUBPASSCOUNT;
    public static final int PSUBPASSES;
    public static final int DEPENDENCYCOUNT;
    public static final int PDEPENDENCIES;

    public VkRenderPassCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPassCreateFlags")
    public int flags() {
        return VkRenderPassCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassCreateInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentDescription const *")
    public VkAttachmentDescription.Buffer pAttachments() {
        return VkRenderPassCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassCreateInfo.nsubpassCount(this.address());
    }

    @NativeType(value="VkSubpassDescription const *")
    public VkSubpassDescription.Buffer pSubpasses() {
        return VkRenderPassCreateInfo.npSubpasses(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassCreateInfo.ndependencyCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSubpassDependency const *")
    public VkSubpassDependency.Buffer pDependencies() {
        return VkRenderPassCreateInfo.npDependencies(this.address());
    }

    public VkRenderPassCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
        VkRenderPassCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pAttachments(@Nullable @NativeType(value="VkAttachmentDescription const *") VkAttachmentDescription.Buffer value) {
        VkRenderPassCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pSubpasses(@NativeType(value="VkSubpassDescription const *") VkSubpassDescription.Buffer value) {
        VkRenderPassCreateInfo.npSubpasses(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pDependencies(@Nullable @NativeType(value="VkSubpassDependency const *") VkSubpassDependency.Buffer value) {
        VkRenderPassCreateInfo.npDependencies(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo set(int sType, long pNext, int flags, @Nullable VkAttachmentDescription.Buffer pAttachments, VkSubpassDescription.Buffer pSubpasses, @Nullable VkSubpassDependency.Buffer pDependencies) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pAttachments(pAttachments);
        this.pSubpasses(pSubpasses);
        this.pDependencies(pDependencies);
        return this;
    }

    public VkRenderPassCreateInfo set(VkRenderPassCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassCreateInfo malloc() {
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderPassCreateInfo calloc() {
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderPassCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderPassCreateInfo create(long address) {
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkRenderPassCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderPassCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRenderPassCreateInfo mallocStack() {
        return VkRenderPassCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo callocStack() {
        return VkRenderPassCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo mallocStack(MemoryStack stack) {
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassCreateInfo callocStack(MemoryStack stack) {
        return (VkRenderPassCreateInfo)VkRenderPassCreateInfo.wrap(VkRenderPassCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentDescription.Buffer npAttachments(long struct) {
        return VkAttachmentDescription.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), VkRenderPassCreateInfo.nattachmentCount(struct));
    }

    public static int nsubpassCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASSCOUNT);
    }

    public static VkSubpassDescription.Buffer npSubpasses(long struct) {
        return VkSubpassDescription.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES)), VkRenderPassCreateInfo.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPENDENCYCOUNT);
    }

    @Nullable
    public static VkSubpassDependency.Buffer npDependencies(long struct) {
        return VkSubpassDependency.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)), VkRenderPassCreateInfo.ndependencyCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable VkAttachmentDescription.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsubpassCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASSCOUNT, value);
    }

    public static void npSubpasses(long struct, VkSubpassDescription.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBPASSES), (long)value.address());
        VkRenderPassCreateInfo.nsubpassCount(struct, value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npDependencies(long struct, @Nullable VkSubpassDependency.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPENDENCIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassCreateInfo.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
        int subpassCount = VkRenderPassCreateInfo.nsubpassCount(struct);
        long pSubpasses = MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES));
        Checks.check((long)pSubpasses);
        VkSubpassDescription.validate(pSubpasses, subpassCount);
        if (VkRenderPassCreateInfo.ndependencyCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkRenderPassCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        ATTACHMENTCOUNT = layout.offsetof(3);
        PATTACHMENTS = layout.offsetof(4);
        SUBPASSCOUNT = layout.offsetof(5);
        PSUBPASSES = layout.offsetof(6);
        DEPENDENCYCOUNT = layout.offsetof(7);
        PDEPENDENCIES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassCreateInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassCreateInfo ELEMENT_FACTORY = VkRenderPassCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRenderPassCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPassCreateFlags")
        public int flags() {
            return VkRenderPassCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassCreateInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentDescription const *")
        public VkAttachmentDescription.Buffer pAttachments() {
            return VkRenderPassCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassCreateInfo.nsubpassCount(this.address());
        }

        @NativeType(value="VkSubpassDescription const *")
        public VkSubpassDescription.Buffer pSubpasses() {
            return VkRenderPassCreateInfo.npSubpasses(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassCreateInfo.ndependencyCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSubpassDependency const *")
        public VkSubpassDependency.Buffer pDependencies() {
            return VkRenderPassCreateInfo.npDependencies(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
            VkRenderPassCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkAttachmentDescription const *") VkAttachmentDescription.Buffer value) {
            VkRenderPassCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer pSubpasses(@NativeType(value="VkSubpassDescription const *") VkSubpassDescription.Buffer value) {
            VkRenderPassCreateInfo.npSubpasses(this.address(), value);
            return this;
        }

        public Buffer pDependencies(@Nullable @NativeType(value="VkSubpassDependency const *") VkSubpassDependency.Buffer value) {
            VkRenderPassCreateInfo.npDependencies(this.address(), value);
            return this;
        }
    }
}

