/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassEndInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    public VkSubpassEndInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassEndInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassEndInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassEndInfo.npNext(this.address());
    }

    public VkSubpassEndInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassEndInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubpassEndInfo pNext(@NativeType(value="void const *") long value) {
        VkSubpassEndInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubpassEndInfo set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubpassEndInfo set(VkSubpassEndInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassEndInfo malloc() {
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassEndInfo calloc() {
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassEndInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassEndInfo create(long address) {
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)address);
    }

    @Nullable
    public static VkSubpassEndInfo createSafe(long address) {
        return address == 0L ? null : (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassEndInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassEndInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassEndInfo mallocStack() {
        return VkSubpassEndInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassEndInfo callocStack() {
        return VkSubpassEndInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassEndInfo mallocStack(MemoryStack stack) {
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassEndInfo callocStack(MemoryStack stack) {
        return (VkSubpassEndInfo)VkSubpassEndInfo.wrap(VkSubpassEndInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassEndInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassEndInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassEndInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkSubpassEndInfo.__struct((Struct.Member[])new Struct.Member[]{VkSubpassEndInfo.__member((int)4), VkSubpassEndInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassEndInfo, Buffer>
    implements NativeResource {
        private static final VkSubpassEndInfo ELEMENT_FACTORY = VkSubpassEndInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassEndInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassEndInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassEndInfo.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassEndInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassEndInfo.npNext(this.address(), value);
            return this;
        }
    }
}

