/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationFeaturesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ENABLEDVALIDATIONFEATURECOUNT;
    public static final int PENABLEDVALIDATIONFEATURES;
    public static final int DISABLEDVALIDATIONFEATURECOUNT;
    public static final int PDISABLEDVALIDATIONFEATURES;

    public VkValidationFeaturesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkValidationFeaturesEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkValidationFeaturesEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkValidationFeaturesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledValidationFeatureCount() {
        return VkValidationFeaturesEXT.nenabledValidationFeatureCount(this.address());
    }

    @Nullable
    @NativeType(value="VkValidationFeatureEnableEXT const *")
    public IntBuffer pEnabledValidationFeatures() {
        return VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address());
    }

    @NativeType(value="uint32_t")
    public int disabledValidationFeatureCount() {
        return VkValidationFeaturesEXT.ndisabledValidationFeatureCount(this.address());
    }

    @Nullable
    @NativeType(value="VkValidationFeatureDisableEXT const *")
    public IntBuffer pDisabledValidationFeatures() {
        return VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address());
    }

    public VkValidationFeaturesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkValidationFeaturesEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT pNext(@NativeType(value="void const *") long value) {
        VkValidationFeaturesEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT pEnabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureEnableEXT const *") IntBuffer value) {
        VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT pDisabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureDisableEXT const *") IntBuffer value) {
        VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT set(int sType, long pNext, @Nullable IntBuffer pEnabledValidationFeatures, @Nullable IntBuffer pDisabledValidationFeatures) {
        this.sType(sType);
        this.pNext(pNext);
        this.pEnabledValidationFeatures(pEnabledValidationFeatures);
        this.pDisabledValidationFeatures(pDisabledValidationFeatures);
        return this;
    }

    public VkValidationFeaturesEXT set(VkValidationFeaturesEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkValidationFeaturesEXT malloc() {
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkValidationFeaturesEXT calloc() {
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkValidationFeaturesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkValidationFeaturesEXT create(long address) {
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)address);
    }

    @Nullable
    public static VkValidationFeaturesEXT createSafe(long address) {
        return address == 0L ? null : (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkValidationFeaturesEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkValidationFeaturesEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkValidationFeaturesEXT mallocStack() {
        return VkValidationFeaturesEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkValidationFeaturesEXT callocStack() {
        return VkValidationFeaturesEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkValidationFeaturesEXT mallocStack(MemoryStack stack) {
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkValidationFeaturesEXT callocStack(MemoryStack stack) {
        return (VkValidationFeaturesEXT)VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkValidationFeaturesEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkValidationFeaturesEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkValidationFeaturesEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nenabledValidationFeatureCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDVALIDATIONFEATURECOUNT);
    }

    @Nullable
    public static IntBuffer npEnabledValidationFeatures(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PENABLEDVALIDATIONFEATURES)), (int)VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct));
    }

    public static int ndisabledValidationFeatureCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISABLEDVALIDATIONFEATURECOUNT);
    }

    @Nullable
    public static IntBuffer npDisabledValidationFeatures(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDISABLEDVALIDATIONFEATURES)), (int)VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nenabledValidationFeatureCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDVALIDATIONFEATURECOUNT, value);
    }

    public static void npEnabledValidationFeatures(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PENABLEDVALIDATIONFEATURES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndisabledValidationFeatureCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISABLEDVALIDATIONFEATURECOUNT, value);
    }

    public static void npDisabledValidationFeatures(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDISABLEDVALIDATIONFEATURES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PENABLEDVALIDATIONFEATURES)));
        }
        if (VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDISABLEDVALIDATIONFEATURES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkValidationFeaturesEXT.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkValidationFeaturesEXT.__struct((Struct.Member[])new Struct.Member[]{VkValidationFeaturesEXT.__member((int)4), VkValidationFeaturesEXT.__member((int)POINTER_SIZE), VkValidationFeaturesEXT.__member((int)4), VkValidationFeaturesEXT.__member((int)POINTER_SIZE), VkValidationFeaturesEXT.__member((int)4), VkValidationFeaturesEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ENABLEDVALIDATIONFEATURECOUNT = layout.offsetof(2);
        PENABLEDVALIDATIONFEATURES = layout.offsetof(3);
        DISABLEDVALIDATIONFEATURECOUNT = layout.offsetof(4);
        PDISABLEDVALIDATIONFEATURES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkValidationFeaturesEXT, Buffer>
    implements NativeResource {
        private static final VkValidationFeaturesEXT ELEMENT_FACTORY = VkValidationFeaturesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkValidationFeaturesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkValidationFeaturesEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkValidationFeaturesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledValidationFeatureCount() {
            return VkValidationFeaturesEXT.nenabledValidationFeatureCount(this.address());
        }

        @Nullable
        @NativeType(value="VkValidationFeatureEnableEXT const *")
        public IntBuffer pEnabledValidationFeatures() {
            return VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address());
        }

        @NativeType(value="uint32_t")
        public int disabledValidationFeatureCount() {
            return VkValidationFeaturesEXT.ndisabledValidationFeatureCount(this.address());
        }

        @Nullable
        @NativeType(value="VkValidationFeatureDisableEXT const *")
        public IntBuffer pDisabledValidationFeatures() {
            return VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkValidationFeaturesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkValidationFeaturesEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pEnabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureEnableEXT const *") IntBuffer value) {
            VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address(), value);
            return this;
        }

        public Buffer pDisabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureDisableEXT const *") IntBuffer value) {
            VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address(), value);
            return this;
        }
    }
}

