/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryProperties;

public class VkExternalBufferProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXTERNALMEMORYPROPERTIES;

    public VkExternalBufferProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExternalBufferProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalBufferProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkExternalBufferProperties.npNext(this.address());
    }

    public VkExternalMemoryProperties externalMemoryProperties() {
        return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
    }

    public VkExternalBufferProperties sType(@NativeType(value="VkStructureType") int value) {
        VkExternalBufferProperties.nsType(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties pNext(@NativeType(value="void *") long value) {
        VkExternalBufferProperties.npNext(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalBufferProperties set(VkExternalBufferProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExternalBufferProperties malloc() {
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExternalBufferProperties calloc() {
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExternalBufferProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExternalBufferProperties create(long address) {
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)address);
    }

    @Nullable
    public static VkExternalBufferProperties createSafe(long address) {
        return address == 0L ? null : (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExternalBufferProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalBufferProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkExternalBufferProperties mallocStack() {
        return VkExternalBufferProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferProperties callocStack() {
        return VkExternalBufferProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferProperties mallocStack(MemoryStack stack) {
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalBufferProperties callocStack(MemoryStack stack) {
        return (VkExternalBufferProperties)VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalBufferProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalBufferProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExternalBufferProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkExternalMemoryProperties nexternalMemoryProperties(long struct) {
        return VkExternalMemoryProperties.create(struct + (long)EXTERNALMEMORYPROPERTIES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkExternalBufferProperties.__struct((Struct.Member[])new Struct.Member[]{VkExternalBufferProperties.__member((int)4), VkExternalBufferProperties.__member((int)POINTER_SIZE), VkExternalBufferProperties.__member((int)VkExternalMemoryProperties.SIZEOF, (int)VkExternalMemoryProperties.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXTERNALMEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalBufferProperties, Buffer>
    implements NativeResource {
        private static final VkExternalBufferProperties ELEMENT_FACTORY = VkExternalBufferProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExternalBufferProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalBufferProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkExternalBufferProperties.npNext(this.address());
        }

        public VkExternalMemoryProperties externalMemoryProperties() {
            return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalBufferProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalBufferProperties.npNext(this.address(), value);
            return this;
        }
    }
}

