/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCmdProcessCommandsInfoNVX;
import org.lwjgl.vulkan.VkCmdReserveSpaceForCommandsInfoNVX;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceGeneratedCommandsFeaturesNVX;
import org.lwjgl.vulkan.VkDeviceGeneratedCommandsLimitsNVX;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutCreateInfoNVX;
import org.lwjgl.vulkan.VkObjectTableCreateInfoNVX;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class NVXDeviceGeneratedCommands {
    public static final int VK_NVX_DEVICE_GENERATED_COMMANDS_SPEC_VERSION = 3;
    public static final String VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME = "VK_NVX_device_generated_commands";
    public static final int VK_STRUCTURE_TYPE_OBJECT_TABLE_CREATE_INFO_NVX = 1000086000;
    public static final int VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NVX = 1000086001;
    public static final int VK_STRUCTURE_TYPE_CMD_PROCESS_COMMANDS_INFO_NVX = 1000086002;
    public static final int VK_STRUCTURE_TYPE_CMD_RESERVE_SPACE_FOR_COMMANDS_INFO_NVX = 1000086003;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_LIMITS_NVX = 1000086004;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_FEATURES_NVX = 1000086005;
    public static final int VK_PIPELINE_STAGE_COMMAND_PROCESS_BIT_NVX = 131072;
    public static final int VK_ACCESS_COMMAND_PROCESS_READ_BIT_NVX = 131072;
    public static final int VK_ACCESS_COMMAND_PROCESS_WRITE_BIT_NVX = 262144;
    public static final int VK_OBJECT_TYPE_OBJECT_TABLE_NVX = 1000086000;
    public static final int VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NVX = 1000086001;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NVX = 1;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_SPARSE_SEQUENCES_BIT_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EMPTY_EXECUTIONS_BIT_NVX = 4;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NVX = 8;
    public static final int VK_OBJECT_ENTRY_USAGE_GRAPHICS_BIT_NVX = 1;
    public static final int VK_OBJECT_ENTRY_USAGE_COMPUTE_BIT_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NVX = 0;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_DESCRIPTOR_SET_NVX = 1;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NVX = 3;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NVX = 4;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NVX = 5;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NVX = 6;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NVX = 7;
    public static final int VK_OBJECT_ENTRY_TYPE_DESCRIPTOR_SET_NVX = 0;
    public static final int VK_OBJECT_ENTRY_TYPE_PIPELINE_NVX = 1;
    public static final int VK_OBJECT_ENTRY_TYPE_INDEX_BUFFER_NVX = 2;
    public static final int VK_OBJECT_ENTRY_TYPE_VERTEX_BUFFER_NVX = 3;
    public static final int VK_OBJECT_ENTRY_TYPE_PUSH_CONSTANT_NVX = 4;

    protected NVXDeviceGeneratedCommands() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME) && VK.checkExtension(VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME, VK.isSupported(provider, "vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX", caps));
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME) && VK.checkExtension(VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME, VK.isSupported(provider, "vkCmdProcessCommandsNVX", caps) && VK.isSupported(provider, "vkCmdReserveSpaceForCommandsNVX", caps) && VK.isSupported(provider, "vkCreateIndirectCommandsLayoutNVX", caps) && VK.isSupported(provider, "vkDestroyIndirectCommandsLayoutNVX", caps) && VK.isSupported(provider, "vkCreateObjectTableNVX", caps) && VK.isSupported(provider, "vkDestroyObjectTableNVX", caps) && VK.isSupported(provider, "vkRegisterObjectsNVX", caps) && VK.isSupported(provider, "vkUnregisterObjectsNVX", caps));
    }

    public static void nvkCmdProcessCommandsNVX(VkCommandBuffer commandBuffer, long pProcessCommandsInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdProcessCommandsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkCmdProcessCommandsInfoNVX.validate(pProcessCommandsInfo);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pProcessCommandsInfo, (long)__functionAddress);
    }

    public static void vkCmdProcessCommandsNVX(VkCommandBuffer commandBuffer, @NativeType(value="VkCmdProcessCommandsInfoNVX const *") VkCmdProcessCommandsInfoNVX pProcessCommandsInfo) {
        NVXDeviceGeneratedCommands.nvkCmdProcessCommandsNVX(commandBuffer, pProcessCommandsInfo.address());
    }

    public static void nvkCmdReserveSpaceForCommandsNVX(VkCommandBuffer commandBuffer, long pReserveSpaceInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdReserveSpaceForCommandsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pReserveSpaceInfo, (long)__functionAddress);
    }

    public static void vkCmdReserveSpaceForCommandsNVX(VkCommandBuffer commandBuffer, @NativeType(value="VkCmdReserveSpaceForCommandsInfoNVX const *") VkCmdReserveSpaceForCommandsInfoNVX pReserveSpaceInfo) {
        NVXDeviceGeneratedCommands.nvkCmdReserveSpaceForCommandsNVX(commandBuffer, pReserveSpaceInfo.address());
    }

    public static int nvkCreateIndirectCommandsLayoutNVX(VkDevice device, long pCreateInfo, long pAllocator, long pIndirectCommandsLayout) {
        long __functionAddress = device.getCapabilities().vkCreateIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkIndirectCommandsLayoutCreateInfoNVX.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pIndirectCommandsLayout, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateIndirectCommandsLayoutNVX(VkDevice device, @NativeType(value="VkIndirectCommandsLayoutCreateInfoNVX const *") VkIndirectCommandsLayoutCreateInfoNVX pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkIndirectCommandsLayoutNVX *") LongBuffer pIndirectCommandsLayout) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pIndirectCommandsLayout, (int)1);
        }
        return NVXDeviceGeneratedCommands.nvkCreateIndirectCommandsLayoutNVX(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pIndirectCommandsLayout));
    }

    public static void nvkDestroyIndirectCommandsLayoutNVX(VkDevice device, long indirectCommandsLayout, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV((long)device.address(), (long)indirectCommandsLayout, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyIndirectCommandsLayoutNVX(VkDevice device, @NativeType(value="VkIndirectCommandsLayoutNVX") long indirectCommandsLayout, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        NVXDeviceGeneratedCommands.nvkDestroyIndirectCommandsLayoutNVX(device, indirectCommandsLayout, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    public static int nvkCreateObjectTableNVX(VkDevice device, long pCreateInfo, long pAllocator, long pObjectTable) {
        long __functionAddress = device.getCapabilities().vkCreateObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkObjectTableCreateInfoNVX.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pObjectTable, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateObjectTableNVX(VkDevice device, @NativeType(value="VkObjectTableCreateInfoNVX const *") VkObjectTableCreateInfoNVX pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkObjectTableNVX *") LongBuffer pObjectTable) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectTable, (int)1);
        }
        return NVXDeviceGeneratedCommands.nvkCreateObjectTableNVX(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pObjectTable));
    }

    public static void nvkDestroyObjectTableNVX(VkDevice device, long objectTable, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV((long)device.address(), (long)objectTable, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyObjectTableNVX(VkDevice device, @NativeType(value="VkObjectTableNVX") long objectTable, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        NVXDeviceGeneratedCommands.nvkDestroyObjectTableNVX(device, objectTable, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    public static int nvkRegisterObjectsNVX(VkDevice device, long objectTable, int objectCount, long ppObjectTableEntries, long pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkRegisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)device.address(), (long)objectTable, (int)objectCount, (long)ppObjectTableEntries, (long)pObjectIndices, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkRegisterObjectsNVX(VkDevice device, @NativeType(value="VkObjectTableNVX") long objectTable, @NativeType(value="VkObjectTableEntryNVX const * const *") PointerBuffer ppObjectTableEntries, @NativeType(value="uint32_t const *") IntBuffer pObjectIndices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectIndices, (int)ppObjectTableEntries.remaining());
        }
        return NVXDeviceGeneratedCommands.nvkRegisterObjectsNVX(device, objectTable, ppObjectTableEntries.remaining(), MemoryUtil.memAddress((CustomBuffer)ppObjectTableEntries), MemoryUtil.memAddress((IntBuffer)pObjectIndices));
    }

    public static int nvkUnregisterObjectsNVX(VkDevice device, long objectTable, int objectCount, long pObjectEntryTypes, long pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkUnregisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)device.address(), (long)objectTable, (int)objectCount, (long)pObjectEntryTypes, (long)pObjectIndices, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkUnregisterObjectsNVX(VkDevice device, @NativeType(value="VkObjectTableNVX") long objectTable, @NativeType(value="VkObjectEntryTypeNVX const *") IntBuffer pObjectEntryTypes, @NativeType(value="uint32_t const *") IntBuffer pObjectIndices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectIndices, (int)pObjectEntryTypes.remaining());
        }
        return NVXDeviceGeneratedCommands.nvkUnregisterObjectsNVX(device, objectTable, pObjectEntryTypes.remaining(), MemoryUtil.memAddress((IntBuffer)pObjectEntryTypes), MemoryUtil.memAddress((IntBuffer)pObjectIndices));
    }

    public static void nvkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(VkPhysicalDevice physicalDevice, long pFeatures, long pLimits) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)physicalDevice.address(), (long)pFeatures, (long)pLimits, (long)__functionAddress);
    }

    public static void vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(VkPhysicalDevice physicalDevice, @NativeType(value="VkDeviceGeneratedCommandsFeaturesNVX *") VkDeviceGeneratedCommandsFeaturesNVX pFeatures, @NativeType(value="VkDeviceGeneratedCommandsLimitsNVX *") VkDeviceGeneratedCommandsLimitsNVX pLimits) {
        NVXDeviceGeneratedCommands.nvkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(physicalDevice, pFeatures.address(), pLimits.address());
    }

    @NativeType(value="VkResult")
    public static int vkCreateIndirectCommandsLayoutNVX(VkDevice device, @NativeType(value="VkIndirectCommandsLayoutCreateInfoNVX const *") VkIndirectCommandsLayoutCreateInfoNVX pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkIndirectCommandsLayoutNVX *") long[] pIndirectCommandsLayout) {
        long __functionAddress = device.getCapabilities().vkCreateIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pIndirectCommandsLayout, (int)1);
            VkIndirectCommandsLayoutCreateInfoNVX.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pIndirectCommandsLayout, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateObjectTableNVX(VkDevice device, @NativeType(value="VkObjectTableCreateInfoNVX const *") VkObjectTableCreateInfoNVX pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkObjectTableNVX *") long[] pObjectTable) {
        long __functionAddress = device.getCapabilities().vkCreateObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pObjectTable, (int)1);
            VkObjectTableCreateInfoNVX.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pObjectTable, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkRegisterObjectsNVX(VkDevice device, @NativeType(value="VkObjectTableNVX") long objectTable, @NativeType(value="VkObjectTableEntryNVX const * const *") PointerBuffer ppObjectTableEntries, @NativeType(value="uint32_t const *") int[] pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkRegisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pObjectIndices, (int)ppObjectTableEntries.remaining());
        }
        return JNI.callPJPPI((long)device.address(), (long)objectTable, (int)ppObjectTableEntries.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)ppObjectTableEntries), (int[])pObjectIndices, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkUnregisterObjectsNVX(VkDevice device, @NativeType(value="VkObjectTableNVX") long objectTable, @NativeType(value="VkObjectEntryTypeNVX const *") int[] pObjectEntryTypes, @NativeType(value="uint32_t const *") int[] pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkUnregisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pObjectIndices, (int)pObjectEntryTypes.length);
        }
        return JNI.callPJPPI((long)device.address(), (long)objectTable, (int)pObjectEntryTypes.length, (int[])pObjectEntryTypes, (int[])pObjectIndices, (long)__functionAddress);
    }
}

