/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_bakedchar")
public class STBTTBakedChar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;

    public STBTTBakedChar(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), STBTTBakedChar.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned short")
    public short x0() {
        return STBTTBakedChar.nx0(this.address());
    }

    @NativeType(value="unsigned short")
    public short y0() {
        return STBTTBakedChar.ny0(this.address());
    }

    @NativeType(value="unsigned short")
    public short x1() {
        return STBTTBakedChar.nx1(this.address());
    }

    @NativeType(value="unsigned short")
    public short y1() {
        return STBTTBakedChar.ny1(this.address());
    }

    public float xoff() {
        return STBTTBakedChar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTBakedChar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTBakedChar.nxadvance(this.address());
    }

    public static STBTTBakedChar malloc() {
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static STBTTBakedChar calloc() {
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static STBTTBakedChar create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static STBTTBakedChar create(long address) {
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)address);
    }

    @Nullable
    public static STBTTBakedChar createSafe(long address) {
        return address == 0L ? null : (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)STBTTBakedChar.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = STBTTBakedChar.__create((int)capacity, (int)SIZEOF);
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static STBTTBakedChar mallocStack() {
        return STBTTBakedChar.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTBakedChar callocStack() {
        return STBTTBakedChar.callocStack(MemoryStack.stackGet());
    }

    public static STBTTBakedChar mallocStack(MemoryStack stack) {
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTBakedChar callocStack(MemoryStack stack) {
        return (STBTTBakedChar)STBTTBakedChar.wrap(STBTTBakedChar.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTBakedChar.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTBakedChar.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)STBTTBakedChar.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static short nx0(long struct) {
        return UNSAFE.getShort(null, struct + (long)X0);
    }

    public static short ny0(long struct) {
        return UNSAFE.getShort(null, struct + (long)Y0);
    }

    public static short nx1(long struct) {
        return UNSAFE.getShort(null, struct + (long)X1);
    }

    public static short ny1(long struct) {
        return UNSAFE.getShort(null, struct + (long)Y1);
    }

    public static float nxoff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XOFF);
    }

    public static float nyoff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)YOFF);
    }

    public static float nxadvance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XADVANCE);
    }

    static {
        Struct.Layout layout = STBTTBakedChar.__struct((Struct.Member[])new Struct.Member[]{STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)4), STBTTBakedChar.__member((int)4), STBTTBakedChar.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<STBTTBakedChar, Buffer>
    implements NativeResource {
        private static final STBTTBakedChar ELEMENT_FACTORY = STBTTBakedChar.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected STBTTBakedChar getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned short")
        public short x0() {
            return STBTTBakedChar.nx0(this.address());
        }

        @NativeType(value="unsigned short")
        public short y0() {
            return STBTTBakedChar.ny0(this.address());
        }

        @NativeType(value="unsigned short")
        public short x1() {
            return STBTTBakedChar.nx1(this.address());
        }

        @NativeType(value="unsigned short")
        public short y1() {
            return STBTTBakedChar.ny1(this.address());
        }

        public float xoff() {
            return STBTTBakedChar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTBakedChar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTBakedChar.nxadvance(this.address());
        }
    }
}

