/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SpvcBufferRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEX;
    public static final int OFFSET;
    public static final int RANGE;

    public SpvcBufferRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcBufferRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int index() {
        return SpvcBufferRange.nindex(this.address());
    }

    @NativeType(value="size_t")
    public long offset() {
        return SpvcBufferRange.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long range() {
        return SpvcBufferRange.nrange(this.address());
    }

    public SpvcBufferRange index(@NativeType(value="unsigned int") int value) {
        SpvcBufferRange.nindex(this.address(), value);
        return this;
    }

    public SpvcBufferRange offset(@NativeType(value="size_t") long value) {
        SpvcBufferRange.noffset(this.address(), value);
        return this;
    }

    public SpvcBufferRange range(@NativeType(value="size_t") long value) {
        SpvcBufferRange.nrange(this.address(), value);
        return this;
    }

    public SpvcBufferRange set(int index, long offset, long range) {
        this.index(index);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public SpvcBufferRange set(SpvcBufferRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcBufferRange malloc() {
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcBufferRange calloc() {
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcBufferRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcBufferRange create(long address) {
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)address);
    }

    @Nullable
    public static SpvcBufferRange createSafe(long address) {
        return address == 0L ? null : (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcBufferRange.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcBufferRange.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcBufferRange mallocStack() {
        return SpvcBufferRange.mallocStack(MemoryStack.stackGet());
    }

    public static SpvcBufferRange callocStack() {
        return SpvcBufferRange.callocStack(MemoryStack.stackGet());
    }

    public static SpvcBufferRange mallocStack(MemoryStack stack) {
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcBufferRange callocStack(MemoryStack stack) {
        return (SpvcBufferRange)SpvcBufferRange.wrap(SpvcBufferRange.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SpvcBufferRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SpvcBufferRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcBufferRange.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nindex(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEX);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OFFSET));
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RANGE));
    }

    public static void nindex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEX, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RANGE), (long)value);
    }

    static {
        Struct.Layout layout = SpvcBufferRange.__struct((Struct.Member[])new Struct.Member[]{SpvcBufferRange.__member((int)4), SpvcBufferRange.__member((int)POINTER_SIZE), SpvcBufferRange.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEX = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcBufferRange, Buffer>
    implements NativeResource {
        private static final SpvcBufferRange ELEMENT_FACTORY = SpvcBufferRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcBufferRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int index() {
            return SpvcBufferRange.nindex(this.address());
        }

        @NativeType(value="size_t")
        public long offset() {
            return SpvcBufferRange.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long range() {
            return SpvcBufferRange.nrange(this.address());
        }

        public Buffer index(@NativeType(value="unsigned int") int value) {
            SpvcBufferRange.nindex(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="size_t") long value) {
            SpvcBufferRange.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="size_t") long value) {
            SpvcBufferRange.nrange(this.address(), value);
            return this;
        }
    }
}

