/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU80;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUDA_LAUNCH_PARAMS;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CU90
extends CU80 {
    public static final int CU_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC = 1;
    public static final int CU_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC = 2;

    protected CU90() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="CUresult")
    public static int cuFuncSetAttribute(@NativeType(value="CUfunction") long hfunc, @NativeType(value="CUfunction_attribute") int attrib, int value) {
        long __functionAddress = Functions.FuncSetAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)hfunc);
        }
        return JNI.callPI((long)hfunc, (int)attrib, (int)value, (long)__functionAddress);
    }

    public static int ncuLaunchCooperativeKernel(long f, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, long hStream, long kernelParams) {
        long __functionAddress = Functions.LaunchCooperativeKernel;
        if (Checks.CHECKS) {
            Checks.check((long)f);
        }
        return JNI.callPPPI((long)f, (int)gridDimX, (int)gridDimY, (int)gridDimZ, (int)blockDimX, (int)blockDimY, (int)blockDimZ, (int)sharedMemBytes, (long)hStream, (long)kernelParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchCooperativeKernel(@NativeType(value="CUfunction") long f, @NativeType(value="unsigned int") int gridDimX, @NativeType(value="unsigned int") int gridDimY, @NativeType(value="unsigned int") int gridDimZ, @NativeType(value="unsigned int") int blockDimX, @NativeType(value="unsigned int") int blockDimY, @NativeType(value="unsigned int") int blockDimZ, @NativeType(value="unsigned int") int sharedMemBytes, @NativeType(value="CUstream") long hStream, @Nullable @NativeType(value="void **") PointerBuffer kernelParams) {
        return CU90.ncuLaunchCooperativeKernel(f, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, hStream, MemoryUtil.memAddressSafe((Pointer)kernelParams));
    }

    public static int ncuLaunchCooperativeKernelMultiDevice(long launchParamsList, int numDevices, int flags) {
        long __functionAddress = Functions.LaunchCooperativeKernelMultiDevice;
        if (Checks.CHECKS) {
            CUDA_LAUNCH_PARAMS.validate(launchParamsList, numDevices);
        }
        return JNI.callPI((long)launchParamsList, (int)numDevices, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchCooperativeKernelMultiDevice(@NativeType(value="CUDA_LAUNCH_PARAMS *") CUDA_LAUNCH_PARAMS.Buffer launchParamsList, @NativeType(value="unsigned int") int flags) {
        return CU90.ncuLaunchCooperativeKernelMultiDevice(launchParamsList.address(), launchParamsList.remaining(), flags);
    }

    public static final class Functions {
        public static final long FuncSetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuFuncSetAttribute");
        public static final long LaunchCooperativeKernel = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuLaunchCooperativeKernel"));
        public static final long LaunchCooperativeKernelMultiDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuLaunchCooperativeKernelMultiDevice");

        private Functions() {
        }
    }
}

