/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;

public class JRProperties {
    protected static final String DEFAULT_PROPERTIES_FILE = "jasperreports.properties";
    protected static final String PROPERTY_PREFIX = "net.sf.jasperreports.";
    public static final String PROPERTIES_FILE = "net.sf.jasperreports.properties";
    public static final String COMPILER_CLASS = "net.sf.jasperreports.compiler.class";
    public static final String COMPILER_XML_VALIDATION = "net.sf.jasperreports.compiler.xml.validation";
    public static final String COMPILER_KEEP_JAVA_FILE = "net.sf.jasperreports.compiler.keep.java.file";
    public static final String COMPILER_TEMP_DIR = "net.sf.jasperreports.compiler.temp.dir";
    public static final String COMPILER_CLASSPATH = "net.sf.jasperreports.compiler.classpath";
    public static final String EXPORT_XML_VALIDATION = "net.sf.jasperreports.export.xml.validation";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    protected static Properties props;
    protected static Properties savedProps;

    protected static void initProperties() {
        try {
            Properties defaults = JRProperties.getDefaults();
            String propFile = System.getProperty(PROPERTIES_FILE);
            if (propFile == null) {
                props = JRProperties.loadProperties(DEFAULT_PROPERTIES_FILE, defaults);
                if (props == null) {
                    props = defaults;
                }
            } else {
                props = JRProperties.loadProperties(propFile, defaults);
                if (props == null) {
                    throw new JRRuntimeException("Could not load properties file \"" + propFile + "\"");
                }
            }
            JRProperties.loadSystemProperties();
        }
        catch (JRException e) {
            throw new JRRuntimeException("Error loading the properties", e);
        }
    }

    protected static void loadSystemProperties() {
        JRProperties.loadSystemProperty("jasper.reports.compiler.class", COMPILER_CLASS);
        JRProperties.loadSystemProperty("jasper.reports.compile.xml.validation", COMPILER_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.export.xml.validation", EXPORT_XML_VALIDATION);
        JRProperties.loadSystemProperty("jasper.reports.compile.keep.java.file", COMPILER_KEEP_JAVA_FILE);
        JRProperties.loadSystemProperty("jasper.reports.compile.temp", COMPILER_TEMP_DIR);
        JRProperties.loadSystemProperty("jasper.reports.compile.class.path", COMPILER_CLASSPATH);
    }

    protected static Properties getDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty(COMPILER_XML_VALIDATION, String.valueOf(true));
        defaults.setProperty(COMPILER_KEEP_JAVA_FILE, String.valueOf(false));
        defaults.setProperty(EXPORT_XML_VALIDATION, String.valueOf(true));
        defaults.setProperty(COMPILER_TEMP_DIR, System.getProperty("user.dir"));
        defaults.setProperty(COMPILER_CLASSPATH, System.getProperty("java.class.path"));
        return defaults;
    }

    protected static void loadSystemProperty(String sysKey, String propKey) {
        String val = System.getProperty(sysKey);
        if (val != null) {
            props.setProperty(propKey, val);
        }
    }

    public static Properties loadProperties(String name, Properties defaults) throws JRException {
        InputStream is = JRLoader.getLocationInputStream(name);
        Properties properties = null;
        if (is != null) {
            properties = new Properties(defaults);
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new JRException("Failed to load properties file \"" + name + "\"", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static boolean getBooleanProperty(String key) {
        return Boolean.valueOf(props.getProperty(key));
    }

    public static void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public static void setProperty(String key, boolean value) {
        props.setProperty(key, String.valueOf(value));
    }

    public static void backupProperties() {
        savedProps = (Properties)props.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreProperties() {
        if (savedProps != null) {
            try {
                props.clear();
                props.putAll((Map<?, ?>)savedProps);
            }
            finally {
                savedProps = null;
            }
        }
    }

    public static List getProperties(String prefix) {
        int prefixLength = prefix.length();
        ArrayList<PropertySuffix> values = new ArrayList<PropertySuffix>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix)) continue;
            String suffix = name.substring(prefixLength);
            String value = props.getProperty(name);
            values.add(new PropertySuffix(suffix, value));
        }
        return values;
    }

    static {
        JRProperties.initProperties();
    }

    public static class PropertySuffix {
        protected final String suffix;
        protected final String value;

        public PropertySuffix(String suffix, String value) {
            this.suffix = suffix;
            this.value = value;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getValue() {
            return this.value;
        }
    }
}

