/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ServerVerifyChecker {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean check(SSL2ServerVerifyMessage message, TlsContext context, boolean decreaseLogNoise) {
        byte[] decryptedPart;
        SSL2CipherSuite cipherSuite = context.getChooser().getSSL2CipherSuite();
        switch (cipherSuite) {
            case SSL_CK_RC4_128_WITH_MD5: 
            case SSL_CK_RC4_128_EXPORT40_WITH_MD5: {
                decryptedPart = ServerVerifyChecker.decryptRC4(message, context);
                break;
            }
            case SSL_CK_RC2_128_CBC_WITH_MD5: 
            case SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5: {
                decryptedPart = ServerVerifyChecker.decryptRC2(message, context);
                break;
            }
            case SSL_CK_DES_64_CBC_WITH_MD5: {
                decryptedPart = ServerVerifyChecker.decryptCbcDes(message, context);
                break;
            }
            case SSL_CK_DES_192_EDE3_CBC_WITH_MD5: {
                decryptedPart = ServerVerifyChecker.decryptCbcDesEde3(message, context);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Check not implemented for the selected cipher suite");
            }
        }
        return ServerVerifyChecker.compareDecrypted(decryptedPart, context.getClientRandom(), decreaseLogNoise);
    }

    public static boolean compareDecrypted(byte[] decrypted, byte[] clientRandom, boolean silent) {
        if (decrypted.length <= 17) {
            LOGGER.warn("Decrypted Server-Verify message is too short");
            return false;
        }
        int typeOffset = 16;
        if (decrypted[typeOffset] != HandshakeMessageType.SSL2_SERVER_VERIFY.getValue()) {
            if (!silent) {
                LOGGER.warn("Wrong message type in decrypted Server-Verify message");
            }
            return false;
        }
        int challengeOffset = typeOffset + 1;
        byte[] decryptedChallenge = Arrays.copyOfRange(decrypted, challengeOffset, decrypted.length);
        return Arrays.equals(decryptedChallenge, clientRandom);
    }

    private static byte[] decryptRC4(SSL2ServerVerifyMessage message, TlsContext context) {
        byte[] clientReadKey = ServerVerifyChecker.makeKeyMaterial(context, "0");
        byte[] encrypted = (byte[])message.getEncryptedPart().getValue();
        return ServerVerifyChecker.decryptRC4(clientReadKey, encrypted);
    }

    static byte[] decryptRC4(byte[] clientReadKey, byte[] encrypted) {
        RC4Engine rc4 = new RC4Engine();
        rc4.init(false, (CipherParameters)new KeyParameter(clientReadKey));
        int len = encrypted.length;
        byte[] decrypted = new byte[len];
        rc4.processBytes(encrypted, 0, len, decrypted, 0);
        return decrypted;
    }

    private static byte[] decryptRC2(SSL2ServerVerifyMessage message, TlsContext context) {
        byte[] clientReadKey = ServerVerifyChecker.makeKeyMaterial(context, "0");
        byte[] iv = context.getSSL2Iv();
        return ServerVerifyChecker.decryptRC2(clientReadKey, (byte[])message.getEncryptedPart().getValue(), iv, (Integer)message.getPaddingLength().getValue());
    }

    static byte[] decryptRC2(byte[] clientReadKey, byte[] encrypted, byte[] iv, int paddingLength) {
        CBCBlockCipher cbcRc2 = new CBCBlockCipher((BlockCipher)new RC2Engine());
        ParametersWithIV cbcRc2Params = new ParametersWithIV((CipherParameters)new KeyParameter(clientReadKey), iv);
        cbcRc2.init(false, (CipherParameters)cbcRc2Params);
        return ServerVerifyChecker.processEncryptedBlocks((BlockCipher)cbcRc2, encrypted, paddingLength);
    }

    private static byte[] decryptCbcDes(SSL2ServerVerifyMessage message, TlsContext context) {
        byte[] keyMaterial = ServerVerifyChecker.makeKeyMaterial(context, "0");
        byte[] clientReadKey = Arrays.copyOfRange(keyMaterial, 0, 8);
        DESParameters.setOddParity((byte[])clientReadKey);
        byte[] iv = context.getSSL2Iv();
        CBCBlockCipher cbcDes = new CBCBlockCipher((BlockCipher)new DESEngine());
        ParametersWithIV cbcDesParams = new ParametersWithIV((CipherParameters)new DESParameters(clientReadKey), iv);
        cbcDes.init(false, (CipherParameters)cbcDesParams);
        return ServerVerifyChecker.processEncryptedBlocks((BlockCipher)cbcDes, (byte[])message.getEncryptedPart().getValue(), (Integer)message.getPaddingLength().getValue());
    }

    private static byte[] decryptCbcDesEde3(SSL2ServerVerifyMessage message, TlsContext context) {
        byte[] clientReadKey = new byte[24];
        byte[] keyMaterial0 = ServerVerifyChecker.makeKeyMaterial(context, "0");
        System.arraycopy(keyMaterial0, 0, clientReadKey, 0, keyMaterial0.length);
        byte[] keyMaterial1 = ServerVerifyChecker.makeKeyMaterial(context, "1");
        System.arraycopy(keyMaterial1, 0, clientReadKey, keyMaterial0.length, 8);
        byte[] iv = context.getSSL2Iv();
        CBCBlockCipher cbcDesEde = new CBCBlockCipher((BlockCipher)new DESedeEngine());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(clientReadKey), iv);
        cbcDesEde.init(false, (CipherParameters)params);
        return ServerVerifyChecker.processEncryptedBlocks((BlockCipher)cbcDesEde, (byte[])message.getEncryptedPart().getValue(), (Integer)message.getPaddingLength().getValue());
    }

    private static byte[] makeKeyMaterial(TlsContext tlsContext, String index) {
        SSL2CipherSuite cipherSuite = tlsContext.getChooser().getSSL2CipherSuite();
        byte[] clearKey = tlsContext.getClearKey();
        byte[] secretKey = tlsContext.getPreMasterSecret();
        if (clearKey.length != cipherSuite.getClearKeyByteNumber()) {
            int remainingLength = secretKey.length - (clearKey.length - cipherSuite.getClearKeyByteNumber());
            secretKey = Arrays.copyOfRange(secretKey, 0, remainingLength);
        }
        byte[] masterKey = ArrayConverter.concatenate((byte[][])new byte[][]{clearKey, secretKey});
        return ServerVerifyChecker.makeKeyMaterial(masterKey, tlsContext.getClientRandom(), tlsContext.getServerRandom(), index);
    }

    static byte[] makeKeyMaterial(byte[] masterKey, byte[] clientRandom, byte[] serverRandom, String index) {
        MD5Digest md5 = new MD5Digest();
        ServerVerifyChecker.md5Update(md5, masterKey);
        ServerVerifyChecker.md5Update(md5, index.getBytes(Charset.forName("US-ASCII")));
        ServerVerifyChecker.md5Update(md5, clientRandom);
        ServerVerifyChecker.md5Update(md5, serverRandom);
        byte[] md5Output = new byte[md5.getDigestSize()];
        md5.doFinal(md5Output, 0);
        return md5Output;
    }

    private static void md5Update(MD5Digest md5, byte[] bytes) {
        md5.update(bytes, 0, bytes.length);
    }

    private static byte[] processEncryptedBlocks(BlockCipher cipher, byte[] encrypted, int paddingLength) {
        if (encrypted.length % cipher.getBlockSize() != 0) {
            LOGGER.warn("Server-Verify payload has invalid length");
            return new byte[0];
        }
        byte[] decrypted = new byte[encrypted.length];
        for (int processedLength = 0; processedLength < encrypted.length; processedLength += cipher.processBlock(encrypted, processedLength, decrypted, processedLength)) {
        }
        return Arrays.copyOfRange(decrypted, 0, decrypted.length - paddingLength);
    }
}

