/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Maintenance;

@Path(value="events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EventResource
extends BaseResource {
    @Path(value="{id}")
    @GET
    public Event get(@PathParam(value="id") long id) throws SQLException {
        Event event = Context.getDataManager().getObject(Event.class, id);
        if (event == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        Context.getPermissionsManager().checkDevice(this.getUserId(), event.getDeviceId());
        if (event.getGeofenceId() != 0L) {
            Context.getPermissionsManager().checkPermission(Geofence.class, this.getUserId(), event.getGeofenceId());
        }
        if (event.getMaintenanceId() != 0L) {
            Context.getPermissionsManager().checkPermission(Maintenance.class, this.getUserId(), event.getMaintenanceId());
        }
        return event;
    }
}

