/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.traccar.database.DataManager;

public class Permission {
    private final Class<?> ownerClass;
    private final long ownerId;
    private final Class<?> propertyClass;
    private final long propertyId;

    public Permission(LinkedHashMap<String, Long> permissionMap) throws ClassNotFoundException {
        Iterator<Map.Entry<String, Long>> iterator = permissionMap.entrySet().iterator();
        String owner = iterator.next().getKey();
        this.ownerClass = DataManager.getClassByName(owner);
        String property = iterator.next().getKey();
        this.propertyClass = DataManager.getClassByName(property);
        this.ownerId = permissionMap.get(owner);
        this.propertyId = permissionMap.get(property);
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public long getPropertyId() {
        return this.propertyId;
    }
}

