/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.playlist.FilePlayListReplay;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.CompositeFileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerContentLineNumber;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerMissingFiles;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.Messages;
import org.pentaho.di.trans.steps.textfileinput.TextFileFilterProcessor;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputData;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileLine;

public class TextFileInput
extends BaseStep
implements StepInterface {
    private static final int BUFFER_SIZE_INPUT_STREAM = 500;
    private static LogWriter log = LogWriter.getInstance();
    private TextFileInputMeta meta;
    private TextFileInputData data;
    private long lineNumberInFile;
    private TransMeta transmeta;

    public TextFileInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.transmeta = transMeta;
    }

    public static final String getLine(LogWriter log, InputStreamReader reader, int formatNr, StringBuilder line) throws KettleFileException {
        int c = 0;
        line.setLength(0);
        try {
            switch (formatNr) {
                case 0: {
                    while (c >= 0) {
                        c = reader.read();
                        if (c == 13 || c == 10) {
                            c = reader.read();
                            if (c != 13 && c != 10) {
                                throw new KettleFileException(Messages.getString("TextFileInput.Log.SingleLineFound"));
                            }
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 1: {
                    while (c >= 0) {
                        c = reader.read();
                        if (c == 10 || c == 13) {
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 2: {
                    while (c >= 0) {
                        c = reader.read();
                        if (c == 10) {
                            return line.toString();
                        }
                        if (c == 13 || c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
            }
        }
        catch (KettleFileException e) {
            throw e;
        }
        catch (Exception e) {
            if (line.length() == 0) {
                throw new KettleFileException(Messages.getString("TextFileInput.Log.Error.ExceptionReadingLine", e.toString()), (Throwable)e);
            }
            return line.toString();
        }
        if (line.length() > 0) {
            return line.toString();
        }
        return null;
    }

    public static final String[] guessStringsFromLine(String line, TextFileInputMeta inf) throws KettleException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            if (line == null) {
                return null;
            }
            if (inf.getFileType().equalsIgnoreCase("CSV")) {
                int len_esc;
                int fieldnr = 0;
                int pos = 0;
                int length = line.length();
                boolean dencl = false;
                int len_encl = inf.getEnclosure() == null ? 0 : inf.getEnclosure().length();
                int n = len_esc = inf.getEscapeCharacter() == null ? 0 : inf.getEscapeCharacter().length();
                while (pos < length) {
                    String pol;
                    int next;
                    boolean encl_found;
                    int from = pos;
                    boolean contains_escaped_enclosures = false;
                    boolean contains_escaped_separators = false;
                    if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(inf.getEnclosure())) {
                        String strnext;
                        if (log.isRowLevel()) {
                            log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.ConvertLineToRow", line.substring(from, from + len_encl)), new Object[0]);
                        }
                        encl_found = true;
                        int p = from + len_encl;
                        boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(inf.getEnclosure());
                        boolean is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(inf.getEscapeCharacter());
                        boolean enclosure_after = false;
                        if ((is_enclosure || is_escape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(inf.getEnclosure())) {
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (is_escape) {
                                contains_escaped_enclosures = true;
                            }
                        }
                        while ((!is_enclosure || enclosure_after) && p < line.length()) {
                            enclosure_after = false;
                            is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(inf.getEnclosure());
                            boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(inf.getEscapeCharacter());
                            if (!is_enclosure && !is_escape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(inf.getEnclosure())) continue;
                            ++p;
                            enclosure_after = true;
                            dencl = true;
                            if (!is_escape) continue;
                            contains_escaped_enclosures = true;
                        }
                        next = p >= length ? p : p + len_encl;
                        if (log.isRowLevel()) {
                            log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EndOfEnclosure", "" + p), new Object[0]);
                        }
                    } else {
                        encl_found = false;
                        boolean found = false;
                        int startpoint = from;
                        int tries = 1;
                        do {
                            next = line.indexOf(inf.getSeparator(), startpoint);
                            if (len_esc > 0 && next - len_esc > 0) {
                                String before = line.substring(next - len_esc, next);
                                if (inf.getEscapeCharacter().equals(before)) {
                                    startpoint = next + 1;
                                    ++tries;
                                    contains_escaped_separators = true;
                                    continue;
                                }
                                found = true;
                                continue;
                            }
                            found = true;
                        } while (!found && next >= 0);
                    }
                    if (next == -1) {
                        next = length;
                    }
                    if (encl_found) {
                        pol = line.substring(from + len_encl, next - len_encl);
                        if (log.isRowLevel()) {
                            log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EnclosureFieldFound", "" + pol), new Object[0]);
                        }
                    } else {
                        pol = line.substring(from, next);
                        if (log.isRowLevel()) {
                            log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.NormalFieldFound", "" + pol), new Object[0]);
                        }
                    }
                    if (dencl) {
                        StringBuilder sbpol = new StringBuilder(pol);
                        int idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                        while (idx >= 0) {
                            sbpol.delete(idx, idx + inf.getEnclosure().length());
                            idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                        }
                        pol = sbpol.toString();
                    }
                    if (contains_escaped_enclosures) {
                        String replace = inf.getEscapeCharacter() + inf.getEnclosure();
                        String replaceWith = inf.getEnclosure();
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    if (contains_escaped_separators) {
                        String replace = inf.getEscapeCharacter() + inf.getSeparator();
                        String replaceWith = inf.getSeparator();
                        pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                    }
                    strings.add(pol);
                    pos = next + inf.getSeparator().length();
                    ++fieldnr;
                }
                if (pos == length) {
                    if (log.isRowLevel()) {
                        log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EndOfEmptyLineFound"), new Object[0]);
                    }
                    strings.add("");
                    ++fieldnr;
                }
            } else {
                for (int i = 0; i < inf.getInputFields().length; ++i) {
                    TextFileInputField field = inf.getInputFields()[i];
                    int length = line.length();
                    if (field.getPosition() + field.getLength() <= length) {
                        strings.add(line.substring(field.getPosition(), field.getPosition() + field.getLength()));
                        continue;
                    }
                    if (field.getPosition() < length) {
                        strings.add(line.substring(field.getPosition()));
                        continue;
                    }
                    strings.add("");
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("TextFileInput.Log.Error.ErrorConvertingLine", e.toString()), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static final String[] convertLineToStrings(String line, InputFileMetaInterface inf) throws KettleException {
        String[] strings;
        block31: {
            strings = new String[inf.getInputFields().length];
            try {
                if (line == null) {
                    return null;
                }
                if (inf.getFileType().equalsIgnoreCase("CSV")) {
                    int len_esc;
                    int fieldnr = 0;
                    int pos = 0;
                    int length = line.length();
                    boolean dencl = false;
                    int len_encl = inf.getEnclosure() == null ? 0 : inf.getEnclosure().length();
                    int n = len_esc = inf.getEscapeCharacter() == null ? 0 : inf.getEscapeCharacter().length();
                    while (pos < length) {
                        String pol;
                        int next;
                        boolean encl_found;
                        int from = pos;
                        boolean contains_escaped_enclosures = false;
                        boolean contains_escaped_separators = false;
                        if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(inf.getEnclosure())) {
                            String strnext;
                            if (log.isRowLevel()) {
                                log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.Encloruse", line.substring(from, from + len_encl)), new Object[0]);
                            }
                            encl_found = true;
                            int p = from + len_encl;
                            boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(inf.getEnclosure());
                            boolean is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equalsIgnoreCase(inf.getEscapeCharacter());
                            boolean enclosure_after = false;
                            if ((is_enclosure || is_escape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(inf.getEnclosure())) {
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (is_escape) {
                                    contains_escaped_enclosures = true;
                                }
                            }
                            while ((!is_enclosure || enclosure_after) && p < line.length()) {
                                enclosure_after = false;
                                is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(inf.getEnclosure());
                                boolean bl = is_escape = len_esc > 0 && p + len_esc < length && line.substring(p, p + len_esc).equals(inf.getEscapeCharacter());
                                if (!is_enclosure && !is_escape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(inf.getEnclosure())) continue;
                                ++p;
                                enclosure_after = true;
                                dencl = true;
                                if (!is_escape) continue;
                                contains_escaped_enclosures = true;
                            }
                            next = p >= length ? p : p + len_encl;
                            if (log.isRowLevel()) {
                                log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EndOfEnclosure", "" + p), new Object[0]);
                            }
                        } else {
                            encl_found = false;
                            boolean found = false;
                            int startpoint = from;
                            int tries = 1;
                            do {
                                next = line.indexOf(inf.getSeparator(), startpoint);
                                if (len_esc > 0 && next - len_esc > 0) {
                                    String before = line.substring(next - len_esc, next);
                                    if (inf.getEscapeCharacter().equals(before)) {
                                        startpoint = next + 1;
                                        ++tries;
                                        contains_escaped_separators = true;
                                        continue;
                                    }
                                    found = true;
                                    continue;
                                }
                                found = true;
                            } while (!found && next >= 0);
                        }
                        if (next == -1) {
                            next = length;
                        }
                        if (encl_found && from + len_encl <= next - len_encl) {
                            pol = line.substring(from + len_encl, next - len_encl);
                            if (log.isRowLevel()) {
                                log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EnclosureFieldFound", "" + pol), new Object[0]);
                            }
                        } else {
                            pol = line.substring(from, next);
                            if (log.isRowLevel()) {
                                log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.NormalFieldFound", "" + pol), new Object[0]);
                            }
                        }
                        if (dencl && Const.isEmpty((String)inf.getEscapeCharacter())) {
                            StringBuilder sbpol = new StringBuilder(pol);
                            int idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                            while (idx >= 0) {
                                sbpol.delete(idx, idx + inf.getEnclosure().length());
                                idx = sbpol.indexOf(inf.getEnclosure() + inf.getEnclosure());
                            }
                            pol = sbpol.toString();
                        }
                        if (contains_escaped_enclosures) {
                            String replace = inf.getEscapeCharacter() + inf.getEnclosure();
                            String replaceWith = inf.getEnclosure();
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        if (contains_escaped_separators) {
                            String replace = inf.getEscapeCharacter() + inf.getSeparator();
                            String replaceWith = inf.getSeparator();
                            pol = Const.replace((String)pol, (String)replace, (String)replaceWith);
                        }
                        try {
                            strings[fieldnr] = pol;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            String[] newStrings = new String[strings.length];
                            for (int x = 0; x < strings.length; ++x) {
                                newStrings[x] = strings[x];
                            }
                            strings = newStrings;
                        }
                        pos = next + inf.getSeparator().length();
                        ++fieldnr;
                    }
                    if (pos == length) {
                        if (log.isRowLevel()) {
                            log.logRowlevel(Messages.getString("TextFileInput.Log.ConvertLineToRowTitle"), Messages.getString("TextFileInput.Log.EndOfEmptyLineFound"), new Object[0]);
                        }
                        if (fieldnr < strings.length) {
                            strings[fieldnr] = "";
                        }
                        ++fieldnr;
                    }
                    break block31;
                }
                for (int i = 0; i < inf.getInputFields().length; ++i) {
                    TextFileInputField field = inf.getInputFields()[i];
                    int length = line.length();
                    strings[i] = field.getPosition() + field.getLength() <= length ? line.substring(field.getPosition(), field.getPosition() + field.getLength()) : (field.getPosition() < length ? line.substring(field.getPosition()) : "");
                }
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("TextFileInput.Log.Error.ErrorConvertingLine", e.toString()), (Throwable)e);
            }
        }
        return strings;
    }

    public static final Object[] convertLineToRow(TextFileLine textFileLine, InputFileMetaInterface info, RowMetaInterface outputRowMeta, RowMetaInterface convertRowMeta, String fname, long rowNr, FileErrorHandler errorHandler) throws KettleException {
        return TextFileInput.convertLineToRow(textFileLine, info, null, 0, outputRowMeta, convertRowMeta, fname, rowNr, errorHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object[] convertLineToRow(TextFileLine textFileLine, InputFileMetaInterface info, Object[] passThruFields, int nrPassThruFields, RowMetaInterface outputRowMeta, RowMetaInterface convertRowMeta, String fname, long rowNr, FileErrorHandler errorHandler) throws KettleException {
        if (textFileLine == null || textFileLine.line == null) {
            return null;
        }
        Object[] r = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int nrfields = info.getInputFields().length;
        Long errorCount = null;
        if (info.isErrorIgnored() && info.getErrorCountField() != null && info.getErrorCountField().length() > 0) {
            errorCount = new Long(0L);
        }
        String errorFields = null;
        if (info.isErrorIgnored() && info.getErrorFieldsField() != null && info.getErrorFieldsField().length() > 0) {
            errorFields = "";
        }
        String errorText = null;
        if (info.isErrorIgnored() && info.getErrorTextField() != null && info.getErrorTextField().length() > 0) {
            errorText = "";
        }
        try {
            int fieldnr;
            String[] strings = TextFileInput.convertLineToStrings(textFileLine.line, info);
            for (fieldnr = 0; fieldnr < nrfields; ++fieldnr) {
                Object value;
                block26: {
                    int trim_type;
                    TextFileInputField f = info.getInputFields()[fieldnr];
                    ValueMetaInterface valueMeta = outputRowMeta.getValueMeta(fieldnr);
                    ValueMetaInterface convertMeta = convertRowMeta.getValueMeta(fieldnr);
                    String nullif = fieldnr < nrfields ? f.getNullString() : "";
                    String ifnull = fieldnr < nrfields ? f.getIfNullValue() : "";
                    int n = trim_type = fieldnr < nrfields ? f.getTrimType() : 0;
                    if (fieldnr < strings.length) {
                        String pol = strings[fieldnr];
                        try {
                            value = valueMeta.convertDataFromString(pol, convertMeta, nullif, ifnull, trim_type);
                        }
                        catch (Exception e) {
                            StringBuilder sb;
                            String message = Messages.getString("TextFileInput.Log.CoundNotParseField", valueMeta.toStringMeta(), "" + pol, valueMeta.getConversionMask(), "" + rowNr);
                            if (!info.isErrorIgnored()) {
                                throw new KettleException(message, (Throwable)e);
                            }
                            log.logDetailed(fname, Messages.getString("TextFileInput.Log.Warning") + ": " + message + " : " + e.getMessage(), new Object[0]);
                            value = null;
                            if (errorCount != null) {
                                errorCount = new Long(errorCount + 1L);
                            }
                            if (errorFields != null) {
                                sb = new StringBuilder(errorFields);
                                if (sb.length() > 0) {
                                    sb.append("\t");
                                }
                                sb.append(valueMeta.getName());
                                errorFields = sb.toString();
                            }
                            if (errorText != null) {
                                sb = new StringBuilder(errorText);
                                if (sb.length() > 0) {
                                    sb.append(Const.CR);
                                }
                                sb.append(message);
                                errorText = sb.toString();
                            }
                            if (errorHandler != null) {
                                errorHandler.handleLineError(textFileLine.lineNumber, "NO_PARTS");
                            }
                            if (info.isErrorLineSkipped()) {
                                r = null;
                            }
                            break block26;
                        }
                    }
                    value = null;
                }
                if (r == null) continue;
                r[fieldnr] = value;
            }
            if (fieldnr < nrfields) {
                for (int i = fieldnr; i < info.getInputFields().length; ++i) {
                    r[i] = null;
                }
            }
            int index = nrfields;
            if (errorCount != null) {
                r[index] = errorCount;
                ++index;
            }
            if (errorFields != null) {
                r[index] = errorFields;
                ++index;
            }
            if (errorText != null) {
                r[index] = errorText;
                ++index;
            }
            if (info.includeFilename()) {
                r[index] = fname;
                ++index;
            }
            if (info.includeRowNumber()) {
                r[index] = new Long(rowNr);
                ++index;
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("TextFileInput.Log.Error.ErrorConvertingLineText"), (Throwable)e);
        }
        if (passThruFields != null) {
            return RowDataUtil.addRowData((Object[])passThruFields, (int)nrPassThruFields, (Object[])r);
        }
        return r;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String extra;
        int i;
        Object[] r = null;
        boolean retval = true;
        boolean putrow = false;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            RowMetaInterface[] infoStep = null;
            if (this.meta.isAcceptingFilenames()) {
                this.data.files.getFiles().clear();
                int idx = -1;
                this.data.rowSet = this.findInputRowSet(this.meta.getAcceptingStepName());
                Object[] fileRow = this.getRowFrom(this.data.rowSet);
                while (fileRow != null) {
                    RowMetaInterface prevInfoFields = this.data.rowSet.getRowMeta();
                    if (idx < 0) {
                        if (this.meta.isPassingThruFields()) {
                            this.data.passThruFields = new HashMap();
                            infoStep = new RowMetaInterface[]{prevInfoFields};
                            this.data.nrPassThruFields = prevInfoFields.size();
                        }
                        if ((idx = prevInfoFields.indexOfValue(this.meta.getAcceptingField())) < 0) {
                            this.logError(Messages.getString("TextFileInput.Log.Error.UnableToFindFilenameField", this.meta.getAcceptingField()));
                            this.setErrors(1L);
                            this.stopAll();
                            return false;
                        }
                    }
                    String fileValue = prevInfoFields.getString(fileRow, idx);
                    try {
                        FileObject fileObject = KettleVFS.getFileObject((String)fileValue);
                        this.data.files.addFile(fileObject);
                        if (this.meta.isPassingThruFields()) {
                            this.data.passThruFields.put(fileObject, fileRow);
                        }
                    }
                    catch (IOException e) {
                        this.logError(Messages.getString("TextFileInput.Log.Error.UnableToCreateFileObject", fileValue));
                    }
                    fileRow = this.getRowFrom(this.data.rowSet);
                }
                if (this.data.files.nrOfFiles() == 0) {
                    if (log.isDetailed()) {
                        this.logDetailed(Messages.getString("TextFileInput.Log.Error.NoFilesSpecified"));
                    }
                    this.setOutputDone();
                    return false;
                }
            }
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), infoStep, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.handleMissingFiles();
            if (!this.openNextFile()) {
                this.closeLastFile();
                this.setOutputDone();
                return false;
            }
            for (i = 0; i < this.meta.getInputFields().length; ++i) {
                if (!this.meta.getInputFields()[i].isRepeated()) continue;
                ++this.data.nr_repeats;
            }
        } else if (!this.data.doneReading) {
            int repeats = 1;
            if (this.meta.isLineWrapped()) {
                repeats = this.meta.getNrWraps() > 0 ? this.meta.getNrWraps() : repeats;
            }
            for (i = 0; i < repeats && !this.data.doneReading; ++i) {
                String line = TextFileInput.getLine(log, this.data.isr, this.data.fileFormatType, this.data.lineStringBuilder);
                if (line != null) {
                    boolean isFilterLastLine = false;
                    boolean filterOK = this.checkFilterRow(line, isFilterLastLine);
                    if (filterOK) {
                        this.data.lineBuffer.add(new TextFileLine(line, this.lineNumberInFile, this.data.file));
                        continue;
                    }
                    if (isFilterLastLine) {
                        this.data.doneReading = true;
                    }
                    ++repeats;
                    continue;
                }
                this.data.doneReading = true;
            }
        }
        while (this.data.lineBuffer.size() == 0) {
            if (this.openNextFile()) continue;
            this.closeLastFile();
            this.setOutputDone();
            return false;
        }
        TextFileLine textLine = this.data.lineBuffer.get(0);
        this.incrementLinesInput();
        ++this.lineNumberInFile;
        this.data.lineBuffer.remove(0);
        if (this.meta.isLayoutPaged()) {
            if (!this.data.doneWithHeader && this.data.pageLinesRead == 0) {
                if (log.isRowLevel()) {
                    this.logRowlevel("P-HEADER (" + this.data.headerLinesRead + ") : " + textLine.line);
                }
                ++this.data.headerLinesRead;
                if (this.data.headerLinesRead >= this.meta.getNrHeaderLines()) {
                    this.data.doneWithHeader = true;
                }
            } else if (this.data.pageLinesRead < this.meta.getNrLinesPerPage()) {
                if (this.meta.isLineWrapped()) {
                    for (i = 0; i < this.meta.getNrWraps(); ++i) {
                        extra = "";
                        if (this.data.lineBuffer.size() > 0) {
                            extra = this.data.lineBuffer.get((int)0).line;
                            this.data.lineBuffer.remove(0);
                        }
                        textLine.line = textLine.line + extra;
                    }
                }
                if (log.isRowLevel()) {
                    this.logRowlevel("P-DATA: " + textLine.line);
                }
                ++this.data.pageLinesRead;
                ++this.data.lineInFile;
                long useNumber = this.meta.isRowNumberByFile() ? (long)this.data.lineInFile : this.getLinesWritten() + 1L;
                r = TextFileInput.convertLineToRow(textLine, this.meta, this.data.currentPassThruFieldsRow, this.data.nrPassThruFields, this.data.outputRowMeta, this.data.convertRowMeta, this.data.filename, useNumber, this.data.dataErrorLineHandler);
                if (r != null) {
                    putrow = true;
                }
                if (!this.meta.hasFooter() && this.data.pageLinesRead == this.meta.getNrLinesPerPage()) {
                    this.data.doneWithHeader = false;
                    this.data.headerLinesRead = 0;
                    this.data.pageLinesRead = 0;
                    this.data.footerLinesRead = 0;
                    if (log.isRowLevel()) {
                        this.logRowlevel("RESTART PAGE");
                    }
                }
            } else {
                if (this.meta.hasFooter() && this.data.footerLinesRead < this.meta.getNrFooterLines()) {
                    if (log.isRowLevel()) {
                        this.logRowlevel("P-FOOTER: " + textLine.line);
                    }
                    ++this.data.footerLinesRead;
                }
                if (!this.meta.hasFooter() || this.data.footerLinesRead >= this.meta.getNrFooterLines()) {
                    this.data.doneWithHeader = false;
                    this.data.headerLinesRead = 0;
                    this.data.pageLinesRead = 0;
                    this.data.footerLinesRead = 0;
                    if (log.isRowLevel()) {
                        this.logRowlevel("RESTART PAGE");
                    }
                }
            }
        } else if (!this.data.doneWithHeader) {
            ++this.data.headerLinesRead;
            if (this.data.headerLinesRead >= this.meta.getNrHeaderLines()) {
                this.data.doneWithHeader = true;
            }
        } else if (this.data.doneReading && this.meta.hasFooter() && this.data.lineBuffer.size() < this.meta.getNrFooterLines()) {
            this.data.lineBuffer.clear();
        } else {
            if (this.meta.isLineWrapped()) {
                for (i = 0; i < this.meta.getNrWraps(); ++i) {
                    extra = "";
                    if (this.data.lineBuffer.size() > 0) {
                        extra = this.data.lineBuffer.get((int)0).line;
                        this.data.lineBuffer.remove(0);
                    }
                    textLine.line = textLine.line + extra;
                }
            }
            if (this.data.filePlayList.isProcessingNeeded(textLine.file, textLine.lineNumber, "NO_PARTS")) {
                ++this.data.lineInFile;
                long useNumber = this.meta.isRowNumberByFile() ? (long)this.data.lineInFile : this.getLinesWritten() + 1L;
                r = TextFileInput.convertLineToRow(textLine, this.meta, this.data.currentPassThruFieldsRow, this.data.nrPassThruFields, this.data.outputRowMeta, this.data.convertRowMeta, this.data.filename, useNumber, this.data.dataErrorLineHandler);
                if (r != null) {
                    if (log.isRowLevel()) {
                        this.logRowlevel("Found data row: " + this.data.outputRowMeta.getString(r));
                    }
                    putrow = true;
                }
            } else {
                putrow = false;
            }
        }
        if (putrow && r != null) {
            if (this.data.nr_repeats > 0) {
                if (this.data.previous_row == null) {
                    this.data.previous_row = this.data.outputRowMeta.cloneRow(r);
                } else {
                    int repnr = 0;
                    for (int i2 = 0; i2 < this.meta.getInputFields().length; ++i2) {
                        if (!this.meta.getInputFields()[i2].isRepeated()) continue;
                        if (r[i2] == null) {
                            r[i2] = this.data.previous_row[i2];
                        } else {
                            this.data.previous_row[i2] = r[i2];
                        }
                        ++repnr;
                    }
                }
            }
            if (log.isRowLevel()) {
                this.logRowlevel("Putting row: " + this.data.outputRowMeta.getString(r));
            }
            this.putRow(this.data.outputRowMeta, r);
            if (this.getLinesInput() >= this.meta.getRowLimit() && this.meta.getRowLimit() > 0L) {
                this.closeLastFile();
                this.setOutputDone();
                return false;
            }
        }
        if (this.checkFeedback(this.getLinesInput()) && log.isBasic()) {
            this.logBasic("linenr " + this.getLinesInput());
        }
        return retval;
    }

    private boolean checkFilterRow(String line, boolean isFilterLastLine) {
        boolean filterOK = true;
        if (this.meta.noEmptyLines() && line.length() == 0) {
            filterOK = false;
        } else {
            filterOK = this.data.filterProcessor.doFilters(line);
            if (!filterOK && this.data.filterProcessor.isStopProcessing()) {
                this.data.doneReading = true;
            }
        }
        return filterOK;
    }

    private void handleMissingFiles() throws KettleException {
        List nonAccessibleFiles;
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", "WARNING: Missing " + message, new Object[0]);
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonExistantFiles) {
                    this.data.dataErrorLineHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new KettleException("Following required files are missing: " + message);
            }
        }
        if ((nonAccessibleFiles = this.data.files.getNonAccessibleFiles()).size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", "WARNING: Not accessible " + message, new Object[0]);
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    this.data.dataErrorLineHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new KettleException("Following required files are not accessible: " + message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeLastFile() {
        try {
            try {
                if (this.data.filename != null) {
                    String sFileCompression = this.meta.getFileCompression();
                    if (sFileCompression != null && sFileCompression.equals("Zip")) {
                        this.data.zi.closeEntry();
                        this.data.zi.close();
                    } else if (sFileCompression != null && sFileCompression.equals("GZip")) {
                        this.data.gzi.close();
                    }
                    this.data.fr.close();
                    this.data.isr.close();
                    this.data.filename = null;
                    if (this.data.file != null) {
                        this.data.file.close();
                        this.data.file = null;
                    }
                }
                this.data.dataErrorLineHandler.close();
            }
            catch (Exception e) {
                this.logError("Couldn't close file : " + this.data.filename + " --> " + e.toString());
                this.stopAll();
                this.setErrors(1L);
                boolean bl = false;
                Object var4_4 = null;
                System.gc();
                return bl;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            System.gc();
            throw throwable;
        }
        System.gc();
        return !this.data.isLastFile;
    }

    private boolean openNextFile() {
        try {
            this.lineNumberInFile = 0L;
            if (!this.closeLastFile()) {
                return false;
            }
            if (this.data.files.nrOfFiles() == 0) {
                return false;
            }
            this.data.isLastFile = this.data.filenr == this.data.files.nrOfFiles() - 1;
            this.data.file = this.data.files.getFile(this.data.filenr);
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            this.data.lineInFile = 0;
            if (this.meta.isPassingThruFields()) {
                this.data.currentPassThruFieldsRow = this.data.passThruFields.get(this.data.file);
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("File was read by an Text File input step");
                this.addResultFile(resultFile);
            }
            if (log.isBasic()) {
                this.logBasic("Opening file: " + this.data.filename);
            }
            this.data.fr = KettleVFS.getInputStream((FileObject)this.data.file);
            this.data.dataErrorLineHandler.handleFile(this.data.file);
            String sFileCompression = this.meta.getFileCompression();
            if (sFileCompression != null && sFileCompression.equals("Zip")) {
                if (log.isDetailed()) {
                    this.logDetailed("This is a zipped file");
                }
                this.data.zi = new ZipInputStream(this.data.fr);
                this.data.zi.getNextEntry();
                this.data.isr = this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(this.data.zi, 500), this.meta.getEncoding()) : new InputStreamReader(new BufferedInputStream(this.data.zi, 500));
            } else if (sFileCompression != null && sFileCompression.equals("GZip")) {
                if (log.isDetailed()) {
                    this.logDetailed("This is a gzipped file");
                }
                this.data.gzi = new GZIPInputStream(this.data.fr);
                this.data.isr = this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(this.data.gzi, 500), this.meta.getEncoding()) : new InputStreamReader(new BufferedInputStream(this.data.gzi, 500));
            } else {
                this.data.isr = this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(this.data.fr, 500), this.meta.getEncoding()) : new InputStreamReader(new BufferedInputStream(this.data.fr, 500));
            }
            ++this.data.filenr;
            this.data.doneReading = false;
            int bufferSize = 1;
            bufferSize += this.meta.hasHeader() ? this.meta.getNrHeaderLines() : 0;
            bufferSize += this.meta.isLayoutPaged() ? this.meta.getNrLinesPerPage() : 0;
            bufferSize += this.meta.hasFooter() ? this.meta.getNrFooterLines() : 0;
            if (this.meta.isLayoutPaged()) {
                for (int i = 0; i < this.meta.getNrLinesDocHeader(); ++i) {
                    TextFileInput.getLine(log, this.data.isr, this.data.fileFormatType, this.data.lineStringBuilder);
                    ++this.lineNumberInFile;
                }
            }
            for (int i = 0; i < bufferSize && !this.data.doneReading; ++i) {
                String line = TextFileInput.getLine(log, this.data.isr, this.data.fileFormatType, this.data.lineStringBuilder);
                if (line != null) {
                    if (!this.meta.hasHeader()) {
                        boolean isFilterLastLine = false;
                        boolean filterOK = this.checkFilterRow(line, isFilterLastLine);
                        if (filterOK) {
                            this.data.lineBuffer.add(new TextFileLine(line, this.lineNumberInFile, this.data.file));
                            continue;
                        }
                        ++bufferSize;
                        continue;
                    }
                    if (this.meta.noEmptyLines() && line.length() == 0) continue;
                    this.data.lineBuffer.add(new TextFileLine(line, this.lineNumberInFile, this.data.file));
                    continue;
                }
                this.data.doneReading = true;
            }
            this.data.headerLinesRead = 0;
            this.data.footerLinesRead = 0;
            this.data.pageLinesRead = 0;
            this.data.doneWithHeader = !this.meta.hasHeader();
        }
        catch (Exception e) {
            this.logError("Couldn't open file #" + this.data.filenr + " : " + this.data.filename + " --> " + e.toString());
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileInputMeta)smi;
        this.data = (TextFileInputData)sdi;
        if (super.init(smi, sdi)) {
            this.initErrorHandling();
            this.initReplayFactory();
            this.data.files = this.meta.getTextFileList(this);
            this.data.filterProcessor = new TextFileFilterProcessor(this.meta.getFilter());
            if (!(this.transmeta.getPreviousResult() != null && this.transmeta.getPreviousResult().getResultFiles() != null && this.transmeta.getPreviousResult().getResultFiles().size() != 0 || this.data.files.nrOfMissingFiles() <= 0 || this.meta.isAcceptingFilenames() || this.meta.isErrorIgnored())) {
                this.logError(Messages.getString("TextFileInput.Log.Error.NoFilesSpecified"));
                return false;
            }
            String clusterSize = this.getVariable("Internal.Cluster.Size");
            if (!Const.isEmpty((String)clusterSize) && Integer.valueOf(clusterSize) > 1) {
                String nr = this.getVariable("Internal.Slave.Transformation.Number");
                if (log.isDetailed()) {
                    this.logDetailed("Running on slave server #" + nr + " : assuming that each slave reads a dedicated part of the same file(s).");
                }
            }
            this.data.fileFormatType = this.meta.getFileFormatTypeNr();
            this.data.fileType = this.meta.getFileTypeNr();
            return true;
        }
        return false;
    }

    private void initReplayFactory() {
        Date replayDate = this.getTrans().getReplayDate();
        this.data.filePlayList = replayDate == null ? FilePlayListAll.INSTANCE : new FilePlayListReplay(replayDate, this.meta.getLineNumberFilesDestinationDirectory(), this.meta.getLineNumberFilesExtension(), this.meta.getErrorFilesDestinationDirectory(), this.meta.getErrorLineFilesExtension(), this.meta.getEncoding());
    }

    private void initErrorHandling() {
        ArrayList<FileErrorHandler> dataErrorLineHandlers = new ArrayList<FileErrorHandler>(2);
        if (this.meta.getLineNumberFilesDestinationDirectory() != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerContentLineNumber(this.getTrans().getCurrentDate(), this.meta.getLineNumberFilesDestinationDirectory(), this.meta.getLineNumberFilesExtension(), this.meta.getEncoding(), this));
        }
        if (this.meta.getErrorFilesDestinationDirectory() != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerMissingFiles(this.getTrans().getCurrentDate(), this.meta.getErrorFilesDestinationDirectory(), this.meta.getErrorLineFilesExtension(), this.meta.getEncoding(), this));
        }
        this.data.dataErrorLineHandler = new CompositeFileErrorHandler(dataErrorLineHandlers);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileInputMeta)smi;
        this.data = (TextFileInputData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
        System.gc();
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

