/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.ConfigItemContainerBuilder;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeatureConfig
implements ConfigItem,
ConfigItemContainer,
ConfigItemContainerBuilder<FeatureConfig>,
Cloneable {
    SpecId specId;
    Map<String, String> params = Collections.emptyMap();
    Set<String> unsetParams = Collections.emptySet();
    Set<String> resetParams = Collections.emptySet();
    Map<FeatureId, FeatureDependencySpec> deps = Collections.emptyMap();
    protected List<ConfigItem> items = Collections.emptyList();
    String parentRef;
    String origin;

    public static FeatureConfig newConfig(FeatureId id) throws ProvisioningDescriptionException {
        FeatureConfig config = new FeatureConfig(id.getSpec());
        for (Map.Entry<String, String> param : id.getParams().entrySet()) {
            config.setParam(param.getKey(), param.getValue());
        }
        return config;
    }

    public static FeatureConfig newConfig(String specName) throws ProvisioningDescriptionException {
        return new FeatureConfig(specName);
    }

    public FeatureConfig(FeatureConfig copy) {
        this.specId = copy.specId;
        this.origin = copy.origin;
        this.deps = copy.deps;
        this.parentRef = copy.parentRef;
        this.params = copy.params.size() > 1 ? new HashMap<String, String>(copy.params) : copy.params;
        this.unsetParams = CollectionUtils.clone(copy.unsetParams);
        this.resetParams = CollectionUtils.clone(copy.resetParams);
        if (copy.items.isEmpty()) {
            this.items = copy.items;
            return;
        }
        if (copy.items.size() == 1) {
            if (copy.items.get(0).isGroup()) {
                this.items = copy.items;
                return;
            }
            this.items = Collections.singletonList(new FeatureConfig((FeatureConfig)copy.items.get(0)));
            return;
        }
        ArrayList<ConfigItem> tmp = new ArrayList<ConfigItem>(copy.items.size());
        for (ConfigItem item : copy.items) {
            if (!item.isGroup()) {
                item = new FeatureConfig((FeatureConfig)item);
            }
            tmp.add(item);
        }
        this.items = Collections.unmodifiableList(tmp);
    }

    public FeatureConfig() {
    }

    public FeatureConfig(String specName) throws ProvisioningDescriptionException {
        this.specId = SpecId.fromString(specName);
    }

    public FeatureConfig(SpecId specId) throws ProvisioningDescriptionException {
        this.specId = specId;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    public FeatureConfig setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public FeatureConfig setSpecName(String specName) throws ProvisioningDescriptionException {
        this.specId = SpecId.fromString(specName);
        return this;
    }

    public SpecId getSpecId() {
        return this.specId;
    }

    public String getParentRef() {
        return this.parentRef;
    }

    public FeatureConfig setParentRef(String parentRef) {
        this.parentRef = parentRef;
        return this;
    }

    public boolean hasParams() {
        return !this.params.isEmpty();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public FeatureConfig setParam(String name, String value) {
        this.putParam(name, value);
        return this;
    }

    public String putParam(String name, String value) {
        String prevValue = this.params.get(name);
        this.params = CollectionUtils.put(this.params, name, value);
        if (!this.unsetParams.isEmpty()) {
            this.unsetParams = CollectionUtils.remove(this.unsetParams, name);
        }
        if (!this.resetParams.isEmpty()) {
            this.resetParams = CollectionUtils.remove(this.resetParams, name);
        }
        return prevValue;
    }

    public FeatureConfig unsetParam(String name) {
        this.unsetParams = CollectionUtils.add(this.unsetParams, name);
        this.params = CollectionUtils.remove(this.params, name);
        if (!this.resetParams.isEmpty()) {
            this.resetParams = CollectionUtils.remove(this.resetParams, name);
        }
        return this;
    }

    public boolean hasUnsetParams() {
        return !this.unsetParams.isEmpty();
    }

    public Set<String> getUnsetParams() {
        return this.unsetParams;
    }

    public FeatureConfig resetParam(String name) {
        this.resetParams = CollectionUtils.add(this.resetParams, name);
        this.params = CollectionUtils.remove(this.params, name);
        if (!this.unsetParams.isEmpty()) {
            this.unsetParams = CollectionUtils.remove(this.unsetParams, name);
        }
        return this;
    }

    public boolean hasResetParams() {
        return !this.resetParams.isEmpty();
    }

    public Set<String> getResetParams() {
        return this.resetParams;
    }

    public FeatureConfig addFeatureDep(FeatureId featureId) throws ProvisioningDescriptionException {
        return this.addFeatureDep(FeatureDependencySpec.create(featureId));
    }

    public FeatureConfig addFeatureDep(FeatureDependencySpec dep) throws ProvisioningDescriptionException {
        if (this.deps.containsKey(dep.getFeatureId())) {
            throw new ProvisioningDescriptionException("Duplicate dependency on " + dep.getFeatureId());
        }
        this.deps = CollectionUtils.putLinked(this.deps, dep.getFeatureId(), dep);
        return this;
    }

    public boolean hasFeatureDeps() {
        return !this.deps.isEmpty();
    }

    public Collection<FeatureDependencySpec> getFeatureDeps() {
        return this.deps.values();
    }

    public Set<FeatureId> getFeatureDepIds() {
        return this.deps.keySet();
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    public List<ConfigItem> getItems() {
        return this.items;
    }

    @Override
    public FeatureConfig addConfigItem(ConfigItem item) {
        this.items = CollectionUtils.add(this.items, item);
        return this;
    }

    @Override
    public boolean isResetFeaturePackOrigin() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deps == null ? 0 : this.deps.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.parentRef == null ? 0 : this.parentRef.hashCode());
        result = 31 * result + (this.resetParams == null ? 0 : this.resetParams.hashCode());
        result = 31 * result + (this.specId == null ? 0 : this.specId.hashCode());
        result = 31 * result + (this.unsetParams == null ? 0 : this.unsetParams.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureConfig other = (FeatureConfig)obj;
        if (this.deps == null ? other.deps != null : !this.deps.equals(other.deps)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.parentRef == null ? other.parentRef != null : !this.parentRef.equals(other.parentRef)) {
            return false;
        }
        if (this.resetParams == null ? other.resetParams != null : !this.resetParams.equals(other.resetParams)) {
            return false;
        }
        if (this.specId == null ? other.specId != null : !this.specId.equals(other.specId)) {
            return false;
        }
        return !(this.unsetParams == null ? other.unsetParams != null : !this.unsetParams.equals(other.unsetParams));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.specId);
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        if (!this.params.isEmpty()) {
            buf.append(' ');
            StringUtils.append(buf, this.params.entrySet());
        }
        if (!this.unsetParams.isEmpty()) {
            buf.append(" unset=");
            StringUtils.append(buf, this.unsetParams);
        }
        if (!this.resetParams.isEmpty()) {
            buf.append(" reset=");
            StringUtils.append(buf, this.resetParams);
        }
        if (this.parentRef != null) {
            buf.append(" parentRef=").append(this.parentRef);
        }
        if (!this.deps.isEmpty()) {
            buf.append(" dependencies=");
            StringUtils.append(buf, this.deps.values());
        }
        if (!this.items.isEmpty()) {
            buf.append(" items=");
            StringUtils.appendList(buf, this.items);
        }
        return buf.append(']').toString();
    }
}

