/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.AttributeValue;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

public abstract class BaseXmlWriter<T> {
    protected static void ensureParentDir(Path p) throws IOException {
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
    }

    protected static ElementNode addElement(ElementNode parent, XmlNameProvider e) {
        return BaseXmlWriter.addElement(parent, e.getLocalName(), e.getNamespace());
    }

    protected static ElementNode addElement(ElementNode parent, String localName, String ns) {
        ElementNode eNode = new ElementNode(parent, localName, ns);
        if (parent != null) {
            parent.addChild(eNode);
        }
        return eNode;
    }

    protected static void addAttribute(ElementNode e, XmlNameProvider name, String value) {
        BaseXmlWriter.addAttribute(e, name.getLocalName(), value);
    }

    protected static void addAttribute(ElementNode e, String name, String value) {
        e.addAttribute(name, new AttributeValue(value));
    }

    public void write(T t, Path outputFile) throws XMLStreamException, IOException {
        BaseXmlWriter.ensureParentDir(outputFile);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.write(t, writer);
        }
    }

    public void write(T t, Writer stream) throws XMLStreamException, IOException {
        ElementNode root = this.toElement(t);
        try (FormattingXmlStreamWriter writer = new FormattingXmlStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(stream));){
            writer.writeStartDocument();
            root.marshall(writer);
            writer.writeEndDocument();
        }
    }

    protected abstract ElementNode toElement(T var1) throws XMLStreamException;
}

