/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import com.google.inject.TypeLiteral;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeParameters {
    private static final TypeLiteral<?>[] NO_TYPE_LITERALS = new TypeLiteral[0];
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);

    private TypeParameters() {
    }

    public static TypeLiteral<?>[] get(TypeLiteral<?> genericType) {
        Type type = genericType.getType();
        if (type instanceof ParameterizedType) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            TypeLiteral[] parameters = new TypeLiteral[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameters[i] = TypeParameters.expand(arguments[i]);
            }
            return parameters;
        }
        if (type instanceof GenericArrayType) {
            return new TypeLiteral[]{TypeParameters.expand(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPE_LITERALS;
    }

    public static TypeLiteral<?> get(TypeLiteral<?> genericType, int index) {
        Type type = genericType.getType();
        if (type instanceof ParameterizedType) {
            return TypeParameters.expand(((ParameterizedType)type).getActualTypeArguments()[index]);
        }
        if (type instanceof GenericArrayType) {
            if (0 == index) {
                return TypeParameters.expand(((GenericArrayType)type).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return OBJECT_TYPE_LITERAL;
    }

    private static TypeLiteral<?> expand(Type type) {
        return TypeLiteral.get(type instanceof WildcardType ? ((WildcardType)type).getUpperBounds()[0] : type);
    }

    static {
        new TypeParameters();
    }
}

