/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc.sparc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.sparc.ProcSPARCThreadContext;
import sun.jvm.hotspot.utilities.Assert;

public class ProcSPARCThread
implements ThreadProxy {
    private ProcDebugger debugger;
    private int id;

    public ProcSPARCThread(ProcDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    public ProcSPARCThread(ProcDebugger debugger, long id) {
        this.debugger = debugger;
        this.id = (int)id;
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        ProcSPARCThreadContext context = new ProcSPARCThreadContext(this.debugger);
        long[] regs = this.debugger.getThreadIntegerRegisterSet(this.id);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regs.length == 38, "size of register set must match");
        }
        for (int i = 0; i < regs.length; ++i) {
            context.setRegister(i, regs[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcSPARCThread)) {
            return false;
        }
        return ((ProcSPARCThread)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

