/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.io.DownloadFileTask;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CustomConfigurator {
    private static boolean busy;

    private CustomConfigurator() {
    }

    public static void readXML(String dir, String fileName) {
        CustomConfigurator.readXML(new File(dir, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readXML(File file, Preferences prefs) {
        Class<CustomConfigurator> clazz = CustomConfigurator.class;
        synchronized (CustomConfigurator.class) {
            busy = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            new XMLCommandProcessor(prefs).openAndReadXML(file);
            clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                CustomConfigurator.class.notifyAll();
                busy = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static void readXML(File file) {
        CustomConfigurator.readXML(file, Preferences.main());
    }

    public static void downloadFile(String address, String path, String base) {
        CustomConfigurator.processDownloadOperation(address, path, CustomConfigurator.getDirectoryByAbbr(base), true, false);
    }

    public static void downloadAndUnpackFile(String address, String path, String base) {
        CustomConfigurator.processDownloadOperation(address, path, CustomConfigurator.getDirectoryByAbbr(base), true, true);
    }

    public static void processDownloadOperation(String address, String path, String parentDir, boolean mkdir, boolean unzip) {
        String dir = parentDir;
        if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
            return;
        }
        File fOut = new File(dir, path);
        DownloadFileTask downloadFileTask = new DownloadFileTask(MainApplication.getMainFrame(), address, fOut, mkdir, unzip);
        MainApplication.worker.submit(downloadFileTask);
        PreferencesUtils.log("Info: downloading file from %s to %s in background ", parentDir, fOut.getAbsolutePath());
        if (unzip) {
            PreferencesUtils.log("and unpacking it");
        } else {
            PreferencesUtils.log("");
        }
    }

    public static void messageBox(String type, String text) {
        char c = (type == null || type.isEmpty() ? "plain" : type).charAt(0);
        MainFrame parent = MainApplication.getMainFrame();
        switch (c) {
            case 'i': {
                JOptionPane.showMessageDialog(parent, text, I18n.tr("Information", new Object[0]), 1);
                break;
            }
            case 'w': {
                JOptionPane.showMessageDialog(parent, text, I18n.tr("Warning", new Object[0]), 2);
                break;
            }
            case 'e': {
                JOptionPane.showMessageDialog(parent, text, I18n.tr("Error", new Object[0]), 0);
                break;
            }
            case 'q': {
                JOptionPane.showMessageDialog(parent, text, I18n.tr("Question", new Object[0]), 3);
                break;
            }
            case 'p': {
                JOptionPane.showMessageDialog(parent, text, I18n.tr("Message", new Object[0]), -1);
                break;
            }
            default: {
                Logging.warn("Unsupported messageBox type: " + c);
            }
        }
    }

    public static int askForOption(String text, String opts) {
        if (!opts.isEmpty()) {
            return JOptionPane.showOptionDialog(MainApplication.getMainFrame(), text, "Question", 1, 3, null, opts.split(";"), 0);
        }
        return JOptionPane.showOptionDialog(MainApplication.getMainFrame(), text, "Question", 1, 3, null, null, 2);
    }

    public static String askForText(String text) {
        String s = JOptionPane.showInputDialog(MainApplication.getMainFrame(), text, I18n.tr("Enter text", new Object[0]), 3);
        return s != null ? s.trim() : null;
    }

    public static void exportPreferencesKeysToFile(String filename, boolean append, String ... keys) {
        HashSet<String> keySet = new HashSet<String>();
        Collections.addAll(keySet, keys);
        CustomConfigurator.exportPreferencesKeysToFile(filename, append, keySet);
    }

    public static void exportPreferencesKeysByPatternToFile(String fileName, boolean append, String pattern) {
        ArrayList<String> keySet = new ArrayList<String>();
        Map<String, Setting<?>> allSettings = Preferences.main().getAllSettings();
        for (String key : allSettings.keySet()) {
            if (!key.matches(pattern)) continue;
            keySet.add(key);
        }
        CustomConfigurator.exportPreferencesKeysToFile(fileName, append, keySet);
    }

    public static void exportPreferencesKeysToFile(String filename, boolean append, Collection<String> keys) {
        Element root = null;
        Document document = null;
        Document exportDocument = null;
        try {
            String toXML = Preferences.main().toXML(true);
            DocumentBuilder builder = XmlUtils.newSafeDOMBuilder();
            document = builder.parse(new ByteArrayInputStream(toXML.getBytes(StandardCharsets.UTF_8)));
            exportDocument = builder.newDocument();
            root = document.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logging.log(Logging.LEVEL_WARN, "Error getting preferences to save:", ex);
        }
        if (root == null || exportDocument == null) {
            return;
        }
        try {
            Element newRoot = exportDocument.createElement("config");
            exportDocument.appendChild(newRoot);
            Element prefElem = exportDocument.createElement("preferences");
            prefElem.setAttribute("operation", append ? "append" : "replace");
            newRoot.appendChild(prefElem);
            NodeList childNodes = root.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                String currentKey;
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1 || !keys.contains(currentKey = ((Element)item).getAttribute("key"))) continue;
                Node imported = exportDocument.importNode(item, true);
                prefElem.appendChild(imported);
            }
            File f = new File(filename);
            Transformer ts = XmlUtils.newSafeTransformerFactory().newTransformer();
            ts.setOutputProperty("indent", "yes");
            ts.transform(new DOMSource(exportDocument), new StreamResult(f.toURI().getPath()));
        }
        catch (TransformerException | TransformerFactoryConfigurationError | DOMException ex) {
            Logging.warn("Error saving preferences part:");
            Logging.error(ex);
        }
    }

    public static void deleteFile(String path, String base) {
        String dir = CustomConfigurator.getDirectoryByAbbr(base);
        if (dir == null) {
            PreferencesUtils.log("Error: Can not find base, use base=cache, base=prefs or base=plugins attribute.");
            return;
        }
        PreferencesUtils.log("Delete file: %s\n", path);
        if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
            return;
        }
        File fOut = new File(dir, path);
        if (fOut.exists()) {
            CustomConfigurator.deleteFileOrDirectory(fOut);
        }
    }

    public static void deleteFileOrDirectory(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File f1 : files) {
                CustomConfigurator.deleteFileOrDirectory(f1);
            }
        }
        if (!Utils.deleteFile(f)) {
            PreferencesUtils.log("Warning: Can not delete file " + f.getPath());
        }
    }

    public static void pluginOperation(String install, String uninstall, String delete) {
        ArrayList installList = new ArrayList();
        ArrayList removeList = new ArrayList();
        ArrayList deleteList = new ArrayList();
        Collections.addAll(installList, install.toLowerCase(Locale.ENGLISH).split(";"));
        Collections.addAll(removeList, uninstall.toLowerCase(Locale.ENGLISH).split(";"));
        Collections.addAll(deleteList, delete.toLowerCase(Locale.ENGLISH).split(";"));
        installList.remove("");
        removeList.remove("");
        deleteList.remove("");
        if (!installList.isEmpty()) {
            PreferencesUtils.log("Plugins install: " + installList);
        }
        if (!removeList.isEmpty()) {
            PreferencesUtils.log("Plugins turn off: " + removeList);
        }
        if (!deleteList.isEmpty()) {
            PreferencesUtils.log("Plugins delete: " + deleteList);
        }
        ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask();
        Runnable r = () -> {
            if (task.isCanceled()) {
                return;
            }
            Class<CustomConfigurator> clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                try {
                    while (busy) {
                        CustomConfigurator.class.wait();
                    }
                }
                catch (InterruptedException ex) {
                    Logging.log(Logging.LEVEL_WARN, "InterruptedException while reading local plugin information", ex);
                    Thread.currentThread().interrupt();
                }
                SwingUtilities.invokeLater(() -> {
                    List<PluginInformation> availablePlugins = task.getAvailablePlugins();
                    ArrayList<PluginInformation> toInstallPlugins = new ArrayList<PluginInformation>();
                    ArrayList<PluginInformation> toRemovePlugins = new ArrayList<PluginInformation>();
                    ArrayList<PluginInformation> toDeletePlugins = new ArrayList<PluginInformation>();
                    for (PluginInformation pi1 : availablePlugins) {
                        String name = pi1.name.toLowerCase(Locale.ENGLISH);
                        if (installList.contains(name)) {
                            toInstallPlugins.add(pi1);
                        }
                        if (removeList.contains(name)) {
                            toRemovePlugins.add(pi1);
                        }
                        if (!deleteList.contains(name)) continue;
                        toDeletePlugins.add(pi1);
                    }
                    if (!installList.isEmpty()) {
                        PluginDownloadTask pluginDownloadTask = new PluginDownloadTask((Component)MainApplication.getMainFrame(), toInstallPlugins, I18n.tr("Installing plugins", new Object[0]));
                        MainApplication.worker.submit(pluginDownloadTask);
                    }
                    ArrayList<String> pls = new ArrayList<String>(Config.getPref().getList("plugins"));
                    for (PluginInformation pi2 : toInstallPlugins) {
                        if (pls.contains(pi2.name)) continue;
                        pls.add(pi2.name);
                    }
                    for (PluginInformation pi3 : toRemovePlugins) {
                        pls.remove(pi3.name);
                    }
                    for (PluginInformation pi4 : toDeletePlugins) {
                        pls.remove(pi4.name);
                        Utils.deleteFile(new File(Preferences.main().getPluginsDirectory(), pi4.name + ".jar"));
                    }
                    Config.getPref().putList("plugins", pls);
                });
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        };
        MainApplication.worker.submit(task);
        MainApplication.worker.submit(r);
    }

    private static String getDirectoryByAbbr(String base) {
        String dir = "prefs".equals(base) || base.isEmpty() ? Config.getDirs().getPreferencesDirectory(false).getAbsolutePath() : ("cache".equals(base) ? Config.getDirs().getCacheDirectory(false).getAbsolutePath() : ("plugins".equals(base) ? Preferences.main().getPluginsDirectory().getAbsolutePath() : null));
        return dir;
    }

    public static class XMLCommandProcessor {
        private Preferences mainPrefs;
        private final Map<String, Element> tasksMap = new HashMap<String, Element>();
        private boolean lastV;
        private ScriptEngine engine;

        public void openAndReadXML(File file) {
            PreferencesUtils.log("-- Reading custom preferences from " + file.getAbsolutePath() + " --");
            try {
                String fileDir = file.getParentFile().getAbsolutePath();
                if (fileDir != null) {
                    this.engine.eval("scriptDir='" + XMLCommandProcessor.normalizeDirName(fileDir) + "';");
                }
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    this.openAndReadXML(is);
                }
            }
            catch (IOException | SecurityException | InvalidPathException | ScriptException ex) {
                PreferencesUtils.log(ex, "Error reading custom preferences:");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void openAndReadXML(InputStream is) {
            try {
                Document document = XmlUtils.parseSafeDOM(is);
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    this.processXML(document);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                PreferencesUtils.log(ex, "Error reading custom preferences:");
            }
            {
                PreferencesUtils.log("-- Reading complete --");
                return;
            }
        }

        public XMLCommandProcessor(Preferences mainPrefs) {
            try {
                this.mainPrefs = mainPrefs;
                PreferencesUtils.resetLog();
                this.engine = Utils.getJavaScriptEngine();
                if (this.engine == null) {
                    throw new ScriptException("Failed to retrieve JavaScript engine");
                }
                this.engine.eval("API={}; API.pref={}; API.fragments={};");
                this.engine.eval("homeDir='" + XMLCommandProcessor.normalizeDirName(Config.getDirs().getPreferencesDirectory(false).getAbsolutePath()) + "';");
                this.engine.eval("josmVersion=" + Version.getInstance().getVersion() + ';');
                String className = CustomConfigurator.class.getName();
                this.engine.eval("API.messageBox=" + className + ".messageBox");
                this.engine.eval("API.askText=function(text) { return String(" + className + ".askForText(text));}");
                this.engine.eval("API.askOption=" + className + ".askForOption");
                this.engine.eval("API.downloadFile=" + className + ".downloadFile");
                this.engine.eval("API.downloadAndUnpackFile=" + className + ".downloadAndUnpackFile");
                this.engine.eval("API.deleteFile=" + className + ".deleteFile");
                this.engine.eval("API.plugin =" + className + ".pluginOperation");
                this.engine.eval("API.pluginInstall = function(names) { " + className + ".pluginOperation(names,'','');}");
                this.engine.eval("API.pluginUninstall = function(names) { " + className + ".pluginOperation('',names,'');}");
                this.engine.eval("API.pluginDelete = function(names) { " + className + ".pluginOperation('','',names);}");
            }
            catch (ScriptException ex) {
                PreferencesUtils.log("Error: initializing script engine: " + ex.getMessage());
                Logging.error(ex);
            }
        }

        private void processXML(Document document) {
            this.processXmlFragment(document.getDocumentElement());
        }

        private void processXmlFragment(Element root) {
            NodeList childNodes = root.getChildNodes();
            int nops = childNodes.getLength();
            block30: for (int i = 0; i < nops; ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                String elementName = item.getNodeName();
                Element elem = (Element)item;
                switch (elementName) {
                    case "var": {
                        this.setVar(elem.getAttribute("name"), this.evalVars(elem.getAttribute("value")));
                        continue block30;
                    }
                    case "task": {
                        this.tasksMap.put(elem.getAttribute("name"), elem);
                        continue block30;
                    }
                    case "runtask": {
                        if (!this.processRunTaskElement(elem)) continue block30;
                        return;
                    }
                    case "ask": {
                        this.processAskElement(elem);
                        continue block30;
                    }
                    case "if": {
                        this.processIfElement(elem);
                        continue block30;
                    }
                    case "else": {
                        this.processElseElement(elem);
                        continue block30;
                    }
                    case "break": {
                        return;
                    }
                    case "plugin": {
                        XMLCommandProcessor.processPluginInstallElement(elem);
                        continue block30;
                    }
                    case "messagebox": {
                        this.processMsgBoxElement(elem);
                        continue block30;
                    }
                    case "preferences": {
                        this.processPreferencesElement(elem);
                        continue block30;
                    }
                    case "download": {
                        this.processDownloadElement(elem);
                        continue block30;
                    }
                    case "delete": {
                        this.processDeleteElement(elem);
                        continue block30;
                    }
                    case "script": {
                        this.processScriptElement(elem);
                        continue block30;
                    }
                    default: {
                        PreferencesUtils.log("Error: Unknown element " + elementName);
                    }
                }
            }
        }

        private void processPreferencesElement(Element item) {
            String oper = this.evalVars(item.getAttribute("operation"));
            String id = this.evalVars(item.getAttribute("id"));
            if ("delete-keys".equals(oper)) {
                String pattern = this.evalVars(item.getAttribute("pattern"));
                String key = this.evalVars(item.getAttribute("key"));
                PreferencesUtils.deletePreferenceKey(key, this.mainPrefs);
                PreferencesUtils.deletePreferenceKeyByPattern(pattern, this.mainPrefs);
                return;
            }
            Preferences tmpPref = this.readPreferencesFromDOMElement(item);
            PreferencesUtils.showPrefs(tmpPref);
            if (!id.isEmpty()) {
                try {
                    String fragmentVar = "API.fragments['" + id + "']";
                    this.engine.eval(fragmentVar + "={};");
                    PreferencesUtils.loadPrefsToJS(this.engine, tmpPref, fragmentVar, false);
                }
                catch (ScriptException ex) {
                    PreferencesUtils.log(ex, "Error: can not load preferences fragment:");
                }
            }
            if ("replace".equals(oper)) {
                PreferencesUtils.log("Preferences replace: %d keys: %s\n", tmpPref.getAllSettings().size(), tmpPref.getAllSettings().keySet().toString());
                PreferencesUtils.replacePreferences(tmpPref, this.mainPrefs);
            } else if ("append".equals(oper)) {
                PreferencesUtils.log("Preferences append: %d keys: %s\n", tmpPref.getAllSettings().size(), tmpPref.getAllSettings().keySet().toString());
                PreferencesUtils.appendPreferences(tmpPref, this.mainPrefs);
            } else if ("delete-values".equals(oper)) {
                PreferencesUtils.deletePreferenceValues(tmpPref, this.mainPrefs);
            }
        }

        private void processDeleteElement(Element item) {
            String path = this.evalVars(item.getAttribute("path"));
            String base = this.evalVars(item.getAttribute("base"));
            CustomConfigurator.deleteFile(path, base);
        }

        private void processDownloadElement(Element item) {
            String base = this.evalVars(item.getAttribute("base"));
            String dir = CustomConfigurator.getDirectoryByAbbr(base);
            if (dir == null) {
                PreferencesUtils.log("Error: Can not find directory to place file, use base=cache, base=prefs or base=plugins attribute.");
                return;
            }
            String path = this.evalVars(item.getAttribute("path"));
            if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
                return;
            }
            String address = this.evalVars(item.getAttribute("url"));
            if (address.isEmpty() || path.isEmpty()) {
                PreferencesUtils.log("Error: Please specify url=\"where to get file\" and path=\"where to place it\"");
                return;
            }
            String unzip = this.evalVars(item.getAttribute("unzip"));
            String mkdir = this.evalVars(item.getAttribute("mkdir"));
            CustomConfigurator.processDownloadOperation(address, path, dir, "true".equals(mkdir), "true".equals(unzip));
        }

        private static void processPluginInstallElement(Element elem) {
            String install = elem.getAttribute("install");
            String uninstall = elem.getAttribute("remove");
            String delete = elem.getAttribute("delete");
            CustomConfigurator.pluginOperation(install, uninstall, delete);
        }

        private void processMsgBoxElement(Element elem) {
            String text = this.evalVars(elem.getAttribute("text"));
            String locText = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (!locText.isEmpty()) {
                text = locText;
            }
            String type = this.evalVars(elem.getAttribute("type"));
            CustomConfigurator.messageBox(type, text);
        }

        private void processAskElement(Element elem) {
            String input;
            String var;
            String text = this.evalVars(elem.getAttribute("text"));
            String locText = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (!locText.isEmpty()) {
                text = locText;
            }
            if ((var = elem.getAttribute("var")).isEmpty()) {
                var = "result";
            }
            if ("true".equals(input = this.evalVars(elem.getAttribute("input")))) {
                this.setVar(var, CustomConfigurator.askForText(text));
            } else {
                String opts = this.evalVars(elem.getAttribute("options"));
                String locOpts = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".options"));
                if (!locOpts.isEmpty()) {
                    opts = locOpts;
                }
                this.setVar(var, String.valueOf(CustomConfigurator.askForOption(text, opts)));
            }
        }

        public void setVar(String name, String value) {
            try {
                this.engine.eval(name + "='" + value + "';");
            }
            catch (ScriptException ex) {
                PreferencesUtils.log(ex, String.format("Error: Can not assign variable: %s=%s :", name, value));
            }
        }

        private void processIfElement(Element elem) {
            String realValue = this.evalVars(elem.getAttribute("test"));
            boolean v = false;
            if ("true".equals(realValue) || "false".equals(realValue)) {
                this.processXmlFragment(elem);
                v = true;
            } else {
                PreferencesUtils.log("Error: Illegal test expression in if: %s=%s\n", elem.getAttribute("test"), realValue);
            }
            this.lastV = v;
        }

        private void processElseElement(Element elem) {
            if (!this.lastV) {
                this.processXmlFragment(elem);
            }
        }

        private boolean processRunTaskElement(Element elem) {
            String taskName = elem.getAttribute("name");
            Element task = this.tasksMap.get(taskName);
            if (task == null) {
                PreferencesUtils.log("Error: Can not execute task " + taskName);
                return true;
            }
            PreferencesUtils.log("EXECUTING TASK " + taskName);
            this.processXmlFragment(task);
            return false;
        }

        private void processScriptElement(Element elem) {
            String js = elem.getChildNodes().item(0).getTextContent();
            PreferencesUtils.log("Processing script...");
            try {
                PreferencesUtils.modifyPreferencesByScript(this.engine, this.mainPrefs, js);
            }
            catch (ScriptException ex) {
                CustomConfigurator.messageBox("e", ex.getMessage());
                PreferencesUtils.log(ex, "JS error:");
            }
            PreferencesUtils.log("Script finished");
        }

        private String evalVars(String s) {
            Matcher mr = Pattern.compile("\\$\\{([^\\}]*)\\}").matcher(s);
            StringBuffer sb = new StringBuffer();
            while (mr.find()) {
                try {
                    String result = this.engine.eval(mr.group(1)).toString();
                    mr.appendReplacement(sb, result);
                }
                catch (ScriptException ex) {
                    PreferencesUtils.log(ex, String.format("Error: Can not evaluate expression %s :", mr.group(1)));
                }
            }
            mr.appendTail(sb);
            return sb.toString();
        }

        private Preferences readPreferencesFromDOMElement(Element item) {
            Preferences tmpPref = new Preferences();
            try {
                Transformer xformer = XmlUtils.newSafeTransformerFactory().newTransformer();
                CharArrayWriter outputWriter = new CharArrayWriter(8192);
                StreamResult out = new StreamResult(outputWriter);
                xformer.transform(new DOMSource(item), out);
                String fragmentWithReplacedVars = this.evalVars(outputWriter.toString());
                CharArrayReader reader = new CharArrayReader(fragmentWithReplacedVars.toCharArray());
                tmpPref.fromXML(reader);
            }
            catch (IOException | XMLStreamException | TransformerException ex) {
                PreferencesUtils.log(ex, "Error: can not read XML fragment:");
            }
            return tmpPref;
        }

        private static String normalizeDirName(String dir) {
            String s = dir.replace('\\', '/');
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
    }
}

