/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.pkg.VersionNumber;
import io.foojay.api.discoclient.util.Comparison;
import io.foojay.api.discoclient.util.Error;
import io.foojay.api.discoclient.util.Helper;
import io.foojay.api.discoclient.util.OutputFormat;
import io.foojay.api.discoclient.util.SemVerParser;
import io.foojay.api.discoclient.util.SemVerParsingResult;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SemVer
implements Comparable<SemVer> {
    public static final Pattern EA_PATTERN = Pattern.compile("(ea|EA)((\\.|\\+|\\-)([0-9]+))?");
    public static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\+?(b|B)([0-9]+)");
    private VersionNumber versionNumber;
    private ReleaseStatus releaseStatus;
    private String pre;
    private String preBuild;
    private String metadata;
    private Comparison comparison;

    public SemVer(VersionNumber versionNumber) {
        this(versionNumber, versionNumber.getReleaseStatus() != null && versionNumber.getReleaseStatus().isPresent() ? versionNumber.getReleaseStatus().get() : ReleaseStatus.GA, versionNumber.getPreBuild() != null && versionNumber.getPreBuild().isPresent() ? "-ea." + versionNumber.getPreBuild().getAsInt() : "", versionNumber.getBuild() != null && versionNumber.getBuild().isPresent() ? "+b" + versionNumber.getBuild().getAsInt() : "");
    }

    public SemVer(VersionNumber versionNumber, ReleaseStatus releaseStatus) {
        this(versionNumber, releaseStatus, ReleaseStatus.EA == releaseStatus ? "ea" : "", "");
    }

    public SemVer(VersionNumber versionNumber, String pre, String metadata) {
        this(versionNumber, null != pre && !pre.isEmpty() ? ReleaseStatus.EA : ReleaseStatus.GA, pre, metadata);
    }

    public SemVer(VersionNumber versionNumber, ReleaseStatus releaseStatus, String metadata) {
        this(versionNumber, releaseStatus, ReleaseStatus.EA == releaseStatus ? "ea" : "", metadata);
    }

    public SemVer(VersionNumber versionNumber, ReleaseStatus releaseStatus, String pre, String metadata) {
        this.versionNumber = versionNumber;
        ReleaseStatus releaseStatus2 = this.releaseStatus = versionNumber.getReleaseStatus().isPresent() ? versionNumber.getReleaseStatus().get() : releaseStatus;
        this.pre = null == pre ? (ReleaseStatus.EA == releaseStatus ? "-ea" : "") : pre;
        this.metadata = null == metadata ? "" : metadata;
        this.comparison = Comparison.EQUAL;
        this.preBuild = "";
        if (null != this.versionNumber.getReleaseStatus() && this.versionNumber.getReleaseStatus().isPresent() && this.versionNumber.getReleaseStatus().get() != this.releaseStatus) {
            this.versionNumber.setReleaseStatus(this.releaseStatus);
        }
        if (null != this.pre) {
            MatchResult eaResult;
            List eaResults;
            try (Scanner s = new Scanner(this.pre);){
                eaResults = Helper.findAll(s, EA_PATTERN).collect(Collectors.toList());
            }
            if (eaResults.size() > 0 && null != (eaResult = (MatchResult)eaResults.get(0)).group(1)) {
                this.versionNumber.setReleaseStatus(ReleaseStatus.EA);
                if (null != eaResult.group(4)) {
                    this.preBuild = eaResult.group(4);
                    if (null == this.versionNumber.getPreBuild() || !this.versionNumber.getPreBuild().isPresent()) {
                        this.versionNumber.setPreBuild(Integer.parseInt(this.preBuild));
                    }
                }
            }
        }
        if (!(null == this.pre || this.pre.isEmpty() || this.pre.startsWith("+") || this.pre.startsWith("-"))) {
            this.pre = "-" + pre;
        }
        if (!(null == this.metadata || this.metadata.isEmpty() || this.metadata.startsWith("-") || this.metadata.startsWith("+"))) {
            this.metadata = "+" + metadata;
        }
        if (!this.pre.isEmpty() && !this.pre.startsWith("-")) {
            throw new IllegalArgumentException("pre-release argument has to start with \"-\"");
        }
        if (!this.metadata.isEmpty() && !this.metadata.startsWith("+")) {
            throw new IllegalArgumentException("metadata argument has to start with \"+\"");
        }
        if (ReleaseStatus.EA == this.releaseStatus && !this.pre.isEmpty() && !this.pre.toLowerCase().startsWith("-ea")) {
            throw new IllegalArgumentException("ReleaseStatus and pre-release argument cannot be different");
        }
        if (ReleaseStatus.GA == this.releaseStatus && !this.pre.isEmpty() && this.pre.toLowerCase().startsWith("-ea")) {
            throw new IllegalArgumentException("ReleaseStatus and pre-release argument cannot be different");
        }
        if (null != this.metadata) {
            MatchResult buildNumberResult;
            List buildNumberResults;
            Matcher buildNumberMatcher = BUILD_NUMBER_PATTERN.matcher(this.metadata);
            try (Scanner s = new Scanner(this.metadata);){
                buildNumberResults = Helper.findAll(s, BUILD_NUMBER_PATTERN).collect(Collectors.toList());
            }
            if (!(buildNumberResults.size() <= 0 || null == (buildNumberResult = (MatchResult)buildNumberResults.get(0)).group(1) || null == buildNumberResult.group(2) || null != this.versionNumber.getBuild() && this.versionNumber.getBuild().isPresent())) {
                this.versionNumber.setBuild(Integer.parseInt(buildNumberResult.group(2)));
            }
        }
    }

    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public int getFeature() {
        return this.versionNumber.getFeature().isPresent() ? this.versionNumber.getFeature().getAsInt() : 0;
    }

    public void setFeature(int feature) {
        this.versionNumber.setFeature(feature);
    }

    public int getInterim() {
        return this.versionNumber.getInterim().isPresent() ? this.versionNumber.getInterim().getAsInt() : 0;
    }

    public void setInterim(int interim) {
        this.versionNumber.setInterim(interim);
    }

    public int getUpdate() {
        return this.versionNumber.getUpdate().isPresent() ? this.versionNumber.getUpdate().getAsInt() : 0;
    }

    public void setUpdate(int update) {
        this.versionNumber.setUpdate(update);
    }

    public int getPatch() {
        return this.versionNumber.getPatch().isPresent() ? this.versionNumber.getPatch().getAsInt() : 0;
    }

    public void setPatch(int patch) {
        this.versionNumber.setPatch(patch);
    }

    public int getFifth() {
        return this.versionNumber.getFifth().isPresent() ? this.versionNumber.getFifth().getAsInt() : 0;
    }

    public void setFifth(int fifth) {
        this.versionNumber.setFifth(fifth);
    }

    public int getSixth() {
        return this.versionNumber.getSixth().isPresent() ? this.versionNumber.getSixth().getAsInt() : 0;
    }

    public void setSixth(int sixth) {
        this.versionNumber.setSixth(sixth);
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public MajorVersion getMajorVersion() {
        return new MajorVersion(this.getFeature());
    }

    public String getPre() {
        return this.pre;
    }

    public void setPre(String pre) {
        Error err;
        if (null == pre && pre.length() > 0 && null != (err = this.validatePrerelease(pre))) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.pre = null == pre ? "" : pre;
        this.releaseStatus = null == pre || pre.isEmpty() ? ReleaseStatus.GA : ReleaseStatus.EA;
    }

    public String getPreBuild() {
        return this.preBuild;
    }

    public void setPreBuild(String preBuild) {
        if (preBuild.matches("[0-9]+")) {
            if (preBuild.length() > 1 && preBuild.startsWith("0")) {
                throw new IllegalArgumentException("preBuild cannot starts with 0: " + preBuild);
            }
        } else {
            throw new IllegalArgumentException("Invalid preBuild: " + preBuild);
        }
        this.preBuild = preBuild;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        Error err;
        if (null == metadata && metadata.length() > 0 && null != (err = this.validateMetadata(metadata))) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.metadata = metadata;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public SemVer incSixth() {
        SemVer vNext = this;
        if (null != this.pre && !this.pre.isEmpty()) {
            vNext.setMetadata("");
            vNext.setPre("");
        } else {
            vNext.metadata = "";
            vNext.pre = "";
            vNext.setSixth(this.getSixth() + 1);
        }
        return vNext;
    }

    public SemVer incFifth() {
        SemVer vNext = this;
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setSixth(0);
        vNext.setFifth(this.getFifth() + 1);
        return vNext;
    }

    public SemVer incPatch() {
        SemVer vNext = this;
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setFifth(0);
        vNext.setPatch(this.getPatch() + 1);
        return vNext;
    }

    public SemVer incUpdate() {
        SemVer vNext = this;
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(this.getUpdate() + 1);
        return vNext;
    }

    public SemVer incInterim() {
        SemVer vNext = this;
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(0);
        vNext.setInterim(this.getInterim() + 1);
        return vNext;
    }

    public SemVer incFeature() {
        SemVer vNext = this;
        vNext.setMetadata("");
        vNext.setPre("");
        vNext.setPatch(0);
        vNext.setUpdate(0);
        vNext.setInterim(0);
        vNext.setFeature(this.getFeature() + 1);
        return vNext;
    }

    public boolean lessThan(SemVer semVer) {
        return this.compareTo(semVer) < 0;
    }

    public boolean greaterThan(SemVer semVer) {
        return this.compareTo(semVer) > 0;
    }

    public boolean equalTo(SemVer semVer) {
        return this.compareTo(semVer) == 0;
    }

    public static SemVerParsingResult fromText(String text) {
        return SemVerParser.fromText(text);
    }

    private Error validatePrerelease(String prerelease) {
        String[] eparts;
        for (String p : eparts = prerelease.split(".")) {
            if (p.matches("[0-9]+")) {
                if (p.length() <= 1 || !p.startsWith("0")) continue;
                return new Error("Segment starts with 0: " + p);
            }
            if (p.matches("[a-zA-Z-0-9]+")) continue;
            return new Error("Invalid prerelease: " + prerelease);
        }
        return null;
    }

    private Error validateMetadata(String metadata) {
        String[] eparts;
        for (String p : eparts = metadata.split(".")) {
            if (p.matches("[a-zA-Z-0-9]")) continue;
            return new Error("Invalid metadata: " + metadata);
        }
        return null;
    }

    @Override
    public int compareTo(SemVer semVer) {
        int d = this.compareSegment(this.getFeature(), semVer.getFeature());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getInterim(), semVer.getInterim());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getUpdate(), semVer.getUpdate());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getPatch(), semVer.getPatch());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getFifth(), semVer.getFifth());
        if (d != 0) {
            return d;
        }
        d = this.compareSegment(this.getSixth(), semVer.getSixth());
        if (d != 0) {
            return d;
        }
        if (null != this.pre && this.pre.isEmpty() && null != semVer.getPre() && semVer.getPre().isEmpty()) {
            return 0;
        }
        if (null == this.pre || this.pre.isEmpty()) {
            return 1;
        }
        if (null == semVer.getPre() || semVer.getPre().isEmpty()) {
            return -1;
        }
        return this.comparePrerelease(this.pre, semVer.getPre());
    }

    private int compareSegment(int s1, int s2) {
        if (s1 < s2) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        return 0;
    }

    private int comparePrerelease(String pre1, String pre2) {
        int preParts1Length;
        String[] preParts1 = pre1.split("\\.");
        String[] preParts2 = pre2.split("\\.");
        int preParts2Length = preParts2.length;
        int l = preParts2Length > (preParts1Length = preParts1.length) ? preParts2Length : preParts1Length;
        for (int i = 0; i < l; ++i) {
            int d;
            String tmp1 = "";
            if (i < preParts1Length) {
                tmp1 = preParts1[i];
            }
            String tmp2 = "";
            if (i < preParts2Length) {
                tmp2 = preParts2[i];
            }
            if ((d = this.comparePrePart(tmp1, tmp2)) == 0) continue;
            return d;
        }
        return 0;
    }

    private int comparePrePart(String prePart1, String prePart2) {
        Integer prePart2Number;
        Integer prePart1Number;
        if (prePart1.equals(prePart2)) {
            return 0;
        }
        if (prePart1.isEmpty()) {
            if (!prePart2.isEmpty()) {
                return -1;
            }
            return 1;
        }
        if (prePart2.isEmpty()) {
            if (!prePart1.isEmpty()) {
                return 1;
            }
            return -1;
        }
        try {
            prePart1Number = Integer.valueOf(prePart1);
        }
        catch (NumberFormatException e) {
            prePart1Number = null;
        }
        try {
            prePart2Number = Integer.valueOf(prePart2);
        }
        catch (NumberFormatException e) {
            prePart2Number = null;
        }
        if (null != prePart1Number && null != prePart2Number) {
            if (prePart1Number > prePart2Number) {
                return 1;
            }
            return -1;
        }
        if (null != prePart2Number) {
            return -1;
        }
        if (null != prePart1Number) {
            return 1;
        }
        return -1;
    }

    public String toString(boolean javaFormat) {
        StringBuilder versionBuilder = new StringBuilder();
        versionBuilder.append(Comparison.EQUAL != this.comparison ? this.comparison.getOperator() : "");
        versionBuilder.append(this.versionNumber.toString(OutputFormat.REDUCED, javaFormat, false));
        if (ReleaseStatus.EA == this.releaseStatus) {
            versionBuilder.append("-ea").append(this.preBuild.isEmpty() ? "" : "." + this.preBuild);
        }
        if (null != this.metadata && !this.metadata.isEmpty()) {
            versionBuilder.append(this.metadata.startsWith("+") ? this.metadata : "+" + this.metadata);
        }
        return versionBuilder.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

