/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.editor.structure.api.DocumentModel;

public final class DocumentElement {
    private String name;
    private String type;
    private Position startPos;
    private Position endPos;
    private DocumentModel model;
    private Attributes attributes;
    DocumentElementListener deListener = null;
    HashSet<DocumentElementListener> deListeners = null;
    private static final Attributes EMPTY_ATTRIBUTES = new Attributes();
    private static final int PRINT_MAX_CHARS = 10;

    DocumentElement(String name, String type, Map<String, String> attrsMap, int startOffset, int endOffset, DocumentModel model) throws BadLocationException {
        if (!model.elementsNamesCache.containsKey(name)) {
            model.elementsNamesCache.put(name, name);
        }
        this.name = model.elementsNamesCache.get(name);
        if (!model.elementsTypesCache.containsKey(type)) {
            model.elementsTypesCache.put(type, type);
        }
        this.type = model.elementsTypesCache.get(type);
        this.model = model;
        this.attributes = !attrsMap.isEmpty() ? new Attributes(model, attrsMap) : EMPTY_ATTRIBUTES;
        this.setStartPosition(startOffset);
        this.setEndPosition(endOffset);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Document getDocument() {
        return this.model.getDocument();
    }

    public DocumentElement getElement(int index) {
        List<DocumentElement> children = this.getChildren();
        if (children.size() == 0) {
            return null;
        }
        return this.getChildren().get(index);
    }

    public int getElementCount() {
        return this.getChildren().size();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    public int getElementIndex(int offset) {
        Iterator<DocumentElement> children = this.getChildren().iterator();
        int min_delta = Integer.MAX_VALUE;
        DocumentElement nearest = null;
        while (children.hasNext()) {
            int end_delta;
            DocumentElement de = children.next();
            if (de.getStartOffset() <= offset && de.getEndOffset() > offset) {
                nearest = de;
                break;
            }
            int start_delta = Math.abs(de.getStartOffset() - offset);
            int delta = Math.min(start_delta, end_delta = Math.abs(de.getEndOffset() - offset));
            if (min_delta <= delta) continue;
            nearest = de;
            min_delta = delta;
        }
        if (nearest == null) {
            return -1;
        }
        return this.getChildren().indexOf(nearest);
    }

    public String getName() {
        return this.name;
    }

    public DocumentElement getParentElement() {
        return this.model.getParent(this);
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    void setAttributes(Map<String, String> attrs) {
        this.attributes = new Attributes(this.model, attrs);
    }

    boolean isEmpty() {
        return this.getStartOffset() == this.getEndOffset();
    }

    public DocumentModel getDocumentModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public List<DocumentElement> getChildren() {
        return this.model.getChildren(this);
    }

    public synchronized void addDocumentElementListener(DocumentElementListener del) {
        if (del == null) {
            throw new NullPointerException("The argument cannot be null!");
        }
        if (del == this.deListener || this.deListeners != null && this.deListeners.contains(del)) {
            return;
        }
        if (this.deListeners == null) {
            if (this.deListener == null) {
                this.deListener = del;
            } else {
                this.deListeners = new HashSet();
                this.deListeners.add(this.deListener);
                this.deListeners.add(del);
                this.deListener = null;
            }
        } else {
            this.deListeners.add(del);
        }
    }

    public synchronized void removeDocumentElementListener(DocumentElementListener del) {
        if (del == this.deListener) {
            this.deListener = null;
        } else if (this.deListeners != null) {
            this.deListeners.remove(del);
        }
    }

    void setStartPosition(int offset) throws BadLocationException {
        this.startPos = this.model.getDocument().createPosition(offset);
    }

    void setEndPosition(int offset) throws BadLocationException {
        this.endPos = this.model.getDocument().createPosition(offset);
    }

    String getContent() throws BadLocationException {
        return this.model.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
    }

    private synchronized void fireDocumentElementEvent(DocumentElementEvent dee) {
        if (this.deListener != null) {
            this.fireDocumentElementEvent(this.deListener, dee);
        } else if (this.deListeners != null) {
            for (DocumentElementListener cl : this.deListeners) {
                this.fireDocumentElementEvent(cl, dee);
            }
        }
    }

    private void fireDocumentElementEvent(DocumentElementListener cl, DocumentElementEvent dee) {
        switch (dee.getType()) {
            case 2: {
                cl.elementAdded(dee);
                break;
            }
            case 3: {
                cl.elementRemoved(dee);
                break;
            }
            case 1: {
                cl.contentChanged(dee);
                break;
            }
            case 5: {
                cl.attributesChanged(dee);
            }
        }
    }

    void childAdded(DocumentElement de) {
        this.fireDocumentElementEvent(new DocumentElementEvent(2, this, de));
    }

    void childRemoved(DocumentElement de) {
        this.fireDocumentElementEvent(new DocumentElementEvent(3, this, de));
    }

    void contentChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(1, this, null));
    }

    void attributesChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(5, this, null));
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentElement)) {
            return false;
        }
        DocumentElement de = (DocumentElement)o;
        return de.getName().equals(this.getName()) && de.getType().equals(this.getType()) && de.getStartOffset() == this.getStartOffset() && de.getEndOffset() == this.getEndOffset();
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 29 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 29 * hash + (this.startPos != null ? this.startPos.hashCode() : 0);
        hash = 29 * hash + (this.endPos != null ? this.endPos.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String elementContent = "";
        try {
            elementContent = this.getContent().trim().length() > 10 ? this.getContent().trim().substring(0, 10) + "..." : this.getContent().trim();
        }
        catch (BadLocationException e) {
            elementContent = "error:" + e.getMessage();
        }
        return "DE (" + this.hashCode() + ")[\"" + this.getName() + "\" (" + this.getType() + ") <" + this.getStartOffset() + "-" + this.getEndOffset() + "> '" + this.encodeNewLines(elementContent) + "']";
    }

    private String encodeNewLines(String s) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                encoded.append("\\n");
                continue;
            }
            encoded.append(s.charAt(i));
        }
        return encoded.toString();
    }

    static final class Attributes
    implements AttributeSet {
        private String[] attr_keys;
        private String[] attr_vals;

        Attributes() {
            this.attr_keys = null;
            this.attr_vals = null;
        }

        Attributes(DocumentModel model, Map<String, String> m) {
            this.attr_keys = new String[m.size()];
            this.attr_vals = new String[m.size()];
            this.initAttrs(model, m);
        }

        private void initAttrs(DocumentModel model, Map<String, String> m) {
            int i = 0;
            for (String k : m.keySet()) {
                if (!model.elementsAttrNamesCache.containsKey(k)) {
                    model.elementsAttrNamesCache.put(k, k);
                }
                this.attr_keys[i] = model.elementsAttrNamesCache.get(k);
                String v = m.get(k);
                if (!model.elementsAttrValueCache.containsKey(v)) {
                    model.elementsAttrValueCache.put(v, v);
                }
                this.attr_vals[i++] = model.elementsAttrValueCache.get(v);
            }
        }

        private List<String> keys() {
            if (this.attr_keys == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.attr_keys);
        }

        @Override
        public int getAttributeCount() {
            return this.attr_keys == null ? 0 : this.attr_keys.length;
        }

        @Override
        public boolean isDefined(Object attrName) {
            return this.keys().contains(attrName);
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            if (this.getAttributeCount() != attr.getAttributeCount()) {
                return false;
            }
            return this.containsAttributes(attr);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object key) {
            if (this.attr_keys == null) {
                return null;
            }
            for (int i = 0; i < this.attr_keys.length; ++i) {
                if (!this.attr_keys[i].equals(key)) continue;
                return this.attr_vals[i];
            }
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.keys());
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return value.equals(this.getAttribute(name));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributes) {
            Enumeration<?> e = attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                Object value;
                Object key = e.nextElement();
                if (this.containsAttribute(key, value = attributes.getAttribute(key))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Enumeration<String> e = this.getAttributeNames();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = this.getAttribute(key);
                sb.append((Object)key);
                sb.append('=');
                sb.append(value);
                sb.append(' ');
            }
            return sb.toString();
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        public int compareTo(AttributeSet as) {
            return this.toString().compareTo(as.toString());
        }
    }
}

