/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.support.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class SourceUtils {
    private SourceUtils() {
    }

    public static TypeElement getPublicTopLevelElement(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        FileObject mainFileObject = controller.getFileObject();
        if (mainFileObject == null) {
            throw new IllegalStateException();
        }
        List elements = controller.getTopLevelElements();
        if (elements != null) {
            for (TypeElement element : elements) {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                return element;
            }
        }
        return null;
    }

    public static ClassTree getPublicTopLevelTree(CompilationController controller) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement(controller);
        if (typeElement != null) {
            return controller.getTrees().getTree(typeElement);
        }
        return null;
    }

    public static boolean isSubtype(CompilationController controller, TypeElement subtype, String supertype) {
        TypeMirror typeMirror;
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"subtype", (Object)subtype);
        Parameters.notNull((CharSequence)"supertype", (Object)supertype);
        if (controller.getElements().getTypeElement(supertype) != null && (typeMirror = controller.getTreeUtilities().parseType(supertype, subtype)) != null) {
            return controller.getTypes().isSubtype(subtype.asType(), typeMirror);
        }
        return false;
    }

    static TypeElement classTree2TypeElement(CompilationController controller, ClassTree classTree) {
        assert (controller != null);
        assert (classTree != null);
        TreePath classTreePath = controller.getTrees().getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)controller.getTrees().getElement(classTreePath);
    }

    static ExecutableElement getNoArgConstructor(CompilationController controller, TypeElement typeElement) {
        assert (controller != null);
        assert (typeElement != null);
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (constructor = (ExecutableElement)element).getParameters().size() != 0 || controller.getElementUtilities().isSynthetic((Element)constructor)) continue;
            return constructor;
        }
        return null;
    }
}

